/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.netezza;

import com.cloudera.sqoop.SqoopOptions;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.sqoop.hcat.HCatalogImportTest;
import org.apache.sqoop.hcat.HCatalogTestUtils;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.manager.netezza.NetezzaTestUtils;
import org.junit.Before;

public class DirectNetezzaHCatImportManualTest
extends HCatalogImportTest {
    private NetezzaManager manager;

    @Override
    protected String getConnectString() {
        return NetezzaTestUtils.getNZConnectString();
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected Connection getConnection() {
        try {
            return this.manager.getConnection();
        }
        catch (SQLException sqle) {
            throw new AssertionError((Object)sqle.getMessage());
        }
    }

    @Override
    protected void setExtraArgs(List<String> args) {
        args.add("--direct");
        args.add("--username");
        args.add(NetezzaTestUtils.getNZUser());
        args.add("--password");
        args.add(NetezzaTestUtils.getNZPassword());
        args.add("--num-mappers");
        args.add("1");
        super.setExtraArgs(args);
    }

    public void setUpNZ() {
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        this.manager = new NetezzaManager(options);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.setUpNZ();
    }

    @Override
    public void testIntTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "boolean", 16, HCatFieldSchema.Type.BOOLEAN, 0, 0, Boolean.TRUE, Boolean.TRUE, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "smallint", 4, HCatFieldSchema.Type.INT, 0, 0, 100, 100, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "int", 4, HCatFieldSchema.Type.INT, 0, 0, 1000, 1000, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "bigint", -5, HCatFieldSchema.Type.BIGINT, 0, 0, 10000L, 10000L, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        super.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    @Override
    public void testStringTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "char(14)", 1, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    @Override
    public void testNumberTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "numeric(18,2)", 2, HCatFieldSchema.Type.STRING, 0, 0, "1000.00", new BigDecimal("1000"), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "decimal(18,2)", 3, HCatFieldSchema.Type.STRING, 0, 0, "2000.00", new BigDecimal("2000"), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    @Override
    public void testBinaryTypes() throws Exception {
    }

    @Override
    public void testColumnProjection() throws Exception {
    }

    @Override
    public void testColumnProjectionMissingPartKeys() throws Exception {
    }

    @Override
    public void testStaticPartitioning() throws Exception {
    }

    @Override
    public void testDynamicPartitioning() throws Exception {
    }

    @Override
    public void testStaticAndDynamicPartitioning() throws Exception {
    }

    @Override
    public void testSequenceFile() throws Exception {
    }

    @Override
    public void testTextFile() throws Exception {
    }

    @Override
    public void testTableCreation() throws Exception {
    }

    @Override
    public void testTableCreationWithPartition() throws Exception {
    }

    @Override
    public void testTableCreationWithStorageStanza() throws Exception {
    }

    @Override
    public void testHiveDropDelims() throws Exception {
    }

    @Override
    public void testHiveDelimsReplacement() throws Exception {
    }

    @Override
    public void testDynamicKeyInMiddle() throws Exception {
    }

    @Override
    public void testCreateTableWithPreExistingTable() throws Exception {
    }
}

