/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;

public abstract class AccumuloTestCase
extends ImportJobTestCase {
    private static final String ACCUMULO_USER = "root";
    private static final String ACCUMULO_PASSWORD = "rootroot";
    private static String testBuildDataProperty = "";
    public static final Log LOG = LogFactory.getLog((String)AccumuloTestCase.class.getName());
    protected static MiniAccumuloCluster accumuloCluster;
    protected static File tempDir;

    private static void recordTestBuildDataProperty() {
        testBuildDataProperty = System.getProperty("test.build.data", "");
    }

    private static void restoreTestBuidlDataProperty() {
        System.setProperty("test.build.data", testBuildDataProperty);
    }

    protected String[] getArgv(String accumuloTable, String accumuloColFam, boolean accumuloCreate, String queryStr) {
        ArrayList<String> args = new ArrayList<String>();
        if (null != queryStr) {
            args.add("--query");
            args.add(queryStr);
        } else {
            args.add("--table");
            args.add(this.getTableName());
        }
        args.add("--split-by");
        args.add(this.getColName(0));
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--num-mappers");
        args.add("1");
        args.add("--accumulo-column-family");
        args.add(accumuloColFam);
        args.add("--accumulo-table");
        args.add(accumuloTable);
        if (accumuloCreate) {
            args.add("--accumulo-create-table");
        }
        args.add("--accumulo-instance");
        args.add(accumuloCluster.getInstanceName());
        args.add("--accumulo-zookeepers");
        args.add(accumuloCluster.getZooKeepers());
        args.add("--accumulo-user");
        args.add(ACCUMULO_USER);
        args.add("--accumulo-password");
        args.add(ACCUMULO_PASSWORD);
        return args.toArray(new String[0]);
    }

    protected static void setUpCluster() throws Exception {
        File temp = File.createTempFile("test", "tmp");
        tempDir = new File(temp.getParent(), "accumulo" + System.currentTimeMillis());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        temp.delete();
        accumuloCluster = new MiniAccumuloCluster(tempDir, ACCUMULO_PASSWORD);
        accumuloCluster.start();
    }

    protected static void cleanUpCluster() throws Exception {
        accumuloCluster.stop();
        AccumuloTestCase.delete(tempDir);
    }

    protected static void delete(File dir) {
        if (dir.isDirectory()) {
            File[] kids;
            for (File f : kids = dir.listFiles()) {
                if (f.isDirectory()) {
                    AccumuloTestCase.delete(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    @Override
    @Before
    public void setUp() {
        try {
            AccumuloTestCase.setUpCluster();
        }
        catch (Exception e) {
            LOG.error((Object)"Error setting up MiniAccumuloCluster.", (Throwable)e);
        }
        AccumuloTestCase.recordTestBuildDataProperty();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            AccumuloTestCase.cleanUpCluster();
        }
        catch (Exception e) {
            LOG.error((Object)"Error stopping MiniAccumuloCluster.", (Throwable)e);
        }
    }

    protected void verifyAccumuloCell(String tableName, String rowKey, String colFamily, String colName, String val) throws IOException {
        try {
            ZooKeeperInstance inst = new ZooKeeperInstance(accumuloCluster.getInstanceName(), accumuloCluster.getZooKeepers());
            Connector conn = inst.getConnector(ACCUMULO_USER, (AuthenticationToken)new PasswordToken((CharSequence)ACCUMULO_PASSWORD));
            Scanner scanner = conn.createScanner(tableName, Constants.NO_AUTHS);
            scanner.setRange(new Range((CharSequence)rowKey));
            for (Map.Entry entry : scanner) {
                String columnFamily = ((Key)entry.getKey()).getColumnFamily().toString();
                String qual = ((Key)entry.getKey()).getColumnQualifier().toString();
                if (!columnFamily.equals(colFamily) || !qual.equals(colName)) continue;
                String value = ((Value)entry.getValue()).toString();
                if (null == val) {
                    AccumuloTestCase.assertNull((String)"Got a result when expected null", (Object)value);
                    continue;
                }
                AccumuloTestCase.assertNotNull((String)"No result, but we expected one", (Object)value);
                AccumuloTestCase.assertEquals((String)val, (String)value);
            }
        }
        catch (AccumuloException e) {
            throw new IOException("AccumuloException in verifyAccumuloCell", e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException("AccumuloSecurityException in verifyAccumuloCell", e);
        }
        catch (TableNotFoundException e) {
            throw new IOException("TableNotFoundException in verifyAccumuloCell", e);
        }
    }
}

