/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestHsqldbManager
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestHsqldbManager.class.getName());
    private HsqldbTestServer testServer;
    private ConnManager manager;

    @Before
    public void setUp() {
        this.testServer = new HsqldbTestServer();
        try {
            this.testServer.resetServer();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestHsqldbManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("Could not find class for db driver: " + cnfe.toString()));
            TestHsqldbManager.fail((String)("Could not find class for db driver: " + cnfe.toString()));
        }
        this.manager = this.testServer.getManager();
    }

    @After
    public void tearDown() {
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestHsqldbManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testListDatabases() {
        String[] databases = this.manager.listDatabases();
        TestHsqldbManager.assertNotNull((String)"manager returned no database list", (Object)databases);
        TestHsqldbManager.assertEquals((String)"Database list should be length 1", (int)1, (int)databases.length);
        TestHsqldbManager.assertEquals((String)HsqldbTestServer.getSchemaName(), (String)databases[0]);
    }
}

