/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import junit.framework.TestCase;

public class TestFieldFormatter
extends TestCase {
    public void testAllEmpty() {
        String result = FieldFormatter.escapeAndEnclose((String)"", (DelimiterSet)new DelimiterSet('\u0000', '\u0000', '\u0000', '\u0000', false));
        TestFieldFormatter.assertEquals((String)"", (String)result);
    }

    public void testNullArgs() {
        TestFieldFormatter.assertNull((Object)FieldFormatter.escapeAndEnclose(null, (DelimiterSet)new DelimiterSet('\"', '\u0000', '\"', '\\', false)));
    }

    public void testBasicStr() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo", (DelimiterSet)DelimiterSet.DEFAULT_DELIMITERS);
        TestFieldFormatter.assertEquals((String)"foo", (String)result);
    }

    public void testEscapeSlash() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\\bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\\\bar", (String)result);
    }

    public void testMustEnclose() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\u0000', true));
        TestFieldFormatter.assertEquals((String)"\"foo\"", (String)result);
    }

    public void testEncloseComma1() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo,bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"\"foo,bar\"", (String)result);
    }

    public void testEncloseComma2() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo,bar", (DelimiterSet)new DelimiterSet(',', ',', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"\"foo,bar\"", (String)result);
    }

    public void testNoNeedToEnclose() {
        String result = FieldFormatter.escapeAndEnclose((String)"just another string", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"just another string", (String)result);
    }

    public void testCannotEnclose() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo,bar", (DelimiterSet)new DelimiterSet(',', '\n', '\u0000', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\,bar", (String)result);
    }

    public void testEmptyCharToEscapeString() {
        char nul = '\u0000';
        String s = "" + nul;
        TestFieldFormatter.assertEquals((String)"\u0000", (String)s);
    }

    public void testEscapeCentralQuote() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\"bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\\"bar", (String)result);
    }

    public void testEscapeMultiCentralQuote() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\"\"bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\\"\\\"bar", (String)result);
    }

    public void testDoubleEscape() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\\\"bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\\\\\\"bar", (String)result);
    }

    public void testReverseEscape() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\"\\bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"foo\\\"\\\\bar", (String)result);
    }

    public void testQuotedEncloser() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\",bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"\"foo\\\",bar\"", (String)result);
    }

    public void testQuotedEscape() {
        String result = FieldFormatter.escapeAndEnclose((String)"foo\\,bar", (DelimiterSet)new DelimiterSet(',', '\n', '\"', '\\', false));
        TestFieldFormatter.assertEquals((String)"\"foo\\\\,bar\"", (String)result);
    }
}

