/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class ReparseMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, Text, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)ReparseMapper.class.getName());
    public static final String USER_TYPE_NAME_KEY = "sqoop.user.class";
    private SqoopRecord userRecord;

    public void configure(JobConf job) {
        String userTypeName = job.get(USER_TYPE_NAME_KEY);
        if (null == userTypeName) {
            throw new RuntimeException("Unconfigured parameter: sqoop.user.class");
        }
        LOG.info((Object)("User type name set to " + userTypeName));
        this.userRecord = null;
        try {
            Configuration conf = new Configuration();
            Class<?> userClass = Class.forName(userTypeName, true, Thread.currentThread().getContextClassLoader());
            this.userRecord = (SqoopRecord)ReflectionUtils.newInstance(userClass, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("ClassNotFound exception: " + cnfe.toString()));
        }
        catch (Exception e) {
            LOG.error((Object)("Got an exception reflecting user class: " + e.toString()));
        }
        if (null == this.userRecord) {
            LOG.error((Object)("Could not instantiate user record of type " + userTypeName));
            throw new RuntimeException("Could not instantiate user record of type " + userTypeName);
        }
    }

    public void map(LongWritable key, Text val, OutputCollector<Text, NullWritable> out, Reporter r) throws IOException {
        LOG.info((Object)("Mapper input line: " + val.toString()));
        try {
            this.userRecord.parse(val);
        }
        catch (RecordParser.ParseError pe) {
            LOG.error((Object)("Got parse error: " + pe.toString()));
            throw new IOException(pe);
        }
        LOG.info((Object)("Mapper output line: " + this.userRecord.toString()));
        out.collect((Object)new Text(this.userRecord.toString()), (Object)NullWritable.get());
        if (!this.userRecord.toString(false).equals(val.toString())) {
            throw new IOException("Returned string w/o EOR has value [" + this.userRecord.toString(false) + "] when [" + val.toString() + "] was expected.");
        }
        if (!this.userRecord.toString().equals(val.toString() + "\n")) {
            throw new IOException("Returned string has value [" + this.userRecord.toString() + "] when [" + val.toString() + "\n] was expected.");
        }
    }
}

