/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.junit.Test;

public class TestOraOopUtilities
extends OraOopTestCase {
    @Test
    public void testdecodeOracleTableName() {
        OracleTable context = null;
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"junk", null);
        Assert.assertEquals((String)context.getSchema(), (String)"ORAOOP");
        Assert.assertEquals((String)context.getName(), (String)"JUNK");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"\"Junk\"", null);
        Assert.assertEquals((String)context.getSchema(), (String)"ORAOOP");
        Assert.assertEquals((String)context.getName(), (String)"Junk");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"targusr.junk", null);
        Assert.assertEquals((String)context.getSchema(), (String)"TARGUSR");
        Assert.assertEquals((String)context.getName(), (String)"JUNK");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"targusr.\"Junk\"", null);
        Assert.assertEquals((String)context.getSchema(), (String)"TARGUSR");
        Assert.assertEquals((String)context.getName(), (String)"Junk");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"\"Targusr\".junk", null);
        Assert.assertEquals((String)context.getSchema(), (String)"Targusr");
        Assert.assertEquals((String)context.getName(), (String)"JUNK");
        String inputStr = "\"Targusr\".\"Junk\"";
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)inputStr, null);
        Assert.assertEquals((String)context.getSchema(), (String)"Targusr");
        Assert.assertEquals((String)context.getName(), (String)"Junk");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"\"targ.usr\".junk", null);
        Assert.assertEquals((String)context.getSchema(), (String)"targ.usr");
        Assert.assertEquals((String)context.getName(), (String)"JUNK");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"targusr.\"junk.tab.with.dots\"", null);
        Assert.assertEquals((String)context.getSchema(), (String)"TARGUSR");
        Assert.assertEquals((String)context.getName(), (String)"junk.tab.with.dots");
        context = OraOopUtilities.decodeOracleTableName((String)"oraoop", (String)"\"targ.usr\".\"junk.tab.with.dots\"", null);
        Assert.assertEquals((String)context.getSchema(), (String)"targ.usr");
        Assert.assertEquals((String)context.getName(), (String)"junk.tab.with.dots");
    }

    @Test
    public void testgetCurrentMethodName() {
        String actual = OraOopUtilities.getCurrentMethodName();
        String expected = "testgetCurrentMethodName()";
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testgenerateDataChunkId() {
        String expected = "1_1";
        String actual = OraOopUtilities.generateDataChunkId((int)1, (int)1);
        Assert.assertEquals((String)expected, (String)actual);
        expected = "1234_99";
        actual = OraOopUtilities.generateDataChunkId((int)1234, (int)99);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testgetDuplicatedStringArrayValues() {
        try {
            OraOopUtilities.getDuplicatedStringArrayValues(null, (boolean)false);
            Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        String[] duplicates = null;
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[0], (boolean)false);
        Assert.assertEquals((int)0, (int)duplicates.length);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"a", "b", "c"}, (boolean)false);
        Assert.assertEquals((int)0, (int)duplicates.length);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"a", "A", "b"}, (boolean)false);
        Assert.assertEquals((int)0, (int)duplicates.length);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"a", "A", "b"}, (boolean)true);
        Assert.assertEquals((int)1, (int)duplicates.length);
        Assert.assertEquals((String)"A", (String)duplicates[0]);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"A", "a", "b"}, (boolean)true);
        Assert.assertEquals((int)1, (int)duplicates.length);
        Assert.assertEquals((String)"a", (String)duplicates[0]);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"A", "a", "b", "A"}, (boolean)false);
        Assert.assertEquals((int)1, (int)duplicates.length);
        Assert.assertEquals((String)"A", (String)duplicates[0]);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"A", "a", "b", "A"}, (boolean)true);
        Assert.assertEquals((int)2, (int)duplicates.length);
        Assert.assertEquals((String)"a", (String)duplicates[0]);
        Assert.assertEquals((String)"A", (String)duplicates[1]);
        duplicates = OraOopUtilities.getDuplicatedStringArrayValues((String[])new String[]{"A", "a", "b", "A", "A"}, (boolean)true);
        Assert.assertEquals((int)2, (int)duplicates.length);
        Assert.assertEquals((String)"a", (String)duplicates[0]);
        Assert.assertEquals((String)"A", (String)duplicates[1]);
    }

    @Test
    public void testgetFullExceptionMessage() {
        try {
            try {
                try {
                    throw new IOException("lorem ipsum!");
                }
                catch (IOException ex) {
                    throw new SQLException("dolor sit amet", ex);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException("consectetur adipisicing elit", ex);
            }
        }
        catch (Exception ex) {
            String msg = OraOopUtilities.getFullExceptionMessage((Exception)ex);
            if (!msg.contains("IOException") || !msg.contains("lorem ipsum!")) {
                Assert.fail((String)"Inner exception text has not been included in the message");
            }
            if (!msg.contains("SQLException") || !msg.contains("dolor sit amet")) {
                Assert.fail((String)"Inner exception text has not been included in the message");
            }
            if (!msg.contains("RuntimeException") || !msg.contains("consectetur adipisicing elit")) {
                Assert.fail((String)"Outer exception text has not been included in the message");
            }
            return;
        }
    }

    @Test
    public void testGetOraOopOracleDataChunkMethod() {
        try {
            OraOopUtilities.getOraOopOracleDataChunkMethod(null);
            Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Configuration conf = new Configuration();
        OraOopConstants.OraOopOracleDataChunkMethod dataChunkMethod = OraOopUtilities.getOraOopOracleDataChunkMethod((Configuration)conf);
        Assert.assertEquals((Object)OraOopConstants.OraOopOracleDataChunkMethod.ROWID, (Object)dataChunkMethod);
        OraOopUtilities.LOG.setCacheLogEntries(true);
        OraOopUtilities.LOG.clearCache();
        conf.set("oraoop.chunk.method", "loremipsum");
        dataChunkMethod = OraOopUtilities.getOraOopOracleDataChunkMethod((Configuration)conf);
        String logText = OraOopUtilities.LOG.getLogEntries();
        OraOopUtilities.LOG.setCacheLogEntries(false);
        if (!logText.toLowerCase().contains("loremipsum")) {
            Assert.fail((String)"The LOG should inform the user they've selected an invalid data chunk method - and what that was.");
        }
        Assert.assertEquals((String)"Should have used the default value", (Object)OraOopConstants.ORAOOP_ORACLE_DATA_CHUNK_METHOD_DEFAULT, (Object)dataChunkMethod);
        conf.set("oraoop.chunk.method", "partition");
        dataChunkMethod = OraOopUtilities.getOraOopOracleDataChunkMethod((Configuration)conf);
        Assert.assertEquals((Object)OraOopConstants.OraOopOracleDataChunkMethod.PARTITION, (Object)dataChunkMethod);
    }

    @Test
    public void testgetOraOopOracleBlockToSplitAllocationMethod() {
        try {
            OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod(null, (OraOopConstants.OraOopOracleBlockToSplitAllocationMethod)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.RANDOM);
            Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Configuration conf = new Configuration();
        OraOopConstants.OraOopOracleBlockToSplitAllocationMethod allocationMethod = OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod((Configuration)conf, (OraOopConstants.OraOopOracleBlockToSplitAllocationMethod)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.RANDOM);
        Assert.assertEquals((Object)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.RANDOM, (Object)allocationMethod);
        allocationMethod = OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod((Configuration)conf, (OraOopConstants.OraOopOracleBlockToSplitAllocationMethod)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL);
        Assert.assertEquals((Object)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL, (Object)allocationMethod);
        OraOopUtilities.LOG.setCacheLogEntries(true);
        OraOopUtilities.LOG.clearCache();
        conf.set("oraoop.block.allocation", "loremipsum");
        allocationMethod = OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod((Configuration)conf, (OraOopConstants.OraOopOracleBlockToSplitAllocationMethod)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL);
        String logText = OraOopUtilities.LOG.getLogEntries();
        OraOopUtilities.LOG.setCacheLogEntries(false);
        if (!logText.toLowerCase().contains("loremipsum")) {
            Assert.fail((String)"The LOG should inform the user they've selected an invalid allocation method - and what that was.");
        }
        if (!logText.contains("ROUNDROBIN or SEQUENTIAL or RANDOM")) {
            Assert.fail((String)"The LOG should inform the user what the valid choices are.");
        }
        conf.set("oraoop.block.allocation", "sequential");
        allocationMethod = OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethod((Configuration)conf, (OraOopConstants.OraOopOracleBlockToSplitAllocationMethod)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL);
        Assert.assertEquals((Object)OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL, (Object)allocationMethod);
    }

    @Test
    public void testgetOraOopTableImportWhereClauseLocation() {
        try {
            OraOopUtilities.getOraOopTableImportWhereClauseLocation(null, (OraOopConstants.OraOopTableImportWhereClauseLocation)OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT);
            Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Configuration conf = new Configuration();
        OraOopConstants.OraOopTableImportWhereClauseLocation location = OraOopUtilities.getOraOopTableImportWhereClauseLocation((Configuration)conf, (OraOopConstants.OraOopTableImportWhereClauseLocation)OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT);
        Assert.assertEquals((Object)OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT, (Object)location);
        OraOopUtilities.LOG.setCacheLogEntries(true);
        OraOopUtilities.LOG.clearCache();
        conf.set("oraoop.table.import.where.clause.location", "loremipsum");
        location = OraOopUtilities.getOraOopTableImportWhereClauseLocation((Configuration)conf, (OraOopConstants.OraOopTableImportWhereClauseLocation)OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT);
        String logText = OraOopUtilities.LOG.getLogEntries();
        OraOopUtilities.LOG.setCacheLogEntries(false);
        if (!logText.toLowerCase().contains("loremipsum")) {
            Assert.fail((String)"The LOG should inform the user they've selected an invalid where-clause-location - and what that was.");
        }
        if (!logText.contains("SUBSPLIT or SPLIT")) {
            Assert.fail((String)"The LOG should inform the user what the valid choices are.");
        }
        conf.set("oraoop.table.import.where.clause.location", "split");
        location = OraOopUtilities.getOraOopTableImportWhereClauseLocation((Configuration)conf, (OraOopConstants.OraOopTableImportWhereClauseLocation)OraOopConstants.OraOopTableImportWhereClauseLocation.SUBSPLIT);
        Assert.assertEquals((Object)OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT, (Object)location);
    }

    @Test
    public void testpadLeft() {
        String expected = "   a";
        String actual = OraOopUtilities.padLeft((String)"a", (int)4);
        Assert.assertEquals((String)expected, (String)actual);
        expected = "abcd";
        actual = OraOopUtilities.padLeft((String)"abcd", (int)3);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testpadRight() {
        String expected = "a   ";
        String actual = OraOopUtilities.padRight((String)"a", (int)4);
        Assert.assertEquals((String)expected, (String)actual);
        expected = "abcd";
        actual = OraOopUtilities.padRight((String)"abcd", (int)3);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testReplaceConfigurationExpression() {
        Configuration conf = new Configuration();
        String actual = OraOopUtilities.replaceConfigurationExpression((String)"alter session set timezone = '{oracle.sessionTimeZone|GMT}';", (Configuration)conf);
        String expected = "alter session set timezone = 'GMT';";
        Assert.assertEquals((String)"OraOop configuration expression failure.", (String)expected, (String)actual);
        conf.set("oracle.sessionTimeZone", "Africa/Algiers");
        actual = OraOopUtilities.replaceConfigurationExpression((String)"alter session set timezone = '{oracle.sessionTimeZone|GMT}';", (Configuration)conf);
        expected = "alter session set timezone = 'Africa/Algiers';";
        Assert.assertEquals((String)"OraOop configuration expression failure.", (String)expected, (String)actual);
        conf.set("expr1", "1");
        conf.set("expr2", "2");
        conf.set("expr3", "3");
        conf.set("expr4", "4");
        actual = OraOopUtilities.replaceConfigurationExpression((String)"set {expr1}={expr2};", (Configuration)conf);
        expected = "set 1=2;";
        Assert.assertEquals((String)"OraOop configuration expression failure.", (String)expected, (String)actual);
        actual = OraOopUtilities.replaceConfigurationExpression((String)"set {expr4|0}={expr5|5};", (Configuration)conf);
        expected = "set 4=5;";
        Assert.assertEquals((String)"OraOop configuration expression failure.", (String)expected, (String)actual);
    }

    @Test
    public void testStackContainsClass() {
        String expected;
        if (OraOopUtilities.stackContainsClass((String)"lorem.ipsum.dolor")) {
            Assert.fail((String)"There's no way the stack actually contains this!");
        }
        if (!OraOopUtilities.stackContainsClass((String)(expected = "org.apache.sqoop.manager.oracle.TestOraOopUtilities"))) {
            Assert.fail((String)("The stack should contain the class:" + expected));
        }
    }

    @Test
    public void testGetImportHint() {
        Configuration conf = new Configuration();
        String hint = OraOopUtilities.getImportHint((Configuration)conf);
        Assert.assertEquals((String)"Default import hint", (String)"/*+ NO_INDEX(t) */ ", (String)hint);
        conf.set("oraoop.import.hint", "NO_INDEX(t) SCN_ASCENDING");
        hint = OraOopUtilities.getImportHint((Configuration)conf);
        Assert.assertEquals((String)"Changed import hint", (String)"/*+ NO_INDEX(t) SCN_ASCENDING */ ", (String)hint);
        conf.set("oraoop.import.hint", "       ");
        hint = OraOopUtilities.getImportHint((Configuration)conf);
        Assert.assertEquals((String)"Whitespace import hint", (String)"", (String)hint);
        conf.set("oraoop.import.hint", "");
        hint = OraOopUtilities.getImportHint((Configuration)conf);
        Assert.assertEquals((String)"Blank import hint", (String)"", (String)hint);
    }

    @Test
    public void testSplitStringList() {
        List result = null;
        ArrayList<String> expected = null;
        expected = new ArrayList<String>();
        expected.add("abcde");
        expected.add("ghijklm");
        result = OraOopUtilities.splitStringList((String)"abcde,ghijklm");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("\"abcde\"");
        expected.add("\"ghijklm\"");
        result = OraOopUtilities.splitStringList((String)"\"abcde\",\"ghijklm\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("abcde");
        expected.add("\"ghijklm\"");
        result = OraOopUtilities.splitStringList((String)"abcde,\"ghijklm\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("\"abcde\"");
        expected.add("ghijklm");
        result = OraOopUtilities.splitStringList((String)"\"abcde\",ghijklm");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("\"ab,cde\"");
        expected.add("ghijklm");
        result = OraOopUtilities.splitStringList((String)"\"ab,cde\",ghijklm");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("abcde");
        expected.add("\"ghi,jklm\"");
        result = OraOopUtilities.splitStringList((String)"abcde,\"ghi,jklm\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("\"ab,cde\"");
        expected.add("\"ghi,jklm\"");
        result = OraOopUtilities.splitStringList((String)"\"ab,cde\",\"ghi,jklm\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("\"ab,cde\"");
        expected.add("\"ghi,jklm\"");
        expected.add("\",Lorem\"");
        expected.add("\"ip!~sum\"");
        expected.add("\"do,lo,,r\"");
        expected.add("\"s#it\"");
        expected.add("\"am$e$t\"");
        result = OraOopUtilities.splitStringList((String)"\"ab,cde\",\"ghi,jklm\",\",Lorem\",\"ip!~sum\",\"do,lo,,r\",\"s#it\",\"am$e$t\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("LOREM");
        expected.add("IPSUM");
        expected.add("DOLOR");
        expected.add("SIT");
        expected.add("AMET");
        result = OraOopUtilities.splitStringList((String)"LOREM,IPSUM,DOLOR,SIT,AMET");
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSplitOracleStringList() {
        List result = null;
        ArrayList<String> expected = null;
        expected = new ArrayList<String>();
        expected.add("LOREM");
        expected.add("IPSUM");
        expected.add("DOLOR");
        expected.add("SIT");
        expected.add("AMET");
        result = OraOopUtilities.splitOracleStringList((String)"lorem,ipsum,dolor,sit,amet");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("LOREM");
        expected.add("ipsum");
        expected.add("dolor");
        expected.add("SIT");
        expected.add("amet");
        result = OraOopUtilities.splitOracleStringList((String)"lorem,\"ipsum\",\"dolor\",sit,\"amet\"");
        Assert.assertEquals(expected, (Object)result);
        expected = new ArrayList();
        expected.add("LOREM");
        expected.add("ip,sum");
        expected.add("dol$or");
        expected.add("SIT");
        expected.add("am!~#et");
        result = OraOopUtilities.splitOracleStringList((String)"lorem,\"ip,sum\",\"dol$or\",sit,\"am!~#et\"");
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testAppendJavaSecurityEgd() {
        String confProperty = "mapred.child.java.opts";
        String confValue = "-Djava.security.egd=file:///dev/urandom";
        Configuration conf = new Configuration();
        String expected = confValue;
        String actual = null;
        conf.set(confProperty, "");
        OraOopUtilities.appendJavaSecurityEgd((Configuration)conf);
        actual = conf.get(confProperty);
        Assert.assertEquals((String)"Append to empty string", (String)expected, (String)actual);
        expected = "-Djava.security.egd=file:/dev/random";
        conf.set(confProperty, expected);
        OraOopUtilities.appendJavaSecurityEgd((Configuration)conf);
        actual = conf.get(confProperty);
        Assert.assertEquals((String)"Append to empty string", (String)expected, (String)actual);
        expected = confValue + " -Xmx201m";
        conf.set(confProperty, "-Xmx201m");
        OraOopUtilities.appendJavaSecurityEgd((Configuration)conf);
        actual = conf.get(confProperty);
        Assert.assertEquals((String)"Append to empty string", (String)expected, (String)actual);
    }
}

