/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.netezza;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.manager.DirectNetezzaManager;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.manager.netezza.NetezzaTestUtils;
import org.junit.Before;

public class NetezzaExportManualTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)NetezzaExportManualTest.class.getName());
    static final String TABLE_PREFIX = "EMPNZ_EXP_";
    protected NetezzaManager manager;
    protected Connection conn;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    protected boolean isDirectMode() {
        return false;
    }

    @Override
    protected Connection getConnection() {
        return this.conn;
    }

    @Override
    protected String getConnectString() {
        return NetezzaTestUtils.getNZConnectString();
    }

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE " + tableName;
    }

    @Override
    public void createTable(TestExport.ColumnGenerator ... extraColumns) throws SQLException {
        NetezzaTestUtils.createTableNZ(this.conn, this.getTableName(), extraColumns);
    }

    @Override
    public void createStagingTable(TestExport.ColumnGenerator ... extraColumns) throws SQLException {
        NetezzaTestUtils.createTableNZ(this.conn, this.getStagingTableName(), extraColumns);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        this.manager = this.isDirectMode() ? new DirectNetezzaManager(options) : new NetezzaManager(options);
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            NetezzaExportManualTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] argV = super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, new String[0]);
        String[] subArgV = this.newStrArray(argV, "--username", NetezzaTestUtils.getNZUser(), "--password", NetezzaTestUtils.getNZPassword());
        String[] newArgV = new String[subArgV.length + additionalArgv.length];
        int i = 0;
        for (String s : subArgV) {
            newArgV[i++] = s;
        }
        for (String s : additionalArgv) {
            newArgV[i++] = s;
        }
        return newArgV;
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 4];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = NetezzaTestUtils.getNZUser();
        moreArgs[i++] = "--password";
        moreArgs[i++] = NetezzaTestUtils.getNZPassword();
        return super.getCodeGenArgv(moreArgs);
    }

    protected void createExportFile(TestExport.ColumnGenerator ... extraCols) throws IOException {
        String ext = ".txt";
        Path tablePath = this.getTablePath();
        Path filePath = new Path(tablePath, "part0" + ext);
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(tablePath);
        FSDataOutputStream os = fs.create(filePath);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
        for (int i = 0; i < 3; ++i) {
            String line = this.getRecordLine(i, extraCols);
            w.write(line);
            LOG.debug((Object)("Create Export file - Writing line : " + line));
        }
        w.close();
        os.close();
    }

    protected class NullColumnGenerator
    implements TestExport.ColumnGenerator {
        protected NullColumnGenerator() {
        }

        @Override
        public String getExportText(int rowNum) {
            return "\\N";
        }

        @Override
        public String getVerifyText(int rowNum) {
            return null;
        }

        @Override
        public String getType() {
            return "INTEGER";
        }
    }
}

