/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.credentials;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.tool.ImportTool;
import org.apache.sqoop.util.password.CryptoFileLoader;

public class TestPassingSecurePassword
extends BaseSqoopTestCase {
    @Override
    public void setUp() {
        super.setUp();
        Path warehousePath = new Path(this.getWarehouseDir());
        try {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            fs.create(warehousePath, true);
        }
        catch (IOException e) {
            System.out.println("Could not create warehouse dir!");
        }
    }

    public void testPasswordFilePathInOptionIsEnabled() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] commonArgs = this.getCommonArgs(false, extraArgs);
            ArrayList argsList = new ArrayList();
            Collections.addAll(argsList, commonArgs);
            TestPassingSecurePassword.assertTrue((String)"passwordFilePath option missing.", (boolean)argsList.contains("--password-file"));
        }
        catch (Exception e) {
            TestPassingSecurePassword.fail((String)"passwordPath option is missing.");
        }
    }

    public void testPasswordFileDoesNotExist() throws Exception {
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--password-file");
            extraArgs.add(TEMP_BASE_DIR + "unknown");
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            importTool.parseArguments(argv, conf, opts, true);
            TestPassingSecurePassword.fail((String)"The password file does not exist! ");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("The password file does not exist!"));
        }
    }

    public void testPasswordFileIsADirectory() throws Exception {
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--password-file");
            extraArgs.add(TEMP_BASE_DIR);
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            importTool.parseArguments(argv, conf, opts, true);
            TestPassingSecurePassword.fail((String)"The password file cannot be a directory! ");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("The password file cannot be a directory!"));
        }
    }

    public void testBothPasswordOptions() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password");
            extraArgs.add("password");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions in = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
            TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
            importTool.validateOptions(out);
            TestPassingSecurePassword.fail((String)"Either password or passwordPath must be specified but not both.");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("Either password or path to a password file must be specified but not both"));
        }
    }

    public void testPasswordFilePath() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        this.writeToFile(passwordFilePath, "password");
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] commonArgs = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions in = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            SqoopOptions out = importTool.parseArguments(commonArgs, conf, in, true);
            TestPassingSecurePassword.assertNotNull((Object)out.getPasswordFilePath());
            TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
            TestPassingSecurePassword.assertEquals((String)"password", (String)out.getPassword());
        }
        catch (Exception e) {
            TestPassingSecurePassword.fail((String)"passwordPath option is missing.");
        }
    }

    public void testPasswordInDBConfiguration() throws Exception {
        JobConf jobConf = new JobConf(this.getConf());
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), (String)"username", (String)"password", null, null);
        TestPassingSecurePassword.assertNotNull((Object)jobConf.getCredentials().getSecretKey(new Text("mapreduce.jdbc.password")));
        TestPassingSecurePassword.assertEquals((String)"password", (String)new String(jobConf.getCredentials().getSecretKey(new Text("mapreduce.jdbc.password"))));
        jobConf = new JobConf();
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), null, null, null, null);
        DBConfiguration dbConfiguration = new DBConfiguration((Configuration)jobConf);
        Connection connection = dbConfiguration.getConnection();
        TestPassingSecurePassword.assertNotNull((Object)connection);
    }

    public void testPasswordNotInJobConf() throws Exception {
        JobConf jobConf = new JobConf(this.getConf());
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), (String)"username", (String)"password", null, null);
        TestPassingSecurePassword.assertNull((Object)jobConf.get("mapreduce.jdbc.password", null));
    }

    public void testPasswordInMetastoreWithRecordEnabledAndSecureOption() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password-file");
        extraArgs.add(passwordFilePath);
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "true");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPasswordFilePath());
        TestPassingSecurePassword.assertEquals((String)passwordFilePath, (String)optionsFromMetastore.getPasswordFilePath());
    }

    public void testPasswordInMetastoreWithRecordDisabledAndSecureOption() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password-file");
        extraArgs.add(passwordFilePath);
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "false");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPasswordFilePath());
        TestPassingSecurePassword.assertEquals((String)passwordFilePath, (String)optionsFromMetastore.getPasswordFilePath());
    }

    public void testPasswordInMetastoreWithRecordEnabledAndNonSecureOption() throws Exception {
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password");
        extraArgs.add("password");
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "true");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNull((Object)optionsFromMetastore.getPasswordFilePath());
    }

    private String[] getCommonArgs(boolean includeHadoopFlags, ArrayList<String> extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-textfile");
        args.add("--num-mappers");
        args.add("2");
        args.addAll(extraArgs);
        return args.toArray(new String[0]);
    }

    public void testCryptoFileLoader() throws Exception {
        Object[][] ciphers = new Object[][]{{"AES/ECB/NoPadding", 128}, {"AES/ECB/PKCS5Padding", 128}, {"DES/ECB/NoPadding", 64}, {"DES/ECB/PKCS5Padding", 64}, {"DESede/ECB/NoPadding", 192}, {"DESede/ECB/PKCS5Padding", 192}};
        String[] passphrases = new String[]{"Simple  password", "!@#$%^&*()_+<>?:"};
        for (Object[] cipher : ciphers) {
            for (String pass : passphrases) {
                this.executeCipherTest(pass, pass, (String)cipher[0], (Integer)cipher[1]);
            }
        }
    }

    public void executeCipherTest(String password, String passphrase, String cipher, int keySize) throws Exception {
        LOG.info((Object)("Using cipher: " + cipher + " with keySize " + keySize + " and passphrase " + passphrase));
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        this.writeToFile(passwordFilePath, this.encryptPassword(password, passphrase, cipher, 10000, keySize));
        LOG.info((Object)("Generated encrypted password file in: " + passwordFilePath));
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password-file");
        extraArgs.add(passwordFilePath);
        String[] commonArgs = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        conf.set("org.apache.sqoop.credentials.loader.class", CryptoFileLoader.class.getCanonicalName());
        conf.set("org.apache.sqoop.credentials.loader.crypto.alg", cipher);
        conf.set("org.apache.sqoop.credentials.loader.crypto.passphrase", passphrase);
        conf.setInt("org.apache.sqoop.credentials.loader.crypto.salt.key.len", keySize);
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(commonArgs, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPasswordFilePath());
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        TestPassingSecurePassword.assertEquals((String)passphrase, (String)out.getPassword());
    }

    private byte[] encryptPassword(String password, String passPhrase, String alg, int iterations, int keySize) throws Exception {
        String algOnly = alg.split("/")[0];
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey secKey = factory.generateSecret(new PBEKeySpec(passPhrase.toCharArray(), "SALT".getBytes(), iterations, keySize));
        SecretKeySpec key = new SecretKeySpec(secKey.getEncoded(), algOnly);
        Cipher crypto = Cipher.getInstance(alg);
        crypto.init(1, key);
        return crypto.doFinal(password.getBytes());
    }

    private void createTempFile(String filePath) throws IOException {
        File pwdFile = new File(filePath);
        pwdFile.createNewFile();
    }

    private void writeToFile(String filePath, String contents) throws IOException {
        this.writeToFile(filePath, contents.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String filePath, byte[] contents) throws IOException {
        File pwdFile = new File(filePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pwdFile);
            fos.write(contents);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

