/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import java.io.IOException;
import org.apache.sqoop.accumulo.AccumuloTestCase;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.junit.Test;

public class TestAccumuloQueryImport
extends AccumuloTestCase {
    @Test
    public void testImportFromQuery() throws IOException {
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv("queryT", "queryF", true, "SELECT " + this.getColName(0) + ", " + this.getColName(1) + " FROM " + this.getTableName() + " WHERE $CONDITIONS");
        this.runImport(argv);
        this.verifyAccumuloCell("queryT", "0", "queryF", this.getColName(1), "42");
        this.verifyAccumuloCell("queryT", "0", "queryF", this.getColName(2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitFailure() throws IOException {
        String[] argv = this.getArgv("NoAccumuloT", "NoAccumuloF", true, null);
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        try {
            AccumuloUtil.setAlwaysNoAccumuloJarMode((boolean)true);
            this.runImport(argv);
            TestAccumuloQueryImport.fail((String)"should have gotten exception");
        }
        catch (IOException e) {
            LOG.info((Object)"Got exception -- ok; we expected that to fail.");
        }
        finally {
            AccumuloUtil.setAlwaysNoAccumuloJarMode((boolean)false);
        }
    }
}

