/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.OracleUtils;
import com.cloudera.sqoop.testutil.ManagerCompatTestCase;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Formatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class OracleCompatTest
extends ManagerCompatTestCase {
    public static final Log LOG = LogFactory.getLog((String)OracleCompatTest.class.getName());

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected String getDbFriendlyName() {
        return "Oracle";
    }

    @Override
    protected String getConnectString() {
        return OracleUtils.CONNECT_STRING;
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        OracleUtils.setOracleAuth(opts);
        return opts;
    }

    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        OracleUtils.dropTable(table, this.getManager());
    }

    @Override
    public void tearDown() {
        super.tearDown();
        if (!this.skipped) {
            LOG.info((Object)"Sleeping to wait for Oracle connection cache clear...");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getDoubleType() {
        return "DOUBLE PRECISION";
    }

    @Override
    protected String getVarBinaryType() {
        return "RAW(12)";
    }

    @Override
    protected boolean supportsBoolean() {
        return false;
    }

    @Override
    protected boolean supportsBigInt() {
        return false;
    }

    @Override
    protected boolean supportsTinyInt() {
        return false;
    }

    @Override
    protected boolean supportsLongVarChar() {
        return false;
    }

    @Override
    protected boolean supportsTime() {
        return false;
    }

    @Override
    protected String getDateInsertStr(String dateStr) {
        return "TO_DATE(" + dateStr + ", 'YYYY-MM-DD')";
    }

    @Override
    protected String getTimestampInsertStr(String tsStr) {
        return "TO_TIMESTAMP(" + tsStr + ", 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Override
    protected String getDateSeqOutput(String asInserted) {
        return asInserted + " 00:00:00.0";
    }

    @Override
    protected String getFixedCharSeqOut(int fieldWidth, String asInserted) {
        return this.padString(fieldWidth, asInserted);
    }

    @Override
    protected String getRealSeqOutput(String realAsInserted) {
        return realAsInserted;
    }

    @Override
    protected String getFloatSeqOutput(String floatAsInserted) {
        return floatAsInserted;
    }

    @Override
    protected String getDoubleSeqOutput(String doubleAsInserted) {
        return doubleAsInserted;
    }

    @Override
    protected String getVarBinarySeqOutput(String asInserted) {
        return this.toLowerHexString(asInserted);
    }

    @Override
    protected String getBlobInsertStr(String blobData) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        Formatter fmt = new Formatter(sb);
        try {
            for (byte b : blobData.getBytes("UTF-8")) {
                fmt.format("%02X", b);
            }
        }
        catch (UnsupportedEncodingException uee) {
            OracleCompatTest.fail((String)"Could not get utf-8 bytes for blob string");
            return null;
        }
        sb.append("'");
        return sb.toString();
    }

    protected String getBinaryFloatInsertStr(float f) {
        return "TO_BINARY_FLOAT('" + f + "')";
    }

    protected String getBinaryDoubleInsertStr(double d) {
        return "TO_BINARY_DOUBLE('" + d + "')";
    }

    @Override
    public void testEmptyStringCol() {
        this.skipped = true;
        LOG.info((Object)"Oracle treats empty strings as null (non-ANSI compliant). Skipping.");
    }

    @Override
    public void testTimestamp1() {
        this.verifyType(this.getTimestampType(), this.getTimestampInsertStr("'2009-04-24 18:24:00'"), "2009-04-24 18:24:00.0");
    }

    @Override
    public void testTimestamp2() {
        this.verifyType(this.getTimestampType(), this.getTimestampInsertStr("'2009-04-24 18:24:00.0002'"), "2009-04-24 18:24:00.0002");
    }

    @Override
    public void testDate1() {
        this.verifyType("DATE", this.getDateInsertStr("'2009-01-12'"), this.getDateSeqOutput("2009-01-12"));
    }

    @Override
    public void testDate2() {
        this.verifyType("DATE", this.getDateInsertStr("'2009-04-24'"), this.getDateSeqOutput("2009-04-24"));
    }

    public void testRawVal() {
        this.verifyType("RAW(8)", "'12ABCD'", this.getVarBinarySeqOutput("12ABCD"), true);
    }

    public void testBinaryFloat() {
        this.verifyType("BINARY_FLOAT", this.getBinaryFloatInsertStr(25.0f), "25.0");
        this.verifyType("BINARY_FLOAT", this.getBinaryFloatInsertStr(6.34f), "6.34");
        float max = 3.40282E38f;
        this.verifyType("BINARY_FLOAT", this.getBinaryFloatInsertStr(max), "3.40282E38");
        float min = 1.17549E-38f;
        this.verifyType("BINARY_FLOAT", this.getBinaryFloatInsertStr(min), "1.17549E-38");
    }

    public void testBinaryDouble() {
        this.verifyType("BINARY_DOUBLE", this.getBinaryDoubleInsertStr(0.5), "0.5");
        this.verifyType("BINARY_DOUBLE", this.getBinaryDoubleInsertStr(-1.0), "-1.0");
        double max = 1.79769313486231E308;
        this.verifyType("BINARY_DOUBLE", this.getBinaryDoubleInsertStr(max), "1.79769313486231E308");
        double min = 2.2250748585072E-308;
        this.verifyType("BINARY_DOUBLE", this.getBinaryDoubleInsertStr(min), "2.2250748585072E-308");
    }
}

