/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class TestBlobRef
extends TestCase {
    public void testEmptyStr() {
        BlobRef r = BlobRef.parse((String)"");
        TestBlobRef.assertFalse((boolean)r.isExternal());
    }

    public void testInline() throws IOException {
        BlobRef r = BlobRef.parse((String)"foo");
        TestBlobRef.assertFalse((boolean)r.isExternal());
    }

    public void testEmptyFile() {
        BlobRef r = BlobRef.parse((String)"externalLob()");
        TestBlobRef.assertFalse((boolean)r.isExternal());
        r = BlobRef.parse((String)"externalLob(lf,,0,0)");
        TestBlobRef.assertTrue((boolean)r.isExternal());
        TestBlobRef.assertEquals((String)"externalLob(lf,,0,0)", (String)r.toString());
    }

    public void testInlineNearMatch() {
        BlobRef r = BlobRef.parse((String)"externalLob(foo)bar");
        TestBlobRef.assertFalse((boolean)r.isExternal());
        r = BlobRef.parse((String)"externalLob(foo)");
        TestBlobRef.assertFalse((boolean)r.isExternal());
        r = BlobRef.parse((String)"externalLob(lf,foo)");
        TestBlobRef.assertFalse((boolean)r.isExternal());
        r = BlobRef.parse((String)"externalLob(lf,foo,1,2)x");
        TestBlobRef.assertFalse((boolean)r.isExternal());
    }

    public void testExternal() throws IOException {
        byte[] DATA = new byte[]{1, 2, 3, 4, 5};
        String FILENAME = "blobdata";
        this.doExternalTest(DATA, "blobdata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExternalSubdir() throws IOException {
        byte[] DATA = new byte[]{1, 2, 3, 4, 5};
        String FILENAME = "_lob/blobdata";
        try {
            this.doExternalTest(DATA, "_lob/blobdata");
        }
        finally {
            Configuration conf = new Configuration();
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            String tmpDir = System.getProperty("test.build.data", "/tmp/");
            Path lobDir = new Path(new Path(tmpDir), "_lob");
            fs.delete(lobDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExternalTest(byte[] data, String filename) throws IOException {
        String tmpDir;
        Path tmpPath;
        Path blobFile;
        Path blobParent;
        FileSystem fs;
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        if (!(fs = FileSystem.get((Configuration)conf)).exists(blobParent = (blobFile = new Path(tmpPath = new Path(tmpDir = System.getProperty("test.build.data", "/tmp/")), filename)).getParent())) {
            fs.mkdirs(blobParent);
        }
        LobFile.Writer lw = LobFile.create((Path)blobFile, (Configuration)conf, (boolean)false);
        try {
            long off = lw.tell();
            long len = data.length;
            OutputStream os = lw.writeBlobRecord(len);
            os.write(data, 0, data.length);
            os.close();
            lw.close();
            String refString = "externalLob(lf," + filename + "," + off + "," + len + ")";
            BlobRef blob = BlobRef.parse((String)refString);
            TestBlobRef.assertTrue((boolean)blob.isExternal());
            TestBlobRef.assertEquals((String)refString, (String)blob.toString());
            InputStream is = (InputStream)blob.getDataStream(conf, tmpPath);
            TestBlobRef.assertNotNull((Object)is);
            byte[] buf = new byte[4096];
            int bytes = is.read(buf, 0, 4096);
            is.close();
            TestBlobRef.assertEquals((int)data.length, (int)bytes);
            for (int i = 0; i < bytes; ++i) {
                TestBlobRef.assertEquals((byte)data[i], (byte)buf[i]);
            }
        }
        finally {
            fs.delete(blobFile, false);
        }
    }
}

