/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.SplittableBufferedWriter;
import com.cloudera.sqoop.io.SplittingOutputStream;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;

public class TestSplittableBufferedWriter
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestSplittableBufferedWriter.class.getName());

    private String getWriteDir() {
        return new File(ImportJobTestCase.TEMP_BASE_DIR, "bufferedWriterTest").toString();
    }

    private Path getWritePath() {
        return new Path(ImportJobTestCase.TEMP_BASE_DIR, "bufferedWriterTest");
    }

    private void ensureEmptyWriteDir() throws IOException {
        FileStatus[] stats;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConf());
        Path writeDir = this.getWritePath();
        fs.mkdirs(writeDir);
        for (FileStatus stat : stats = fs.listStatus(writeDir)) {
            if (stat.isDir()) {
                TestSplittableBufferedWriter.fail((String)("setUp(): Write directory " + writeDir + " contains subdirectories"));
            }
            LOG.debug((Object)("setUp(): Removing " + stat.getPath()));
            if (fs.delete(stat.getPath(), false)) continue;
            TestSplittableBufferedWriter.fail((String)("setUp(): Could not delete residual file " + stat.getPath()));
        }
        if (!fs.exists(writeDir)) {
            TestSplittableBufferedWriter.fail((String)("setUp: Could not create " + writeDir));
        }
    }

    public void setUp() throws IOException {
        this.ensureEmptyWriteDir();
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFileContents(InputStream is, String[] lines) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        try {
            for (String expectedLine : lines) {
                String actualLine = r.readLine();
                TestSplittableBufferedWriter.assertNotNull((Object)actualLine);
                TestSplittableBufferedWriter.assertEquals((String)"Input line mismatch", (String)expectedLine, (String)actualLine);
            }
            TestSplittableBufferedWriter.assertNull((String)"Stream had additional contents after expected line", (Object)r.readLine());
        }
        finally {
            r.close();
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    private void verifyFileExists(Path p) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConf());
        TestSplittableBufferedWriter.assertTrue((String)("File not found: " + p), (boolean)fs.exists(p));
    }

    private void verifyFileDoesNotExist(Path p) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConf());
        TestSplittableBufferedWriter.assertFalse((String)("File found: " + p + " and we did not expect it"), (boolean)fs.exists(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonSplittingTextFile() throws IOException {
        SplittingOutputStream os = new SplittingOutputStream(this.getConf(), this.getWritePath(), "nonsplit-", 0L, null);
        try {
            SplittableBufferedWriter w = new SplittableBufferedWriter(os, true);
            try {
                w.allowSplit();
                w.write("This is a string!");
                w.newLine();
                w.write("This is another string!");
                w.allowSplit();
            }
            finally {
                w.close();
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ioe) {}
        }
        Path writePath = new Path(this.getWritePath(), "nonsplit-00000");
        Path badPath = new Path(this.getWritePath(), "nonsplit-00001");
        this.verifyFileExists(writePath);
        this.verifyFileDoesNotExist(badPath);
        String[] expectedLines = new String[]{"This is a string!", "This is another string!"};
        FileInputStream fis = new FileInputStream(new File(this.getWriteDir(), "nonsplit-00000"));
        try {
            this.verifyFileContents(fis, expectedLines);
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonSplittingGzipFile() throws IOException {
        SplittingOutputStream os = new SplittingOutputStream(this.getConf(), this.getWritePath(), "nonsplit-", 0L, (CompressionCodec)new GzipCodec());
        SplittableBufferedWriter w = new SplittableBufferedWriter(os, true);
        try {
            w.allowSplit();
            w.write("This is a string!");
            w.newLine();
            w.write("This is another string!");
            w.allowSplit();
        }
        finally {
            w.close();
        }
        Path writePath = new Path(this.getWritePath(), "nonsplit-00000.gz");
        Path badPath = new Path(this.getWritePath(), "nonsplit-00001.gz");
        this.verifyFileExists(writePath);
        this.verifyFileDoesNotExist(badPath);
        String[] expectedLines = new String[]{"This is a string!", "This is another string!"};
        this.verifyFileContents(new GZIPInputStream(new FileInputStream(new File(this.getWriteDir(), "nonsplit-00000.gz"))), expectedLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplittingTextFile() throws IOException {
        SplittingOutputStream os = new SplittingOutputStream(this.getConf(), this.getWritePath(), "split-", 10L, null);
        try {
            SplittableBufferedWriter w = new SplittableBufferedWriter(os, true);
            try {
                w.allowSplit();
                w.write("This is a string!");
                w.newLine();
                w.write("This is another string!");
            }
            finally {
                w.close();
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ioe) {}
        }
        Path writePath = new Path(this.getWritePath(), "split-00000");
        Path writePath2 = new Path(this.getWritePath(), "split-00001");
        Path badPath = new Path(this.getWritePath(), "split-00002");
        this.verifyFileExists(writePath);
        this.verifyFileExists(writePath2);
        this.verifyFileDoesNotExist(badPath);
        String[] expectedLines0 = new String[]{"This is a string!"};
        FileInputStream fis = new FileInputStream(new File(this.getWriteDir(), "split-00000"));
        try {
            this.verifyFileContents(fis, expectedLines0);
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {}
        }
        String[] expectedLines1 = new String[]{"This is another string!"};
        fis = new FileInputStream(new File(this.getWriteDir(), "split-00001"));
        try {
            this.verifyFileContents(fis, expectedLines1);
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplittingGzipFile() throws IOException {
        SplittingOutputStream os = new SplittingOutputStream(this.getConf(), this.getWritePath(), "splitz-", 3L, (CompressionCodec)new GzipCodec());
        SplittableBufferedWriter w = new SplittableBufferedWriter(os, true);
        try {
            w.write("This is a string!");
            w.newLine();
            w.write("This is another string!");
        }
        finally {
            w.close();
        }
        Path writePath = new Path(this.getWritePath(), "splitz-00000.gz");
        Path writePath2 = new Path(this.getWritePath(), "splitz-00001.gz");
        Path badPath = new Path(this.getWritePath(), "splitz-00002.gz");
        this.verifyFileExists(writePath);
        this.verifyFileExists(writePath2);
        this.verifyFileDoesNotExist(badPath);
        String[] expectedLines0 = new String[]{"This is a string!"};
        this.verifyFileContents(new GZIPInputStream(new FileInputStream(new File(this.getWriteDir(), "splitz-00000.gz"))), expectedLines0);
        String[] expectedLines1 = new String[]{"This is another string!"};
        this.verifyFileContents(new GZIPInputStream(new FileInputStream(new File(this.getWriteDir(), "splitz-00001.gz"))), expectedLines1);
    }
}

