/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hive;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hive.HiveImport;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.CodeGenTool;
import com.cloudera.sqoop.tool.CreateHiveTableTool;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Test;

public class TestHiveImport
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestHiveImport.class.getName());

    @Override
    public void setUp() {
        super.setUp();
        HiveImport.setTestMode((boolean)true);
    }

    @Override
    public void tearDown() {
        super.tearDown();
        HiveImport.setTestMode((boolean)false);
    }

    protected void setNumCols(int numCols) {
        String[] cols = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            cols[i] = "DATA_COL" + i;
        }
        this.setColNames(cols);
    }

    protected String[] getTypesNewLineTest() {
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        return types;
    }

    protected String[] getArgv(boolean includeHadoopFlags, String[] moreArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        if (null != moreArgs) {
            for (String arg : moreArgs) {
                args.add(arg);
            }
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--hive-import");
        String[] colNames = this.getColNames();
        if (null != colNames) {
            args.add("--split-by");
            args.add(colNames[0]);
        } else {
            TestHiveImport.fail((String)"Could not determine column names.");
        }
        args.add("--num-mappers");
        args.add("1");
        for (String a : args) {
            LOG.debug((Object)("ARG : " + a));
        }
        return args.toArray(new String[0]);
    }

    protected String[] getCreateTableArgv(boolean includeHadoopFlags, String[] moreArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (null != moreArgs) {
            for (String arg : moreArgs) {
                args.add(arg);
            }
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(this.getConnectString());
        return args.toArray(new String[0]);
    }

    protected String[] getCodeGenArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--hive-import");
        return args.toArray(new String[0]);
    }

    protected String[] getCreateHiveTableArgs(String[] extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(this.getConnectString());
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                args.add(arg);
            }
        }
        return args.toArray(new String[0]);
    }

    private SqoopOptions getSqoopOptions(String[] args, SqoopTool tool) {
        SqoopOptions opts = null;
        try {
            opts = tool.parseArguments(args, null, null, true);
        }
        catch (Exception e) {
            TestHiveImport.fail((String)("Invalid options: " + e.toString()));
        }
        return opts;
    }

    private void runImportTest(String tableName, String[] types, String[] values, String verificationScript, String[] args, SqoopTool tool) throws IOException {
        this.createTableWithColTypes(types, values);
        SqoopOptions options = this.getSqoopOptions(args, tool);
        String hiveHome = options.getHiveHome();
        TestHiveImport.assertNotNull((String)"hive.home was not set", (Object)hiveHome);
        String testDataPath = new Path(new Path(hiveHome), "scripts/" + verificationScript).toString();
        System.setProperty("expected.script", new File(testDataPath).getAbsolutePath());
        this.runImport(tool, args);
    }

    @Test
    public void testGenerateOnly() throws IOException {
        String TABLE_NAME = "GenerateOnly";
        this.setCurTableName("GenerateOnly");
        this.setNumCols(1);
        SqoopOptions options = this.getSqoopOptions(this.getArgv(false, null), (SqoopTool)new ImportTool());
        Path ddlFile = new Path(new Path(options.getCodeOutputDir()), "GenerateOnly.q");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        if (fs.exists(ddlFile) && !fs.delete(ddlFile, false)) {
            LOG.warn((Object)("Could not delete previous ddl file: " + ddlFile));
        }
        String[] types = new String[]{"INTEGER"};
        String[] vals = new String[]{"42"};
        this.runImportTest("GenerateOnly", types, vals, null, this.getCodeGenArgs(), (SqoopTool)new CodeGenTool());
        TestHiveImport.assertTrue((String)"Couldn't find expected ddl file", (boolean)fs.exists(ddlFile));
        Path hiveImportPath = new Path(new Path(options.getWarehouseDir()), "GenerateOnly");
        TestHiveImport.assertFalse((String)"Import actually happened!", (boolean)fs.exists(hiveImportPath));
    }

    @Test
    public void testNormalHiveImport() throws IOException {
        String TABLE_NAME = "NORMAL_HIVE_IMPORT";
        this.setCurTableName("NORMAL_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'test'", "42", "'somestring'"};
        this.runImportTest("NORMAL_HIVE_IMPORT", types, vals, "normalImport.q", this.getArgv(false, null), (SqoopTool)new ImportTool());
    }

    @Test
    public void testCreateOnlyHiveImport() throws IOException {
        String TABLE_NAME = "CREATE_ONLY_HIVE_IMPORT";
        this.setCurTableName("CREATE_ONLY_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'test'", "42", "'somestring'"};
        this.runImportTest("CREATE_ONLY_HIVE_IMPORT", types, vals, "createOnlyImport.q", this.getCreateHiveTableArgs(null), (SqoopTool)new CreateHiveTableTool());
    }

    @Test
    public void testCreateOverwriteHiveImport() throws IOException {
        String TABLE_NAME = "CREATE_OVERWRITE_HIVE_IMPORT";
        this.setCurTableName("CREATE_OVERWRITE_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'test'", "42", "'somestring'"};
        String[] extraArgs = new String[]{"--hive-overwrite", "--create-hive-table"};
        this.runImportTest("CREATE_OVERWRITE_HIVE_IMPORT", types, vals, "createOverwriteImport.q", this.getCreateHiveTableArgs(extraArgs), (SqoopTool)new CreateHiveTableTool());
    }

    @Test
    public void testDate() throws IOException {
        String TABLE_NAME = "DATE_HIVE_IMPORT";
        this.setCurTableName("DATE_HIVE_IMPORT");
        this.setNumCols(2);
        String[] types = new String[]{"VARCHAR(32)", "DATE"};
        String[] vals = new String[]{"'test'", "'2009-05-12'"};
        this.runImportTest("DATE_HIVE_IMPORT", types, vals, "dateImport.q", this.getArgv(false, null), (SqoopTool)new ImportTool());
    }

    @Test
    public void testNumeric() throws IOException {
        String TABLE_NAME = "NUMERIC_HIVE_IMPORT";
        this.setCurTableName("NUMERIC_HIVE_IMPORT");
        this.setNumCols(2);
        String[] types = new String[]{"NUMERIC", "CHAR(64)"};
        String[] vals = new String[]{"3.14159", "'foo'"};
        this.runImportTest("NUMERIC_HIVE_IMPORT", types, vals, "numericImport.q", this.getArgv(false, null), (SqoopTool)new ImportTool());
    }

    @Test
    public void testHiveExitFails() {
        String TABLE_NAME = "FAILING_HIVE_IMPORT";
        this.setCurTableName("FAILING_HIVE_IMPORT");
        this.setNumCols(2);
        String[] types = new String[]{"NUMERIC", "CHAR(64)"};
        String[] vals = new String[]{"3.14159", "'foo'"};
        try {
            this.runImportTest("FAILING_HIVE_IMPORT", types, vals, "failingImport.q", this.getArgv(false, null), (SqoopTool)new ImportTool());
            TestHiveImport.fail((String)"FAILING_HIVE_IMPORT test should have thrown IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test
    public void testCustomDelimiters() throws IOException {
        String TABLE_NAME = "CUSTOM_DELIM_IMPORT";
        this.setCurTableName("CUSTOM_DELIM_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'test'", "42", "'somestring'"};
        String[] extraArgs = new String[]{"--fields-terminated-by", ",", "--lines-terminated-by", "|"};
        this.runImportTest("CUSTOM_DELIM_IMPORT", types, vals, "customDelimImport.q", this.getArgv(false, extraArgs), (SqoopTool)new ImportTool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFieldWithHiveDelims() throws IOException, InterruptedException {
        String TABLE_NAME = "FIELD_WITH_NL_HIVE_IMPORT";
        LOG.info((Object)"Doing import of single row into FIELD_WITH_NL_HIVE_IMPORT table");
        this.setCurTableName("FIELD_WITH_NL_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = this.getTypesNewLineTest();
        String[] vals = new String[]{"'test with \n new lines \n'", "42", "'oh no \u0001 field delims \u0001'"};
        String[] moreArgs = new String[]{"--hive-drop-import-delims"};
        this.runImportTest("FIELD_WITH_NL_HIVE_IMPORT", types, vals, "fieldWithNewlineImport.q", this.getArgv(false, moreArgs), (SqoopTool)new ImportTool());
        LOG.info((Object)"Validating data in single row is present in: FIELD_WITH_NL_HIVE_IMPORT table");
        String whDir = this.getWarehouseDir();
        File p = new File(new File(whDir, "FIELD_WITH_NL_HIVE_IMPORT"), "part-m-00000");
        File f = new File(p.toString());
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        try {
            TestHiveImport.assertEquals((String)br.readLine(), (String)"test with  new lines \u000142\u0001oh no  field delims ");
            TestHiveImport.assertEquals((String)br.readLine(), null);
        }
        catch (IOException ioe) {
            TestHiveImport.fail((String)"Unable to read files generated from hive");
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFieldWithHiveDelimsReplacement() throws IOException, InterruptedException {
        String TABLE_NAME = "FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT";
        LOG.info((Object)"Doing import of single row into FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT table");
        this.setCurTableName("FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = this.getTypesNewLineTest();
        String[] vals = new String[]{"'test with\nnew lines\n'", "42", "'oh no \u0001 field delims \u0001'"};
        String[] moreArgs = new String[]{"--hive-delims-replacement", " "};
        this.runImportTest("FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT", types, vals, "fieldWithNewlineReplacementImport.q", this.getArgv(false, moreArgs), (SqoopTool)new ImportTool());
        LOG.info((Object)"Validating data in single row is present in: FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT table");
        String whDir = this.getWarehouseDir();
        File p = new File(new File(whDir, "FIELD_WITH_NL_REPLACEMENT_HIVE_IMPORT"), "part-m-00000");
        File f = new File(p.toString());
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        try {
            TestHiveImport.assertEquals((String)br.readLine(), (String)"test with new lines \u000142\u0001oh no   field delims  ");
            TestHiveImport.assertEquals((String)br.readLine(), null);
        }
        catch (IOException ioe) {
            TestHiveImport.fail((String)"Unable to read files generated from hive");
        }
        finally {
            br.close();
        }
    }

    @Test
    public void testHiveDropAndReplaceOptionValidation() throws ParseException {
        LOG.info((Object)"Testing conflicting Hive delimiter drop/replace options");
        this.setNumCols(3);
        String[] moreArgs = new String[]{"--hive-delims-replacement", " ", "--hive-drop-import-delims"};
        ImportTool tool = new ImportTool();
        try {
            tool.validateOptions(tool.parseArguments(this.getArgv(false, moreArgs), null, null, true));
            TestHiveImport.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    @Test
    public void testImportHiveWithPartitions() throws IOException, InterruptedException {
        String TABLE_NAME = "PARTITION_HIVE_IMPORT";
        LOG.info((Object)"Doing import of single row into PARTITION_HIVE_IMPORT table");
        this.setCurTableName("PARTITION_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'whoop'", "42", "'I am a row in a partition'"};
        String[] moreArgs = new String[]{"--hive-partition-key", "ds", "--hive-partition-value", "20110413"};
        this.runImportTest("PARTITION_HIVE_IMPORT", types, vals, "partitionImport.q", this.getArgv(false, moreArgs), (SqoopTool)new ImportTool());
    }

    @Test
    public void testImportWithBadPartitionKey() {
        String TABLE_NAME = "FAILING_PARTITION_HIVE_IMPORT";
        LOG.info((Object)"Doing import of single row into FAILING_PARTITION_HIVE_IMPORT table");
        this.setCurTableName("FAILING_PARTITION_HIVE_IMPORT");
        this.setNumCols(3);
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "CHAR(64)"};
        String[] vals = new String[]{"'key'", "42", "'I am a row in a partition'"};
        String partitionKey = this.getColNames()[0];
        String[] moreArgs1 = new String[]{"--hive-partition-key", partitionKey};
        String[] moreArgs2 = new String[]{"--hive-partition-key", partitionKey, "--columns", partitionKey};
        try {
            this.runImportTest("FAILING_PARTITION_HIVE_IMPORT", types, vals, "partitionImport.q", this.getArgv(false, moreArgs1), (SqoopTool)new ImportTool());
            TestHiveImport.fail((String)"FAILING_PARTITION_HIVE_IMPORT test should have thrown IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.runImportTest("FAILING_PARTITION_HIVE_IMPORT", types, vals, "partitionImport.q", this.getArgv(false, moreArgs2), (SqoopTool)new ImportTool());
            TestHiveImport.fail((String)"FAILING_PARTITION_HIVE_IMPORT test should have thrown IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.runImportTest("FAILING_PARTITION_HIVE_IMPORT", types, vals, "partitionImport.q", this.getCreateTableArgv(false, moreArgs1), (SqoopTool)new CreateHiveTableTool());
            TestHiveImport.fail((String)"FAILING_PARTITION_HIVE_IMPORT test should have thrown IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

