/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.hbase.HBaseTestCase;
import java.io.IOException;
import org.junit.Test;

public class HBaseImportAddRowKeyTest
extends HBaseTestCase {
    @Test
    public void testAddRowKey() throws IOException {
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        String[] otherArg = this.getArgv(true, "addRowKeyT", "addRowKeyF", true, null);
        String[] argv = new String[otherArg.length + 2];
        argv[0] = "-D";
        argv[1] = "sqoop.hbase.add.row.key=true";
        System.arraycopy(otherArg, 0, argv, 2, otherArg.length);
        this.runImport(argv);
        this.verifyHBaseCell("addRowKeyT", "0", "addRowKeyF", this.getColName(0), "0");
        this.verifyHBaseCell("addRowKeyT", "0", "addRowKeyF", this.getColName(1), "1");
    }

    @Test
    public void testAddRowKeyDefault() throws IOException {
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "addRowKeyDfT", "addRowKeyDfF", true, null);
        this.runImport(argv);
        this.verifyHBaseCell("addRowKeyDfT", "0", "addRowKeyDfF", this.getColName(0), null);
        this.verifyHBaseCell("addRowKeyDfT", "0", "addRowKeyDfF", this.getColName(1), "1");
    }

    @Test
    public void testAddCompositeKey() throws IOException {
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        String[] otherArg = this.getArgv(true, "addRowKeyT", "addRowKeyF", true, null);
        String[] argv = new String[otherArg.length + 4];
        argv[0] = "-D";
        argv[1] = "sqoop.hbase.add.row.key=true";
        System.arraycopy(otherArg, 0, argv, 2, otherArg.length);
        argv[argv.length - 2] = "--hbase-row-key";
        argv[argv.length - 1] = this.getColName(0) + "," + this.getColName(1);
        this.runImport(argv);
        this.verifyHBaseCell("addRowKeyT", "0_1", "addRowKeyF", this.getColName(0), "0");
        this.verifyHBaseCell("addRowKeyT", "0_1", "addRowKeyF", this.getColName(1), "1");
    }
}

