/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.manager.sqlserver.MSSQLTestDataFileParser;
import org.apache.sqoop.manager.sqlserver.ManagerCompatExport;

public class SQLServerDatatypeExportDelimitedFileManualTest
extends ManagerCompatExport {
    @Override
    public void createFile(MSSQLTestDataFileParser.DATATYPES dt, String[] data) throws IOException {
        Path tablePath = this.getTablePath(dt);
        Path filePath = new Path(tablePath, "part0000");
        Configuration conf = new Configuration();
        String hdfsroot = System.getProperty("ms.datatype.test.hdfsprefix");
        if (hdfsroot == null) {
            hdfsroot = "hdfs://localhost/";
        }
        conf.set("fs.default.name", hdfsroot);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(tablePath);
        System.out.println("-----------------------------------Path : " + filePath);
        FSDataOutputStream os = fs.create(filePath);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
        for (int i = 0; i < data.length; ++i) {
            w.write(data[i] + "\n");
        }
        w.close();
        os.close();
    }

    @Override
    public void createFile(MSSQLTestDataFileParser.DATATYPES dt, String data) throws IOException {
        this.createFile(dt, new String[]{data});
    }

    @Override
    public String getOutputFileName() {
        return "ManagerCompatExportDelim.txt";
    }
}

