/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.lib.SqoopRecord;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopDBInputSplit;
import org.apache.sqoop.manager.oracle.OraOopDataDrivenDBInputFormat;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunkExtent;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.junit.Assert;
import org.junit.Test;

public class TestOraOopDataDrivenDBInputFormat
extends OraOopTestCase {
    @Test
    public void testgroupTableDataChunksIntoSplits() {
        double minExpectedWorkloadRatio;
        double actualWorkloadRatio;
        ArrayList<OraOopOracleDataChunkExtent> dataChunks = new ArrayList<OraOopOracleDataChunkExtent>();
        int startBlockNumber = 1;
        for (int idx = 0; idx < 241; ++idx) {
            OraOopOracleDataChunkExtent dataChunk = new OraOopOracleDataChunkExtent("23480", 666, 1, startBlockNumber, startBlockNumber + 8);
            startBlockNumber += 8;
            dataChunks.add(dataChunk);
        }
        Exposer e = new Exposer();
        boolean logIsBeingCached = Exposer.LOG.getCacheLogEntries();
        Exposer.LOG.setCacheLogEntries(true);
        List<InputSplit> splits = e.groupTableDataChunksIntoSplits(dataChunks, 32, OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.SEQUENTIAL);
        Exposer.LOG.setCacheLogEntries(logIsBeingCached);
        int highestNumberOfDataChunksAllocatedToASplit = 0;
        int lowestNumberOfDataChunksAllocatedToASplit = Integer.MAX_VALUE;
        for (InputSplit split : splits) {
            int dataChunksAllocatedToThisSplit = ((OraOopDBInputSplit)split).getNumberOfDataChunks();
            highestNumberOfDataChunksAllocatedToASplit = Math.max(highestNumberOfDataChunksAllocatedToASplit, dataChunksAllocatedToThisSplit);
            lowestNumberOfDataChunksAllocatedToASplit = Math.min(lowestNumberOfDataChunksAllocatedToASplit, dataChunksAllocatedToThisSplit);
        }
        if (lowestNumberOfDataChunksAllocatedToASplit == 0) {
            Assert.fail((String)"There is a split that has not had any data-chunks allocated to it.");
        }
        if ((actualWorkloadRatio = (double)lowestNumberOfDataChunksAllocatedToASplit / (double)highestNumberOfDataChunksAllocatedToASplit) < (minExpectedWorkloadRatio = 0.75)) {
            Assert.fail((String)String.format("There is too much difference in the amount of work assigned to the 'smallest' split and the 'largest' split. The split with the least work should have at least %s of the workload of the 'largest' split, but it actually only has %s of the workload of the 'largest' split.", minExpectedWorkloadRatio, actualWorkloadRatio));
        }
    }

    public class Exposer<T extends SqoopRecord>
    extends OraOopDataDrivenDBInputFormat<T> {
        public List<InputSplit> groupTableDataChunksIntoSplits(List<? extends OraOopOracleDataChunk> dataChunks, int desiredNumberOfSplits, OraOopConstants.OraOopOracleBlockToSplitAllocationMethod blockAllocationMethod) {
            return super.groupTableDataChunksIntoSplits(dataChunks, desiredNumberOfSplits, blockAllocationMethod);
        }
    }
}

