/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.tool;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.tool.ToolDesc;
import com.cloudera.sqoop.tool.ToolPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

public class TestToolPlugin
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestToolPlugin.class.getName());

    public void testPlugin() {
        Configuration pluginConf = new Configuration();
        pluginConf.set("sqoop.tool.plugins", PluginClass.class.getName());
        SqoopTool.loadPlugins((Configuration)pluginConf);
        ArrayList<String> args = new ArrayList<String>();
        args.add("fooTool");
        args.add("--username");
        args.add("bob");
        args.add("--connect");
        args.add("anywhere");
        int ret = Sqoop.runTool((String[])args.toArray(new String[0]));
        TestToolPlugin.assertEquals((String)"Expected tool run success", (int)0, (int)ret);
        String actualUser = FooTool.getLastUser();
        TestToolPlugin.assertEquals((String)"Failed to set username correctly.", (String)"bob", (String)actualUser);
    }

    public void testNoOverrideTools() {
        Configuration pluginConf = new Configuration();
        pluginConf.set("sqoop.tool.plugins", OverridePlugin.class.getName());
        try {
            SqoopTool.loadPlugins((Configuration)pluginConf);
            TestToolPlugin.fail((String)"Successfully loaded a plugin that overrides 'import' tool.");
        }
        catch (RuntimeException re) {
            LOG.info((Object)("Got runtime exception registering plugin (expected; ok): " + StringUtils.stringifyException((Throwable)re)));
        }
    }

    public static class OverridePlugin
    extends ToolPlugin {
        public List<ToolDesc> getTools() {
            return Collections.singletonList(new ToolDesc("import", FooTool.class, "replaces 'import' with foo"));
        }
    }

    public static class FooTool
    extends BaseSqoopTool {
        private static String lastUser;

        static String getLastUser() {
            return lastUser;
        }

        private static void setLastUser(String last) {
            lastUser = last;
        }

        public FooTool() {
            super("fooTool");
        }

        public int run(SqoopOptions opts) {
            FooTool.setLastUser(opts.getUsername());
            LOG.info((Object)("FooTool operating on user: " + lastUser));
            return 0;
        }

        public void configureOptions(ToolOptions toolOptions) {
            toolOptions.addUniqueOptions(this.getCommonOptions());
        }

        public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
            this.applyCommonOptions(in, out);
        }

        public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
            this.validateCommonOptions(options);
        }
    }

    public static class PluginClass
    extends ToolPlugin {
        public List<ToolDesc> getTools() {
            return Collections.singletonList(new ToolDesc("fooTool", FooTool.class, "does foo things"));
        }
    }
}

