/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import com.cloudera.sqoop.mapreduce.ImportJobBase;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.InjectableManagerFactory;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.util.ClassLoaderStack;

public class TestImportJob
extends ImportJobTestCase {
    public void testFailedImportDueToIOException() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)(" getWarehouseDir() " + this.getWarehouseDir()));
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected ImportException running this job.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedImportDueToJobFail() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep2'");
        Configuration conf = new Configuration();
        conf.setClass("sqoop.connection.factories", InjectableManagerFactory.class, ManagerFactory.class);
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0"}, conf);
        conf.setClass("sqoop.inject.mapper.class", NullDereferenceMapper.class, Mapper.class);
        conf.setClass("sqoop.inject.import.job.class", DummyImportJob.class, ImportJobBase.class);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool(), conf);
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected ImportException running this job.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedNoColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{""}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail due to no colnames.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedIllegalColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0", "zyzzyva"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail due bad colname.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testDuplicateColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0,DATA_COL0"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail!", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    private String[] getContent(Configuration conf, Path path) throws Exception {
        ClassLoader prevClassLoader = ClassLoaderStack.addJarFile((String)new Path(new Path(new SqoopOptions().getJarOutputDir()), this.getTableName() + ".jar").toString(), (String)this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FileStatus[] stats = fs.listStatus(path);
        Path[] paths = new Path[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            paths[i] = stats[i].getPath();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Path filePath : paths) {
            if (filePath.getName().startsWith("_") || filePath.getName().startsWith(".")) continue;
            SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)fs, filePath, new Configuration());
            WritableComparable key = (WritableComparable)reader.getKeyClass().newInstance();
            Writable value = (Writable)reader.getValueClass().newInstance();
            while (reader.next((Writable)key, value)) {
                strings.add(value.toString());
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return strings.toArray(new String[0]);
    }

    public void testDeleteTargetDir() throws Exception {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.delete(outputPath, true);
        TestImportJob.assertTrue((!fs.exists(outputPath) ? 1 : 0) != 0);
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0"}, conf);
        argv = Arrays.copyOf(argv, argv.length + 1);
        argv[argv.length - 1] = "--delete-target-dir";
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to go through if target directory does not exist.", (0 == ret ? 1 : 0) != 0);
            TestImportJob.assertTrue((boolean)fs.exists(outputPath));
            TestImportJob.assertTrue((String)"Expecting two files in the directory.", (fs.listStatus(outputPath).length == 2 ? 1 : 0) != 0);
            String[] output = this.getContent(conf, outputPath);
            TestImportJob.assertEquals((String)"Expected output and actual output should be same.", (String)"meep\n", (String)output[0]);
            ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to go through if target directory exists.", (0 == ret ? 1 : 0) != 0);
            TestImportJob.assertTrue((boolean)fs.exists(outputPath));
            TestImportJob.assertTrue((String)"Expecting two files in the directory.", (fs.listStatus(outputPath).length == 2 ? 1 : 0) != 0);
            output = this.getContent(conf, outputPath);
            TestImportJob.assertEquals((String)"Expected output and actual output should be same.", (String)"meep\n", (String)output[0]);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testManyColumns() throws Exception {
        int numberOfColumns = 7500;
        String[] colNames = new String[numberOfColumns];
        String[] colTypes = new String[numberOfColumns];
        String[] colVals = new String[numberOfColumns];
        ArrayList<String> testColVals = new ArrayList<String>(numberOfColumns);
        for (int i = 0; i < numberOfColumns; ++i) {
            colNames[i] = "DATA_COL" + Integer.toString(i);
            colTypes[i] = "VARCHAR(32)";
            colVals[i] = "'meep'";
            testColVals.add("meep");
        }
        this.createTableWithColTypesAndNames(colNames, colTypes, colVals);
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.delete(outputPath, true);
        TestImportJob.assertTrue((!fs.exists(outputPath) ? 1 : 0) != 0);
        String[] argv = this.getArgv(true, colNames, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to go through if target directory does not exist.", (0 == ret ? 1 : 0) != 0);
            TestImportJob.assertTrue((boolean)fs.exists(outputPath));
            TestImportJob.assertTrue((String)"Expecting two files in the directory.", (fs.listStatus(outputPath).length == 2 ? 1 : 0) != 0);
            String[] output = this.getContent(conf, outputPath);
            TestImportJob.assertEquals((String)"Expected output and actual output should be same.", (String)(StringUtils.join((CharSequence)",", testColVals) + "\n"), (String)output[0]);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public static class DummyImportJob
    extends ImportJobBase {
        public void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
            Path dir = new Path(this.options.getTempDir());
            Path p = new Path(dir, "sqoop-dummy-import-job-file.txt");
            LocalFileSystem fs = FileSystem.getLocal((Configuration)this.options.getConf());
            if (fs.exists(p)) {
                boolean result = fs.delete(p, false);
                TestCase.assertTrue((String)"Couldn't delete temp file!", (boolean)result);
            }
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(p)));
            w.append("This is a line!");
            w.close();
            FileInputFormat.addInputPath((Job)job, (Path)p);
            super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        }
    }

    public static class NullDereferenceMapper
    extends AutoProgressMapper<Object, Object, Text, NullWritable> {
        public void map(Object key, Object val, Mapper.Context c) throws IOException, InterruptedException {
            String s = null;
            s.length();
        }
    }
}

