/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.PostgresqlManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;

public class PostgresqlExportTest
extends ExportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)PostgresqlExportTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.postgresql.connectstring.host_url", "jdbc:postgresql://localhost/");
    static final String DATABASE_USER = System.getProperty("sqoop.test.postgresql.connectstring.username", "sqooptest");
    static final String DATABASE_NAME = System.getProperty("sqoop.test.postgresql.connectstring.database", "sqooptest");
    static final String PASSWORD = System.getProperty("sqoop.test.postgresql.connectstring.password");
    static final String TABLE_NAME = "EMPLOYEES_PG";
    static final String PROCEDURE_NAME = "INSERT_AN_EMPLOYEE";
    static final String STAGING_TABLE_NAME = "STAGING";
    static final String SCHEMA_PUBLIC = "public";
    static final String SCHEMA_SPECIAL = "special";
    static final String CONNECT_STRING = HOST_URL + DATABASE_NAME;
    protected Connection connection;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        LOG.debug((Object)("Setting up postgresql test: " + CONNECT_STRING));
        try {
            this.connection = DriverManager.getConnection(CONNECT_STRING, DATABASE_USER, PASSWORD);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Can't create connection", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        this.createTable(TABLE_NAME, SCHEMA_PUBLIC);
        this.createTable(STAGING_TABLE_NAME, SCHEMA_PUBLIC);
        this.createTable(TABLE_NAME, SCHEMA_SPECIAL);
        this.createTable(STAGING_TABLE_NAME, SCHEMA_SPECIAL);
        this.createProcedure(PROCEDURE_NAME, SCHEMA_PUBLIC);
        LOG.debug((Object)"setUp complete.");
    }

    @Override
    public void tearDown() {
        super.tearDown();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.error((Object)"Ignoring exception in tearDown", (Throwable)e);
        }
    }

    private void createTable(String tableName, String schema) {
        CreateIt createIt = new CreateIt(){

            @Override
            public void createIt(Statement st, String fullName, ConnManager manager) throws SQLException {
                st.executeUpdate("CREATE TABLE " + fullName + " (" + manager.escapeColName("id") + " INT NOT NULL PRIMARY KEY, " + manager.escapeColName("name") + " VARCHAR(24) NOT NULL, " + manager.escapeColName("start_date") + " DATE, " + manager.escapeColName("salary") + " FLOAT, " + manager.escapeColName("dept") + " VARCHAR(32))");
            }
        };
        this.create(tableName, "TABLE", schema, createIt);
    }

    private void createProcedure(String procedureName, String schema) {
        CreateIt createIt = new CreateIt(){

            @Override
            public void createIt(Statement st, String fullName, ConnManager manager) throws SQLException {
                st.executeUpdate("CREATE OR REPLACE FUNCTION " + fullName + " (" + "IN " + manager.escapeColName("id") + " INT," + "IN " + manager.escapeColName("name") + " VARCHAR(24)," + "IN " + manager.escapeColName("start_date") + " DATE," + "IN " + manager.escapeColName("salary") + " FLOAT," + "IN " + manager.escapeColName("dept") + " VARCHAR(32)" + ") " + "RETURNS VOID " + "AS $$ " + "BEGIN " + "INSERT INTO " + PostgresqlExportTest.this.escapeTableOrSchemaName(PostgresqlExportTest.SCHEMA_PUBLIC) + "." + PostgresqlExportTest.this.escapeTableOrSchemaName(PostgresqlExportTest.TABLE_NAME) + " (" + manager.escapeColName("id") + ", " + manager.escapeColName("name") + ", " + manager.escapeColName("start_date") + ", " + manager.escapeColName("salary") + ", " + manager.escapeColName("dept") + ") VALUES (" + manager.escapeColName("id") + ", " + manager.escapeColName("name") + ", " + manager.escapeColName("start_date") + ", " + manager.escapeColName("salary") + ", " + manager.escapeColName("dept") + ");" + "END;" + "$$ LANGUAGE plpgsql;");
            }
        };
        this.create(procedureName, "FUNCTION", schema, createIt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(String name, String type, String schema, CreateIt createIt) {
        SqoopOptions options = new SqoopOptions(CONNECT_STRING, name);
        options.setUsername(DATABASE_USER);
        PostgresqlManager manager = null;
        Statement st = null;
        try {
            manager = new PostgresqlManager(options);
            st = this.connection.createStatement();
            try {
                st.executeUpdate("CREATE SCHEMA " + this.escapeTableOrSchemaName(schema));
                this.connection.commit();
            }
            catch (SQLException e) {
                LOG.info((Object)("Couldn't create schema " + schema + " (is o.k. as long as" + "the schema already exists."), (Throwable)e);
                this.connection.rollback();
            }
            String fullTableName = this.escapeTableOrSchemaName(schema) + "." + this.escapeTableOrSchemaName(name);
            try {
                st.executeUpdate("DROP " + type + " " + fullTableName);
            }
            catch (SQLException e) {
                LOG.info((Object)("Couldn't drop " + type.toLowerCase() + " " + fullTableName + " (ok)"), (Throwable)e);
                this.connection.rollback();
            }
            createIt.createIt(st, fullTableName, (ConnManager)manager);
            this.connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            PostgresqlExportTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != manager) {
                    manager.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
        LOG.debug((Object)"setUp complete.");
    }

    private String[] getArgv(boolean useTable, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        if (useTable) {
            args.add("--table");
            args.add(TABLE_NAME);
        } else {
            args.add("--call");
            args.add(PROCEDURE_NAME);
        }
        args.add("--export-dir");
        args.add(this.getWarehouseDir());
        args.add("--fields-terminated-by");
        args.add(",");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("--connect");
        args.add(CONNECT_STRING);
        args.add("--username");
        args.add(DATABASE_USER);
        args.add("-m");
        args.add("1");
        for (String arg : extraArgs) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    protected void createTestFile(String filename, String[] lines) throws IOException {
        new File(this.getWarehouseDir()).mkdirs();
        File file = new File(this.getWarehouseDir() + "/" + filename);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        for (String line : lines) {
            output.write(line);
            output.write("\n");
        }
        ((Writer)output).close();
    }

    public void testExport() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        this.runExport(this.getArgv(true, new String[0]));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportUsingProcedure() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        this.runExport(this.getArgv(false, new String[0]));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportStaging() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--staging-table", STAGING_TABLE_NAME};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportDirect() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--direct"};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportCustomSchema() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--", "--schema", SCHEMA_SPECIAL};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(SCHEMA_SPECIAL) + "." + this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportCustomSchemaStaging() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--staging-table", STAGING_TABLE_NAME, "--", "--schema", SCHEMA_SPECIAL};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(SCHEMA_SPECIAL) + "." + this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportCustomSchemaStagingClear() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--staging-table", STAGING_TABLE_NAME, "--clear-staging-table", "--", "--schema", SCHEMA_SPECIAL};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(SCHEMA_SPECIAL) + "." + this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    public void testExportCustomSchemaDirect() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"});
        String[] extra = new String[]{"--direct", "--", "--schema", SCHEMA_SPECIAL};
        this.runExport(this.getArgv(true, extra));
        PostgresqlExportTest.assertRowCount(2L, this.escapeTableOrSchemaName(SCHEMA_SPECIAL) + "." + this.escapeTableOrSchemaName(TABLE_NAME), this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertRowCount(long expected, String tableName, Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM " + tableName);
            rs.next();
            PostgresqlExportTest.assertEquals((long)expected, (long)rs.getLong(1));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't verify number of rows", (Throwable)e);
            PostgresqlExportTest.fail();
        }
        finally {
            try {
                connection.commit();
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                LOG.info((Object)"Ignored exception in finally block.");
            }
        }
    }

    public String escapeTableOrSchemaName(String tableName) {
        return "\"" + tableName + "\"";
    }

    private static interface CreateIt {
        public void createIt(Statement var1, String var2, ConnManager var3) throws SQLException;
    }
}

