/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.OracleCompatTest;
import com.cloudera.sqoop.manager.OracleUtils;
import com.cloudera.sqoop.testutil.LobAvroImportTestCase;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Formatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class OracleLobAvroImportTest
extends LobAvroImportTestCase {
    public static final Log LOG = LogFactory.getLog((String)OracleCompatTest.class.getName());

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected String getDbFriendlyName() {
        return "Oracle";
    }

    @Override
    protected String getConnectString() {
        return OracleUtils.CONNECT_STRING;
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        OracleUtils.setOracleAuth(opts);
        return opts;
    }

    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        OracleUtils.dropTable(table, this.getManager());
    }

    @Override
    protected String getBlobInsertStr(String blobData) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        Formatter fmt = new Formatter(sb);
        try {
            for (byte b : blobData.getBytes("UTF-8")) {
                fmt.format("%02X", b);
            }
        }
        catch (UnsupportedEncodingException uee) {
            OracleLobAvroImportTest.fail((String)"Could not get utf-8 bytes for blob string");
            return null;
        }
        sb.append("'");
        return sb.toString();
    }
}

