/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;

public class SQLServerSplitByManualTest
extends ImportJobTestCase {
    @Override
    public void setUp() {
        super.setUp();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.createTableFromSQL("CREATE TABLE TPCH1M_LINEITEM( [L_ORDERKEY] [int] NULL, [L_PARTKEY] [int] NULL, [L_SUPPKEY] [int] NULL, [L_LINENUMBER] [int] NULL, [L_QUANTITY] [int] NULL, [L_EXTENDEDPRICE] [decimal](15, 2) NULL, [L_DISCOUNT] [decimal](15, 2) NULL, [L_TAX] [decimal](15, 2) NULL, [L_RETURNFLAG] [varchar](max) NULL, [L_LINESTATUS] [varchar](max) NULL, [L_SHIPDATE] [varchar](max) NULL, [L_COMMITDATE] [varchar](max) NULL, [L_RECEIPTDATE] [varchar](max) NULL, [L_SHIPINSTRUCT] [varchar](max) NULL, [L_SHIPMODE] [varchar](max) NULL, [L_COMMENT] [varchar](max) NULL) ");
            utils.populateLineItem();
        }
        catch (SQLException e) {
            LOG.error((Object)("Setup fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerSplitByManualTest.fail((String)("Setup fail with SQLException: " + e.toString()));
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.dropTableIfExists("TPCH1M_LINEITEM");
        }
        catch (SQLException e) {
            LOG.error((Object)("TearDown fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerSplitByManualTest.fail((String)("TearDown fail with SQLException: " + e.toString()));
        }
    }

    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, String splitByCol) {
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add("tpch1m_lineitem");
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add("L_ORDERKEY");
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-sequencefile");
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runSplitByTest(String splitByCol, int expectedSum) throws IOException {
        String[] columns = new String[]{"L_ORDERKEY", "L_PARTKEY", "L_SUPPKEY", "L_LINENUMBER", "L_QUANTITY", "L_EXTENDEDPRICE", "L_DISCOUNT", "L_TAX", "L_RETURNFLAG", "L_LINESTATUS", "L_SHIPDATE", "L_COMMITDATE", "L_RECEIPTDATE", "L_SHIPINSTRUCT", "L_SHIPMODE", "L_COMMENT"};
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, columns, splitByCol);
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, columns, splitByCol), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            LOG.debug((Object)("Got jar from import job: " + jarFileName));
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            int curSum = 0;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                curSum += this.getFirstInt(val.toString());
            }
            System.out.println("Sum : e,c" + expectedSum + " : " + curSum);
            SQLServerSplitByManualTest.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            IOUtils.closeStream((Closeable)reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            SQLServerSplitByManualTest.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)pe));
            SQLServerSplitByManualTest.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testSplitByFirstCol() throws IOException {
        String splitByCol = "L_ORDERKEY";
        this.runSplitByTest(splitByCol, 10);
    }

    public void testSplitBySecondCol() throws IOException {
        String splitByCol = "L_PARTKEY";
        this.runSplitByTest(splitByCol, 10);
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    @Override
    protected String getTableName() {
        return "tpch1m_lineitem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        System.out.println("@abhi SQL for drop :" + sqlStmt);
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        opts.setUsername(username);
        opts.setPassword(password);
        return opts;
    }
}

