/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestDataFileParser;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;
import org.apache.sqoop.manager.sqlserver.SQLServerDatatypeImportSequenceFileManualTest;

public class SQLServerDatatypeImportDelimitedFileManualTest
extends SQLServerDatatypeImportSequenceFileManualTest {
    @Override
    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, Configuration conf) {
        if (null == colNames) {
            colNames = this.getColNames();
        }
        String splitByCol = colNames[0];
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--num-mappers");
        args.add("2");
        args.addAll(this.getExtraArgs(conf));
        return args.toArray(new String[0]);
    }

    private void runSqoopImport(String[] importCols) {
        int ret;
        Configuration conf = this.getConf();
        SqoopOptions opts = this.getSqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        opts.setUsername(username);
        opts.setPassword(password);
        try {
            Sqoop importer = new Sqoop((SqoopTool)new ImportTool(), conf, opts);
            ret = Sqoop.runSqoop((Sqoop)importer, (String[])this.getArgv(true, importCols, conf));
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            throw new RuntimeException(e);
        }
        SQLServerDatatypeImportDelimitedFileManualTest.assertEquals((String)"Failure during job", (int)0, (int)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verifyImport(String expectedVal, String[] importCols) {
        Path tableDirPath = this.getTablePath();
        this.removeTableDir();
        this.runSqoopImport(importCols);
        Configuration conf = this.getConf();
        SqoopOptions opts = this.getSqoopOptions(conf);
        try {
            ImportTool importTool = new ImportTool();
            opts = importTool.parseArguments(this.getArgv(false, importCols, conf), conf, opts, true);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            SQLServerDatatypeImportDelimitedFileManualTest.fail((String)e.toString());
        }
        CompilationManager compileMgr = new CompilationManager(opts);
        String jarFileName = compileMgr.getJarFilename();
        ClassLoader prevClassLoader = null;
        try {
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileStatus[] stats = fs.listStatus(tableDirPath);
            if (stats == null || stats.length == 0) {
                SQLServerDatatypeImportDelimitedFileManualTest.fail((String)("Error: no files in " + tableDirPath));
            }
            boolean foundRecord = false;
            for (FileStatus stat : stats) {
                if (!stat.getPath().getName().startsWith("part-") && !stat.getPath().getName().startsWith("data-")) continue;
                try {
                    String line;
                    String fname = stat.getPath().toString();
                    fname = fname.substring(5, fname.length());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fname))));
                    try {
                        line = reader.readLine();
                        SQLServerDatatypeImportDelimitedFileManualTest.assertEquals((String)" expected a different string", (String)expectedVal, (String)line);
                    }
                    finally {
                        IOUtils.closeStream((Closeable)reader);
                    }
                    LOG.info((Object)("Read back from sequencefile: " + line));
                    foundRecord = true;
                    if (null != expectedVal) continue;
                    SQLServerDatatypeImportDelimitedFileManualTest.assertEquals((String)"Error validating result from SeqFile", (String)"null\n", (String)line);
                }
                catch (EOFException eoe) {
                    // empty catch block
                }
            }
            if (!foundRecord) {
                SQLServerDatatypeImportDelimitedFileManualTest.fail((String)"Couldn't read any records from SequenceFiles");
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            SQLServerDatatypeImportDelimitedFileManualTest.fail((String)("IOException: " + ioe.toString()));
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
            }
        }
    }

    @Override
    public void testVarBinary() {
        if (!this.supportsVarBinary()) {
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.VARBINARY);
    }

    @Override
    public void testTime() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.TIME);
    }

    @Override
    public String getResportFileName() {
        return ((Object)((Object)this)).getClass().toString() + ".txt";
    }
}

