/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.netezza;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.DirectNetezzaManager;
import org.apache.sqoop.manager.netezza.NetezzaExportManualTest;
import org.apache.sqoop.manager.netezza.NetezzaTestUtils;
import org.junit.Test;

public class DirectNetezzaExportManualTest
extends NetezzaExportManualTest {
    public static final Log LOG = LogFactory.getLog((String)DirectNetezzaExportManualTest.class.getName());
    static final String TABLE_PREFIX = "EMPNZ_D_EXP";

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected boolean isDirectMode() {
        return true;
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 4];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = NetezzaTestUtils.getNZUser();
        moreArgs[i++] = "--password";
        moreArgs[i++] = NetezzaTestUtils.getNZPassword();
        return super.getCodeGenArgv(moreArgs);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] argV = super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, new String[0]);
        String[] subArgV = this.newStrArray(argV, "--direct", "--username", NetezzaTestUtils.getNZUser(), "--password", NetezzaTestUtils.getNZPassword());
        String[] newArgV = new String[subArgV.length + additionalArgv.length];
        int i = 0;
        for (String s : subArgV) {
            newArgV[i++] = s;
        }
        for (String s : additionalArgv) {
            newArgV[i++] = s;
        }
        return newArgV;
    }

    @Override
    public void createTable(TestExport.ColumnGenerator ... extraColumns) throws SQLException {
        NetezzaTestUtils.createTableNZ(this.conn, this.getTableName(), extraColumns);
    }

    @Override
    public void createStagingTable(TestExport.ColumnGenerator ... extraColumns) throws SQLException {
        NetezzaTestUtils.createTableNZ(this.conn, this.getStagingTableName(), extraColumns);
    }

    protected void runNetezzaTest(String tableName, String[] argv, TestExport.ColumnGenerator ... extraCols) throws IOException {
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        LOG.info((Object)("Running export with argv : " + Arrays.toString(argv)));
        this.manager = new DirectNetezzaManager(options);
        try {
            this.createTable(extraCols);
            LOG.info((Object)("Created table " + tableName));
            this.createExportFile(extraCols);
            this.runExport(argv);
            this.verifyExport(3, this.conn);
            if (extraCols.length > 0) {
                this.assertColMinAndMax(this.forIdx(0), extraCols[0]);
            }
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            DirectNetezzaExportManualTest.fail((String)("SQLException when accessing target table. " + sqlE));
        }
    }

    @Test
    public void testSimpleExport() throws IOException, SQLException {
        String[] argv = this.getArgv(true, 10, 10, new String[0]);
        this.runNetezzaTest(this.getTableName(), argv, new TestExport.ColumnGenerator[0]);
    }

    @Test
    public void testValidExtraArgs() throws Exception {
        String[] extraArgs = new String[]{"--", "--log-dir", "/tmp", "--max-errors", "2"};
        String[] argv = this.getArgv(true, 10, 10, extraArgs);
        this.runNetezzaTest(this.getTableName(), argv, new TestExport.ColumnGenerator[0]);
    }

    @Test
    public void testNullStringExport() throws Exception {
        String[] extraArgs = new String[]{"--input-null-string", "\\\\N", "--input-null-non-string", "\\\\N", "--input-escaped-by", "\\"};
        TestExport.ColumnGenerator[] extraCols = new TestExport.ColumnGenerator[]{new NetezzaExportManualTest.NullColumnGenerator(this)};
        String[] argv = this.getArgv(true, 10, 10, extraArgs);
        this.runNetezzaTest(this.getTableName(), argv, extraCols);
    }

    public void testDifferentNullStrings() throws IOException, SQLException {
        TestExport.ColumnGenerator[] extraCols = new TestExport.ColumnGenerator[]{new NetezzaExportManualTest.NullColumnGenerator(this)};
        String[] extraArgs = new String[]{"--input-null-string", "\\N", "--input-null-non-string", "\\M"};
        String[] argv = this.getArgv(true, 10, 10, extraArgs);
        try {
            this.runNetezzaTest(this.getTableName(), argv, extraCols);
            DirectNetezzaExportManualTest.fail((String)"Expected failure for different null strings");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test(expected=IOException.class)
    public void testLongNullStrings() throws IOException, SQLException {
        TestExport.ColumnGenerator[] extraCols = new TestExport.ColumnGenerator[]{new NetezzaExportManualTest.NullColumnGenerator(this)};
        String[] extraArgs = new String[]{"--input-null-string", "morethan4chars", "--input-null-non-string", "morethan4chars"};
        String[] argv = this.getArgv(true, 10, 10, extraArgs);
        try {
            this.runNetezzaTest(this.getTableName(), argv, extraCols);
            DirectNetezzaExportManualTest.fail((String)"Expected failure for long null strings");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Override
    public void testMultiMapTextExportWithStaging() throws IOException, SQLException {
    }

    @Override
    public void testMultiTransactionWithStaging() throws IOException, SQLException {
    }

    @Override
    public void testColumnsExport() throws IOException, SQLException {
    }

    @Override
    public void testSequenceFileExport() throws IOException, SQLException {
    }
}

