/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.IntegerSplitter;
import java.sql.SQLException;
import java.util.List;
import junit.framework.TestCase;

public class TestIntegerSplitter
extends TestCase {
    private long[] toLongArray(List<Long> in) {
        long[] out = new long[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            out[i] = in.get(i);
        }
        return out;
    }

    public String formatLongArray(long[] ar) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (long val : ar) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(Long.toString(val));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public void assertLongArrayEquals(long[] expected, long[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            try {
                TestIntegerSplitter.assertEquals((String)("Failure at position " + i + "; got " + actual[i] + " instead of " + expected[i] + "; actual array is " + this.formatLongArray(actual)), (long)expected[i], (long)actual[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                TestIntegerSplitter.fail((String)("Expected array with " + expected.length + " elements; got " + actual.length + ". Actual array is " + this.formatLongArray(actual)));
            }
        }
        if (actual.length > expected.length) {
            TestIntegerSplitter.fail((String)("Actual array has " + actual.length + " elements; expected " + expected.length + ". Actual array is " + this.formatLongArray(actual)));
        }
    }

    public void testEvenSplits() throws SQLException {
        List splits = new IntegerSplitter().split(10L, 0L, 100L);
        long[] expected = new long[]{0L, 10L, 20L, 30L, 40L, 50L, 60L, 70L, 80L, 90L, 100L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testOddSplits() throws SQLException {
        List splits = new IntegerSplitter().split(10L, 0L, 95L);
        long[] expected = new long[]{0L, 10L, 20L, 30L, 40L, 50L, 59L, 68L, 77L, 86L, 95L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testSingletonSplit() throws SQLException {
        List splits = new IntegerSplitter().split(1L, 5L, 5L);
        long[] expected = new long[]{5L, 5L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testSingletonSplit2() throws SQLException {
        List splits = new IntegerSplitter().split(5L, 5L, 5L);
        long[] expected = new long[]{5L, 5L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testTooManySplits() throws SQLException {
        List splits = new IntegerSplitter().split(5L, 3L, 5L);
        long[] expected = new long[]{3L, 4L, 5L, 5L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testExactSplitsAsInterval() throws SQLException {
        List splits = new IntegerSplitter().split(5L, 1L, 5L);
        long[] expected = new long[]{1L, 2L, 3L, 4L, 5L, 5L};
        this.assertLongArrayEquals(expected, this.toLongArray(splits));
    }

    public void testBigIntSplits() throws SQLException {
        List splits = new IntegerSplitter().split(4L, 14L, 7863696997872966707L);
        TestIntegerSplitter.assertEquals((int)splits.size(), (int)5);
    }
}

