/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import java.io.InputStream;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.apache.sqoop.manager.oracle.util.OracleDataDefinition;
import org.apache.sqoop.manager.oracle.util.OracleTableDefinition;

public final class OracleData {
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private OracleData() {
    }

    private static String getColumnList(List<OracleDataDefinition> columnList) {
        StringBuilder result = new StringBuilder();
        String delim = "";
        for (OracleDataDefinition column : columnList) {
            result.append(delim).append(column.getColumnName()).append(" ").append(column.getDataType());
            delim = ",\n";
        }
        return result.toString();
    }

    private static String getDataExpression(List<OracleDataDefinition> columnList) {
        StringBuilder result = new StringBuilder();
        for (OracleDataDefinition column : columnList) {
            result.append("l_ret_rec.").append(column.getColumnName()).append(" := ").append(column.getDataExpression()).append(";\n");
        }
        return result.toString();
    }

    private static void createPackageSpec(Connection conn, OracleTableDefinition tableDefinition) throws Exception {
        String pkgSql = IOUtils.toString((InputStream)classLoader.getResource("oraoop/pkg_tst_product_gen.psk").openStream());
        pkgSql = pkgSql.replaceAll("\\$COLUMN_LIST", OracleData.getColumnList(tableDefinition.getColumnList()));
        pkgSql = pkgSql.replaceAll("\\$TABLE_NAME", tableDefinition.getTableName());
        PreparedStatement stmt = conn.prepareStatement(pkgSql);
        stmt.execute();
    }

    private static void createPackageBody(Connection conn, OracleTableDefinition tableDefinition) throws Exception {
        String pkgSql = IOUtils.toString((InputStream)classLoader.getResource("oraoop/pkg_tst_product_gen.pbk").openStream());
        pkgSql = pkgSql.replaceAll("\\$COLUMN_LIST", OracleData.getColumnList(tableDefinition.getColumnList()));
        pkgSql = pkgSql.replaceAll("\\$TABLE_NAME", tableDefinition.getTableName());
        pkgSql = pkgSql.replaceAll("\\$DATA_EXPRESSION_LIST", OracleData.getDataExpression(tableDefinition.getColumnList()));
        pkgSql = pkgSql.replaceAll("\\$PARTITION_CLAUSE", tableDefinition.getPartitionClause());
        PreparedStatement stmt = conn.prepareStatement(pkgSql);
        stmt.execute();
    }

    private static void createKey(Connection conn, KeyType keyType, OracleTableDefinition tableDefinition) throws Exception {
        List<String> columns = null;
        switch (keyType) {
            case PRIMARY: {
                columns = tableDefinition.getPrimaryKeyColumns();
                break;
            }
            case UNIQUE: {
                columns = tableDefinition.getUniqueKeyColumns();
                break;
            }
            default: {
                throw new RuntimeException("Missing key type.");
            }
        }
        if (columns != null && columns.size() > 0) {
            StringBuilder keyColumnList = new StringBuilder();
            String delim = "";
            for (String column : columns) {
                keyColumnList.append(delim).append(column);
                delim = ",";
            }
            String keySql = "alter table \"$TABLE_NAME\" add constraint \"$TABLE_NAME_" + (keyType == KeyType.PRIMARY ? "PK\" primary key" : "UK\" unique") + "($PK_COLUMN_LIST) " + "using index (create unique index \"$TABLE_NAME_" + (keyType == KeyType.PRIMARY ? "PK\"" : "UK\"") + " on \"$TABLE_NAME\"($PK_COLUMN_LIST) " + "parallel nologging)";
            keySql = keySql.replaceAll("\\$TABLE_NAME", tableDefinition.getTableName());
            keySql = keySql.replaceAll("\\$PK_COLUMN_LIST", keyColumnList.toString());
            PreparedStatement stmt = conn.prepareStatement(keySql);
            stmt.execute();
        }
    }

    public static int getParallelProcesses(Connection conn) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("SELECT cc.value value\nFROM\n  (SELECT to_number(value) value\n  FROM v$parameter\n  WHERE name='parallel_max_servers'\n  ) pms,\n  (SELECT to_number(value) value\n  FROM v$parameter\n  WHERE name='parallel_threads_per_cpu'\n  ) ptpc,\n  (SELECT to_number(value) value FROM v$parameter    WHERE name='cpu_count'\n  ) cc");
        ResultSet res = stmt.executeQuery();
        res.next();
        return res.getInt(1);
    }

    public static void createTable(Connection conn, OracleTableDefinition tableDefinition, int parallelDegree, int rowsPerSlave) throws Exception {
        OracleData.createPackageSpec(conn, tableDefinition);
        OracleData.createPackageBody(conn, tableDefinition);
        CallableStatement procStmt = conn.prepareCall("begin \"PKG_ODG_" + tableDefinition.getTableName() + "\".prc_load_table(?,?); end;");
        procStmt.setInt(1, parallelDegree);
        procStmt.setInt(2, rowsPerSlave);
        procStmt.execute();
        OracleData.createKey(conn, KeyType.PRIMARY, tableDefinition);
        OracleData.createKey(conn, KeyType.UNIQUE, tableDefinition);
    }

    public static void createTable(Connection conn, String fileName, int parallelDegree, int rowsPerSlave) throws Exception {
        URL file = classLoader.getResource("oraoop/" + fileName);
        OracleTableDefinition tableDefinition = new OracleTableDefinition(file);
        OracleData.createTable(conn, tableDefinition, parallelDegree, rowsPerSlave);
    }

    static {
        if (classLoader == null) {
            classLoader = OraOopTestCase.class.getClassLoader();
        }
    }

    static enum KeyType {
        PRIMARY,
        UNIQUE;

    }
}

