/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.manager.OracleUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.util.HadoopFiles;
import org.apache.sqoop.manager.oracle.util.OracleData;

public abstract class OraOopTestCase {
    private static final OraOopLog LOG = OraOopLogFactory.getLog((String)OraOopTestCase.class.getName());
    private String sqoopGenLibDirectory = System.getProperty("user.dir") + "/target/tmp/lib";
    private String sqoopGenSrcDirectory = System.getProperty("user.dir") + "/target/tmp/src";
    private String sqoopTargetDirectory = "target/tmp/";
    private String sqoopGenClassName = "org.apache.sqoop.gen.OraOopTestClass";
    private Connection conn;
    protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public OraOopTestCase() {
        if (this.classLoader == null) {
            this.classLoader = OraOopTestCase.class.getClassLoader();
        }
    }

    protected String getSqoopTargetDirectory() {
        return this.sqoopTargetDirectory;
    }

    protected void setSqoopTargetDirectory(String newSqoopTargetDirectory) {
        this.sqoopTargetDirectory = newSqoopTargetDirectory;
    }

    protected String getSqoopGenLibDirectory() {
        return this.sqoopGenLibDirectory;
    }

    protected String getSqoopGenSrcDirectory() {
        return this.sqoopGenSrcDirectory;
    }

    protected String getSqoopGenClassName() {
        return this.sqoopGenClassName;
    }

    protected Connection getTestEnvConnection() throws SQLException {
        if (this.conn == null) {
            this.conn = DriverManager.getConnection(OracleUtils.CONNECT_STRING, "SQOOPTEST", "12345");
        }
        return this.conn;
    }

    protected void closeTestEnvConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn = null;
    }

    protected void createTable(String fileName) {
        block5: {
            try {
                Connection localConn = this.getTestEnvConnection();
                int parallelProcesses = OracleData.getParallelProcesses(localConn);
                int rowsPerSlave = 10000 / parallelProcesses;
                try {
                    long startTime = System.currentTimeMillis();
                    OracleData.createTable(localConn, fileName, parallelProcesses, rowsPerSlave);
                    LOG.debug((Object)("Created and loaded table in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds."));
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 955) {
                        LOG.debug((Object)"Table already exists - using existing data");
                        break block5;
                    }
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected int countTable(String inputTableName, List<String> partitionList) {
        String tableName = inputTableName;
        if (tableName.startsWith("\"\"") && tableName.endsWith("\"\"")) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        String sql = null;
        int numRows = 0;
        if (partitionList != null && partitionList.size() > 0) {
            sql = "SELECT sum(cnt) FROM (";
            int i = 0;
            for (String partition : partitionList) {
                if (++i > 1) {
                    sql = sql + " UNION ALL ";
                }
                sql = sql + "SELECT count(*) cnt FROM " + tableName + " PARTITION(\"" + partition + "\")";
            }
            sql = sql + ")";
        } else {
            sql = "SELECT count(*) FROM " + tableName;
        }
        try {
            PreparedStatement stmt = this.getTestEnvConnection().prepareStatement(sql);
            stmt.execute();
            ResultSet results = stmt.getResultSet();
            results.next();
            numRows = results.getInt(1);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not count number of rows in table " + tableName, e);
        }
        return numRows;
    }

    protected Configuration getSqoopConf() {
        Configuration sqoopConf = new Configuration();
        return sqoopConf;
    }

    protected int runImport(String tableName, Configuration sqoopConf, boolean sequenceFile) {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        StringWriter stringWriter = new StringWriter();
        PatternLayout layout = new PatternLayout("%d{yy/MM/dd HH:mm:ss} %p %c{2}: %m%n");
        WriterAppender writerAppender = new WriterAppender((Layout)layout, (Writer)stringWriter);
        rootLogger.addAppender((Appender)writerAppender);
        ArrayList<String> sqoopArgs = new ArrayList<String>();
        sqoopArgs.add("import");
        if (sequenceFile) {
            sqoopArgs.add("--as-sequencefile");
        }
        sqoopArgs.add("--connect");
        sqoopArgs.add(OracleUtils.CONNECT_STRING);
        sqoopArgs.add("--username");
        sqoopArgs.add("SQOOPTEST");
        sqoopArgs.add("--password");
        sqoopArgs.add("12345");
        sqoopArgs.add("--table");
        sqoopArgs.add(tableName);
        sqoopArgs.add("--target-dir");
        sqoopArgs.add(this.sqoopTargetDirectory);
        sqoopArgs.add("--class-name");
        sqoopArgs.add(this.getSqoopGenClassName());
        sqoopArgs.add("--bindir");
        sqoopArgs.add(this.sqoopGenLibDirectory);
        sqoopArgs.add("--outdir");
        sqoopArgs.add(this.sqoopGenSrcDirectory);
        int rowsInTable = this.countTable(tableName, OraOopUtilities.splitOracleStringList((String)sqoopConf.get("oraoop.import.partitions")));
        int retCode = Sqoop.runTool((String[])sqoopArgs.toArray(new String[sqoopArgs.size()]), (Configuration)sqoopConf);
        int rowsImported = 0;
        if (retCode == 0) {
            String logString = stringWriter.toString();
            Pattern pattern = Pattern.compile("(INFO mapreduce.ImportJobBase: Retrieved )([0-9]+)( records.)");
            Matcher matcher = pattern.matcher(logString);
            while (matcher.find()) {
                rowsImported = Integer.parseInt(matcher.group(2));
            }
        }
        if (retCode != 0 || rowsInTable != rowsImported) {
            System.out.println(stringWriter.toString());
        }
        Assert.assertEquals((String)"Incorrect number of rows imported", (int)rowsInTable, (int)rowsImported);
        return retCode;
    }

    protected int runExportFromTemplateTable(String templateTableName, String tableName) {
        ArrayList<String> sqoopArgs = new ArrayList<String>();
        sqoopArgs.add("export");
        sqoopArgs.add("--connect");
        sqoopArgs.add(OracleUtils.CONNECT_STRING);
        sqoopArgs.add("--username");
        sqoopArgs.add("SQOOPTEST");
        sqoopArgs.add("--password");
        sqoopArgs.add("12345");
        sqoopArgs.add("--table");
        sqoopArgs.add(tableName);
        sqoopArgs.add("--export-dir");
        sqoopArgs.add(this.sqoopTargetDirectory);
        sqoopArgs.add("--class-name");
        sqoopArgs.add(this.getSqoopGenClassName());
        sqoopArgs.add("--bindir");
        sqoopArgs.add(this.sqoopGenLibDirectory);
        sqoopArgs.add("--outdir");
        sqoopArgs.add(this.sqoopGenSrcDirectory);
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.template.table", templateTableName);
        sqoopConf.setBoolean("oraoop.drop.table", true);
        sqoopConf.setBoolean("oraoop.nologging", true);
        sqoopConf.setBoolean("oraoop.partitioned", false);
        return Sqoop.runTool((String[])sqoopArgs.toArray(new String[sqoopArgs.size()]), (Configuration)sqoopConf);
    }

    protected int runCompareTables(Connection connection, String table1, String table2) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("select count(*) from (select * from (select * from " + table1 + " minus select * from " + table2 + ") union all select * from (select * from " + table2 + " minus select * from " + table1 + "))");
        ResultSet results = stmt.executeQuery();
        results.next();
        int numDifferences = results.getInt(1);
        return numDifferences;
    }

    protected void cleanupFolders() throws Exception {
        HadoopFiles.delete(new Path(this.getSqoopTargetDirectory()), true);
        HadoopFiles.delete(new Path(this.getSqoopGenSrcDirectory()), true);
        HadoopFiles.delete(new Path(this.getSqoopGenLibDirectory()), true);
    }

    static {
        Configuration.addDefaultResource((String)"oraoop-site-template.xml");
        Configuration.addDefaultResource((String)"oraoop-site.xml");
    }
}

