/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.junit.Test;

public class ImportTest
extends OraOopTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductImport() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product");
        this.createTable("table_tst_product.xml");
        try {
            int retCode = this.runImport("tst_product", this.getSqoopConf(), false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductPartImport() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_part");
        this.createTable("table_tst_product_part.xml");
        try {
            int retCode = this.runImport("tst_product_part", this.getSqoopConf(), false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductPartImportPartitionChunk() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_part");
        this.createTable("table_tst_product_part.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.PARTITION.toString());
        try {
            int retCode = this.runImport("tst_product_part", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductPartImportSubset() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_part");
        this.createTable("table_tst_product_part.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.ROWID.toString());
        sqoopConf.set("oraoop.import.partitions", "tst_product_part_1,tst_product_part_2,\"tst_product_pa#rt_6\"");
        try {
            int retCode = this.runImport("tst_product_part", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductPartImportSubsetPartitionChunk() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_part");
        this.createTable("table_tst_product_part.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.PARTITION.toString());
        sqoopConf.set("oraoop.import.partitions", "tst_product_part_1,tst_product_part_2,tst_product_part_3,\"tst_product_pa#rt_6\"");
        try {
            int retCode = this.runImport("tst_product_part", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductSubPartImport() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_subpart");
        this.createTable("table_tst_product_subpart.xml");
        try {
            int retCode = this.runImport("tst_product_subpart", this.getSqoopConf(), false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductSubPartImportPartitionChunk() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_subpart");
        this.createTable("table_tst_product_subpart.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.PARTITION.toString());
        try {
            int retCode = this.runImport("tst_product_subpart", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductSubPartImportSubset() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_subpart");
        this.createTable("table_tst_product_subpart.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.ROWID.toString());
        sqoopConf.set("oraoop.import.partitions", "TST_PRODUCT_PART_1,TST_PRODUCT_PART_2,TST_PRODUCT_PART_3,TST_PRODUCT_PART_4");
        try {
            int retCode = this.runImport("tst_product_subpart", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductSubPartImportSubsetPartitionChunk() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product_subpart");
        this.createTable("table_tst_product_subpart.xml");
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.set("oraoop.chunk.method", OraOopConstants.OraOopOracleDataChunkMethod.PARTITION.toString());
        sqoopConf.set("oraoop.import.partitions", "TST_PRODUCT_PART_1,TST_PRODUCT_PART_2,TST_PRODUCT_PART_3");
        try {
            int retCode = this.runImport("tst_product_subpart", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductImportConsistentRead() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "tst_product");
        this.createTable("table_tst_product.xml");
        Thread.sleep(10000L);
        Configuration sqoopConf = this.getSqoopConf();
        sqoopConf.setBoolean("oraoop.import.consistent.read", true);
        try {
            int retCode = this.runImport("tst_product", sqoopConf, false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductImportMixedCaseTableName() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "T5+_Pr#duct");
        this.createTable("table_tst_product_special_chars.xml");
        try {
            int retCode = this.runImport("\"\"T5+_Pr#duct\"\"", this.getSqoopConf(), false);
            Assert.assertEquals((String)"Return code should be 0", (int)0, (int)retCode);
        }
        finally {
            this.cleanupFolders();
            this.closeTestEnvConnection();
        }
    }
}

