/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.netezza;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.manager.netezza.NetezzaTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NetezzaImportManualTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)NetezzaImportManualTest.class.getName());
    private NetezzaManager manager;
    private Connection conn;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getTableName() {
        return NetezzaTestUtils.TABLE_NAME + "_IMP_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(String tableName, String ... extraColumns) throws SQLException {
        PreparedStatement statement = this.conn.prepareStatement("DROP TABLE " + tableName, 1003, 1007);
        try {
            statement.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException sqle) {
            this.conn.rollback();
        }
        finally {
            statement.close();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + tableName + " (");
        sb.append("id INT NOT NULL PRIMARY KEY, ");
        sb.append("name VARCHAR(24) NOT NULL, ");
        sb.append("start_date DATE, ");
        sb.append("Salary FLOAT, ");
        sb.append("Fired BOOL, ");
        sb.append("dept VARCHAR(32) ");
        for (String col : extraColumns) {
            sb.append(", " + col + "  INTEGER");
        }
        sb.append(")");
        statement = this.conn.prepareStatement(sb.toString(), 1003, 1007);
        try {
            statement.executeUpdate();
            this.conn.commit();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTable(String tableName) throws SQLException {
        Statement statement = this.conn.createStatement();
        try {
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(1,'Aaron','2009-05-14',1000000.00,TRUE,'engineering')");
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(2,'Bob','2009-04-20',400.00,TRUE,'sales')");
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(3,'Fred','2009-01-23',15.00,FALSE,'marketing')");
            this.conn.commit();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableWithNull(String tableName) throws SQLException {
        Statement statement = this.conn.createStatement();
        try {
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(1,'Aaron','2009-05-14',1000000.00,TRUE," + "'engineering',NULL,1)");
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(2,'Bob','2009-04-20',400.00,TRUE,'sales',NULL,2)");
            statement.executeUpdate("INSERT INTO " + tableName + " VALUES(3,'Fred','2009-01-23',15.00,FALSE,'marketing',NULL,3)");
            this.conn.commit();
        }
        finally {
            statement.close();
        }
    }

    public void setUpData() {
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        try {
            this.manager = new NetezzaManager(options);
            this.conn = this.manager.getConnection();
            this.createTable(this.getTableName(), new String[0]);
            this.populateTable(this.getTableName());
            String tableNameWithNull = this.getTableName() + "_W_N";
            this.createTable(tableNameWithNull, "col0", "col1");
            this.populateTableWithNull(tableNameWithNull);
        }
        catch (SQLException sqlE) {
            NetezzaImportManualTest.fail((String)("Setup failed with SQLException " + sqlE));
        }
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.setUpData();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            NetezzaImportManualTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    private String[] getExpectedResults() {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000.0,true,engineering", "2,Bob,2009-04-20,400.0,true,sales", "3,Fred,2009-01-23,15.0,false,marketing"};
        return expectedResults;
    }

    private String[] getDirectModeExpectedResults() {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000,T,engineering", "2,Bob,2009-04-20,400,T,sales", "3,Fred,2009-01-23,15,F,marketing"};
        return expectedResults;
    }

    private String[] getExpectedResultsWithNulls() {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000.0,true,engineering,\\N,1", "2,Bob,2009-04-20,400.0,true,sales,\\N,2", "3,Fred,2009-01-23,15.0,false,marketing,\\N,3"};
        return expectedResults;
    }

    private String[] getDirectModeExpectedResultsWithNulls() {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000,T,engineering,\\N,1", "2,Bob,2009-04-20,400,T,sales,\\N,2", "3,Fred,2009-01-23,15,F,marketing,\\N,3"};
        return expectedResults;
    }

    private String[] getArgv(boolean isDirect, String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(NetezzaTestUtils.getNZConnectString());
        args.add("--username");
        args.add(NetezzaTestUtils.getNZUser());
        args.add("--password");
        args.add(NetezzaTestUtils.getNZPassword());
        args.add("--num-mappers");
        args.add("1");
        if (isDirect) {
            args.add("--direct");
        }
        for (String arg : extraArgs) {
            args.add(arg);
        }
        return args.toArray(new String[args.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNetezzaTest(boolean isDirect, String tableName, String[] expectedResults, String ... extraArgs) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, tableName);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(isDirect, tableName, extraArgs);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            NetezzaImportManualTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        NetezzaImportManualTest.assertTrue((String)("Could not find imported data file : " + f), (boolean)f.exists());
        BufferedReader r = null;
        try {
            int i;
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            Object[] s = new String[3];
            for (i = 0; i < s.length; ++i) {
                s[i] = r.readLine();
                LOG.info((Object)("Line read from file = " + (String)s[i]));
            }
            Arrays.sort(s);
            for (i = 0; i < expectedResults.length; ++i) {
                NetezzaImportManualTest.assertEquals((String)expectedResults[i], (String)s[i]);
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                NetezzaImportManualTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    @Test
    public void testNetezzaImport() throws IOException {
        this.runNetezzaTest(false, this.getTableName(), this.getExpectedResults(), new String[0]);
    }

    @Test
    public void testDirectImport() throws IOException {
        this.runNetezzaTest(true, this.getTableName(), this.getDirectModeExpectedResults(), new String[0]);
    }

    @Test
    public void testListTables() throws IOException {
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        NetezzaManager mgr = new NetezzaManager(options);
        Object[] tables = mgr.listTables();
        Arrays.sort(tables);
        NetezzaImportManualTest.assertTrue((String)(this.getTableName() + " is not found!"), (Arrays.binarySearch(tables, this.getTableName()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIncrementalImport() throws IOException {
        String[] expectedResults = new String[]{};
        String[] extraArgs = new String[]{"--incremental", "lastmodified", "--check-column", "START_DATE"};
        this.runNetezzaTest(false, this.getTableName(), expectedResults, extraArgs);
    }

    @Test
    public void testNullStringValue() throws Exception {
        String[] extraArgs = new String[]{"--null-string", "\\\\N", "--null-non-string", "\\\\N"};
        String[] expectedResultsWithNulls = this.getExpectedResultsWithNulls();
        String tableNameWithNull = this.getTableName() + "_W_N";
        this.runNetezzaTest(false, tableNameWithNull, expectedResultsWithNulls, extraArgs);
    }

    @Test
    public void testValidExtraArgs() throws Exception {
        String[] extraArgs = new String[]{"--", "--log-dir", "/tmp", "--max-errors", "2"};
        String[] expectedResults = this.getDirectModeExpectedResults();
        String tableName = this.getTableName();
        this.runNetezzaTest(true, tableName, expectedResults, extraArgs);
    }
}

