/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import java.io.IOException;
import org.apache.sqoop.accumulo.AccumuloTestCase;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.junit.Test;

public class TestAccumuloImport
extends AccumuloTestCase {
    @Test
    public void testBasicUsage() throws IOException {
        String[] argv = this.getArgv("BasicUsage", "BasicColFam", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyAccumuloCell("BasicUsage", "0", "BasicColFam", this.getColName(1), "1");
    }

    @Test
    public void testMissingTableFails() throws IOException {
        String[] argv = this.getArgv("MissingTable", "MissingFam", false, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        try {
            this.runImport(argv);
            TestAccumuloImport.fail((String)"Expected Exception");
        }
        catch (IOException e) {
            LOG.info((Object)"Got exception -- ok; we expected that job to fail.");
        }
    }

    @Test
    public void testOverwriteSucceeds() throws IOException {
        String[] argv = this.getArgv("OverwriteT", "OverwriteF", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyAccumuloCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
        this.runImport(argv);
        this.verifyAccumuloCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
    }

    @Test
    public void testStrings() throws IOException {
        String[] argv = this.getArgv("stringT", "stringF", true, null);
        String[] types = new String[]{"INT", "VARCHAR(32)"};
        String[] vals = new String[]{"0", "'abc'"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyAccumuloCell("stringT", "0", "stringF", this.getColName(1), "abc");
    }

    @Test
    public void testNulls() throws IOException {
        String[] argv = this.getArgv("nullT", "nullF", true, null);
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "null"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyAccumuloCell("nullT", "0", "nullF", this.getColName(1), "42");
        this.verifyAccumuloCell("nullT", "0", "nullF", this.getColName(2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitFailure() throws IOException {
        String[] argv = this.getArgv("NoAccumuloT", "NoAccumuloF", true, null);
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        try {
            AccumuloUtil.setAlwaysNoAccumuloJarMode((boolean)true);
            this.runImport(argv);
            TestAccumuloImport.fail((String)"should have gotten exception");
        }
        catch (IOException e) {
            LOG.info((Object)"Got exception -- ok; we expected that to fail.");
        }
        finally {
            AccumuloUtil.setAlwaysNoAccumuloJarMode((boolean)false);
        }
    }
}

