/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestBigDecimalExport
extends ExportJobTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBigDecimalExport(String line) throws IOException, SQLException {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path tablePath = this.getTablePath();
        fs.mkdirs(tablePath);
        Path filePath = this.getDataFilePath();
        FSDataOutputStream stream = fs.create(filePath);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream));
        writer.write(line);
        writer.close();
        String[] types = new String[]{"DECIMAL", "NUMERIC"};
        this.createTableWithColTypes(types, null);
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(this.getTableName());
        args.add("--export-dir");
        args.add(tablePath.toString());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("-m");
        args.add("1");
        this.runExport(args.toArray(new String[args.size()]));
        BigDecimal actual1 = null;
        BigDecimal actual2 = null;
        Connection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + this.getTableName());
            try {
                ResultSet rs = stmt.executeQuery();
                try {
                    rs.next();
                    actual1 = rs.getBigDecimal(1);
                    actual2 = rs.getBigDecimal(2);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
        BigDecimal expected1 = new BigDecimal("0.000001");
        BigDecimal expected2 = new BigDecimal("0.0000001");
        TestBigDecimalExport.assertEquals((Object)expected1, (Object)actual1);
        TestBigDecimalExport.assertEquals((Object)expected2, (Object)actual2);
    }

    public void testBigDecimalDefault() throws IOException, SQLException {
        this.runBigDecimalExport("0.000001,0.0000001");
    }

    public void testBigDecimalNoFormat() throws IOException, SQLException {
        this.runBigDecimalExport("0.000001,1E-7");
    }
}

