/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.lib.BlobRef;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class LobAvroImportTestCase
extends ImportJobTestCase {
    private Log log = LogFactory.getLog((String)LobAvroImportTestCase.class.getName());

    protected abstract Log getLogger();

    protected abstract String getDbFriendlyName();

    @Override
    protected String getTablePrefix() {
        return "LOB_" + this.getDbFriendlyName().toUpperCase() + "_";
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    public void tearDown() {
        try {
            this.dropTableIfExists(this.getTableName());
        }
        catch (SQLException e) {
            this.log.warn((Object)("Error trying to drop table '" + this.getTableName() + "' on tearDown: " + e));
        }
        super.tearDown();
    }

    protected String[] getArgv(String ... additionalArgs) {
        String[] colNames = this.getColNames();
        String splitByCol = colNames[0];
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(this.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-avrodatafile");
        args.add("--num-mappers");
        args.add("2");
        for (String arg : additionalArgs) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    protected String getBlobType() {
        return "BLOB";
    }

    protected String getBlobInsertStr(String blobData) {
        return "'" + blobData + "'";
    }

    private String getTableNum() {
        return this.getTableName().substring(this.getTablePrefix().length());
    }

    private DataFileReader<GenericRecord> read(Path filename) throws IOException {
        Configuration conf = this.getConf();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FsInput fsInput = new FsInput(filename, conf);
        GenericDatumReader datumReader = new GenericDatumReader();
        return new DataFileReader((SeekableInput)fsInput, (DatumReader)datumReader);
    }

    public void testBlobAvroImportInline() throws IOException, SQLException {
        String[] types = new String[]{this.getBlobType()};
        String expectedVal = "This is short BLOB data";
        String[] vals = new String[]{this.getBlobInsertStr(expectedVal)};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getArgv(new String[0]));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record = (GenericRecord)reader.next();
        ByteBuffer buf = (ByteBuffer)record.get(this.getColName(0));
        String returnVal = new String(buf.array());
        LobAvroImportTestCase.assertEquals((String)this.getColName(0), (String)expectedVal, (String)returnVal);
    }

    public void testBlobAvroImportExternal() throws IOException, SQLException {
        String[] types = new String[]{this.getBlobType()};
        String data = "This is short BLOB data";
        String[] vals = new String[]{this.getBlobInsertStr(data)};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getArgv("--inline-lob-limit", "1"));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record = (GenericRecord)reader.next();
        ByteBuffer buf = (ByteBuffer)record.get(this.getColName(0));
        String returnVal = new String(buf.array());
        String expectedStart = "externalLob(lf,_lob/large_obj";
        String expectedEnd = this.getTableNum() + "_m_0000000.lob,68," + data.length() + ")";
        LobAvroImportTestCase.assertTrue((boolean)returnVal.startsWith(expectedStart));
        LobAvroImportTestCase.assertTrue((boolean)returnVal.endsWith(expectedEnd));
        com.cloudera.sqoop.lib.BlobRef br = BlobRef.parse((String)returnVal);
        Path lobFileDir = new Path(this.getWarehouseDir(), this.getTableName());
        InputStream in = (InputStream)br.getDataStream(this.getConf(), lobFileDir);
        byte[] bufArray = new byte[data.length()];
        int chars = in.read(bufArray);
        in.close();
        LobAvroImportTestCase.assertEquals((int)chars, (int)data.length());
        returnVal = new String(bufArray);
        String expectedVal = data;
        LobAvroImportTestCase.assertEquals((String)this.getColName(0), (String)returnVal, (String)expectedVal);
    }

    public void testBlobCompressedAvroImportInline() throws IOException, SQLException {
        String[] types = new String[]{this.getBlobType()};
        String expectedVal = "This is short BLOB data";
        String[] vals = new String[]{this.getBlobInsertStr(expectedVal)};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getArgv("--compression-codec", "deflate"));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record = (GenericRecord)reader.next();
        LobAvroImportTestCase.assertEquals((String)"deflate", (String)reader.getMetaString("avro.codec"));
        ByteBuffer buf = (ByteBuffer)record.get(this.getColName(0));
        String returnVal = new String(buf.array());
        LobAvroImportTestCase.assertEquals((String)this.getColName(0), (String)expectedVal, (String)returnVal);
    }

    public void testBlobCompressedAvroImportExternal() throws IOException, SQLException {
        String[] types = new String[]{this.getBlobType()};
        String data = "This is short BLOB data";
        String[] vals = new String[]{this.getBlobInsertStr(data)};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getArgv("--inline-lob-limit", "1", "--compression-codec", "deflate"));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record = (GenericRecord)reader.next();
        LobAvroImportTestCase.assertEquals((String)"deflate", (String)reader.getMetaString("avro.codec"));
        ByteBuffer buf = (ByteBuffer)record.get(this.getColName(0));
        String returnVal = new String(buf.array());
        String expectedStart = "externalLob(lf,_lob/large_obj";
        String expectedEnd = this.getTableNum() + "_m_0000000.lob,68," + data.length() + ")";
        LobAvroImportTestCase.assertTrue((boolean)returnVal.startsWith(expectedStart));
        LobAvroImportTestCase.assertTrue((boolean)returnVal.endsWith(expectedEnd));
        com.cloudera.sqoop.lib.BlobRef br = BlobRef.parse((String)returnVal);
        Path lobFileDir = new Path(this.getWarehouseDir(), this.getTableName());
        InputStream in = (InputStream)br.getDataStream(this.getConf(), lobFileDir);
        byte[] bufArray = new byte[data.length()];
        int chars = in.read(bufArray);
        in.close();
        LobAvroImportTestCase.assertEquals((int)chars, (int)data.length());
        returnVal = new String(bufArray);
        String expectedVal = data;
        LobAvroImportTestCase.assertEquals((String)this.getColName(0), (String)returnVal, (String)expectedVal);
    }

    public void testBlobAvroImportMultiCols() throws IOException, SQLException {
        String[] types = new String[]{this.getBlobType(), this.getBlobType(), this.getBlobType()};
        String expectedVal1 = "This is short BLOB data1";
        String expectedVal2 = "This is short BLOB data2";
        String expectedVal3 = "This is short BLOB data3";
        String[] vals = new String[]{this.getBlobInsertStr(expectedVal1), this.getBlobInsertStr(expectedVal2), this.getBlobInsertStr(expectedVal3)};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getArgv(new String[0]));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record = (GenericRecord)reader.next();
        ByteBuffer buf = (ByteBuffer)record.get(this.getColName(0));
        String returnVal = new String(buf.array());
        LobAvroImportTestCase.assertEquals((String)this.getColName(0), (String)expectedVal1, (String)returnVal);
        buf = (ByteBuffer)record.get(this.getColName(1));
        returnVal = new String(buf.array());
        LobAvroImportTestCase.assertEquals((String)this.getColName(1), (String)expectedVal2, (String)returnVal);
        buf = (ByteBuffer)record.get(this.getColName(2));
        returnVal = new String(buf.array());
        LobAvroImportTestCase.assertEquals((String)this.getColName(2), (String)expectedVal3, (String)returnVal);
    }

    public void testClobAvroImportInline() throws IOException, SQLException {
    }

    public void testClobAvroImportExternal() throws IOException, SQLException {
    }

    public void testClobCompressedAvroImportInline() throws IOException, SQLException {
    }

    public void testClobCompressedAvroImportExternal() throws IOException, SQLException {
    }

    public void testClobAvroImportMultiCols() throws IOException, SQLException {
    }
}

