/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.tool.ExportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.junit.Before;

public abstract class ExportJobTestCase
extends BaseSqoopTestCase {
    public static final Log LOG = LogFactory.getLog((String)ExportJobTestCase.class.getName());

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (this.useHsqldbTestServer()) {
            try {
                this.getTestServer().dropExistingSchema();
            }
            catch (SQLException sqlE) {
                ExportJobTestCase.fail((String)sqlE.toString());
            }
        }
    }

    @Override
    protected String getTablePrefix() {
        return "EXPORT_TABLE_";
    }

    protected int getMaxRowsPerStatement() {
        return 1;
    }

    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStmt, int statementsPerTx, String ... additionalArgv) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
            args.add("-D");
            int realRowsPerStmt = Math.min(rowsPerStmt, this.getMaxRowsPerStatement());
            if (realRowsPerStmt != rowsPerStmt) {
                LOG.warn((Object)("Rows per statement set to " + realRowsPerStmt + " by getMaxRowsPerStatement() limit."));
            }
            args.add("sqoop.export.records.per.statement=" + realRowsPerStmt);
            args.add("-D");
            args.add("sqoop.export.statements.per.transaction=" + statementsPerTx);
        }
        if (null != additionalArgv) {
            boolean prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    args.add(arg);
                    prevIsFlag = true;
                    continue;
                }
                if (!prevIsFlag) continue;
                args.add(arg);
                prevIsFlag = false;
            }
        }
        boolean isHCatJob = false;
        if (null != additionalArgv) {
            boolean prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    prevIsFlag = true;
                    continue;
                }
                if (prevIsFlag) {
                    prevIsFlag = false;
                    continue;
                }
                if (!isHCatJob && arg.equals("--hcatalog-table")) {
                    isHCatJob = true;
                }
                args.add(arg);
            }
        }
        if (this.usesSQLtable()) {
            args.add("--table");
            args.add(this.getTableName());
        }
        if (!isHCatJob) {
            args.add("--export-dir");
            args.add(this.getTablePath().toString());
        }
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--fields-terminated-by");
        args.add("\\t");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("-m");
        args.add("1");
        LOG.debug((Object)"args:");
        for (String a : args) {
            LOG.debug((Object)("  " + a));
        }
        return args.toArray(new String[0]);
    }

    protected boolean usesSQLtable() {
        return true;
    }

    protected String getMsgPrefix() {
        return "textfield";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMinRowId(Connection conn) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("SELECT MIN(id) FROM " + this.getTableName(), 1003, 1007);
        int minVal = 0;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                minVal = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        return minVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxRowId(Connection conn) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("SELECT MAX(id) FROM " + this.getTableName(), 1003, 1007);
        int maxVal = 0;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                maxVal = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        return maxVal;
    }

    protected void verifyExport(int expectedNumRecords) throws IOException, SQLException {
        Connection conn = this.getConnection();
        this.verifyExport(expectedNumRecords, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyExport(int expectedNumRecords, Connection conn) throws IOException, SQLException {
        LOG.info((Object)("Verifying export: " + this.getTableName()));
        PreparedStatement statement = conn.prepareStatement("SELECT COUNT(*) FROM " + this.getTableName(), 1003, 1007);
        int actualNumRecords = 0;
        ResultSet rs = null;
        try {
            rs = statement.executeQuery();
            try {
                rs.next();
                actualNumRecords = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        ExportJobTestCase.assertEquals((String)"Got back unexpected row count", (int)expectedNumRecords, (int)actualNumRecords);
        if (expectedNumRecords == 0) {
            return;
        }
        int minVal = this.getMinRowId(conn);
        ExportJobTestCase.assertEquals((String)"Minimum row was not zero", (int)0, (int)minVal);
        int maxVal = this.getMaxRowId(conn);
        ExportJobTestCase.assertEquals((String)"Maximum row had invalid id", (int)(expectedNumRecords - 1), (int)maxVal);
        statement = conn.prepareStatement("SELECT msg FROM " + this.getTableName() + " WHERE id = " + minVal, 1003, 1007);
        String minMsg = "";
        try {
            rs = statement.executeQuery();
            try {
                rs.next();
                minMsg = rs.getString(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        ExportJobTestCase.assertEquals((String)"Invalid msg field for min value", (String)(this.getMsgPrefix() + minVal), (String)minMsg);
        statement = conn.prepareStatement("SELECT msg FROM " + this.getTableName() + " WHERE id = " + maxVal, 1003, 1007);
        String maxMsg = "";
        try {
            rs = statement.executeQuery();
            try {
                rs.next();
                maxMsg = rs.getString(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        ExportJobTestCase.assertEquals((String)"Invalid msg field for min value", (String)(this.getMsgPrefix() + maxVal), (String)maxMsg);
    }

    protected List<String> runExport(String[] argv) throws IOException {
        int ret;
        List generatedJars = null;
        try {
            ExportTool exporter = new ExportTool();
            Configuration conf = this.getConf();
            conf.set("oraoop.disabled", "true");
            SqoopOptions opts = this.getSqoopOptions(conf);
            Sqoop sqoop = new Sqoop((SqoopTool)exporter, conf, opts);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
            generatedJars = exporter.getGeneratedJarFiles();
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + StringUtils.stringifyException((Throwable)e)));
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Failure during job; return status " + ret);
        }
        return generatedJars;
    }
}

