/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.testutil.DirUtil;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.junit.After;
import org.junit.Before;

public abstract class BaseSqoopTestCase
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)BaseSqoopTestCase.class.getName());
    private static boolean onPhysicalCluster = false;
    public static final String TEMP_BASE_DIR;
    public static final String LOCAL_WAREHOUSE_DIR;
    private String curTableName;
    private static int tableNum;
    private String[] colNames;
    private HsqldbTestServer testServer;
    private ConnManager manager;
    private static boolean isLog4jConfigured;
    public static final String BASE_COL_NAME = "DATA_COL";

    public static boolean isOnPhysicalCluster() {
        return onPhysicalCluster;
    }

    private static void setOnPhysicalCluster(boolean value) {
        onPhysicalCluster = value;
    }

    protected void setCurTableName(String curName) {
        this.curTableName = curName;
    }

    protected String getTablePrefix() {
        return "SQOOP_TABLE_";
    }

    protected String getTableName() {
        if (null != this.curTableName) {
            return this.curTableName;
        }
        return this.getTablePrefix() + Integer.toString(tableNum);
    }

    protected String getWarehouseDir() {
        return LOCAL_WAREHOUSE_DIR;
    }

    protected String[] getColNames() {
        return this.colNames;
    }

    protected void setColNames(String[] cols) {
        this.colNames = null == cols ? null : Arrays.copyOf(cols, cols.length);
    }

    protected HsqldbTestServer getTestServer() {
        return this.testServer;
    }

    protected ConnManager getManager() {
        return this.manager;
    }

    protected Connection getConnection() {
        try {
            return this.getTestServer().getConnection();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Could not get connection to test server: " + sqlE));
            return null;
        }
    }

    protected void incrementTableNum() {
        ++tableNum;
    }

    protected boolean useHsqldbTestServer() {
        return true;
    }

    protected String getConnectString() {
        return HsqldbTestServer.getUrl();
    }

    protected Configuration getConf() {
        return new Configuration();
    }

    protected SqoopOptions getSqoopOptions(Configuration conf) {
        return new SqoopOptions(conf);
    }

    @Before
    public void setUp() {
        BaseSqoopTestCase.setOnPhysicalCluster(!"file:///".equals(System.getProperty("fs.defaultfs.name")));
        this.incrementTableNum();
        if (!isLog4jConfigured) {
            BasicConfigurator.configure();
            isLog4jConfigured = true;
            LOG.info((Object)"Configured log4j with console appender.");
        }
        if (this.useHsqldbTestServer()) {
            this.testServer = new HsqldbTestServer();
            try {
                this.testServer.resetServer();
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException: " + StringUtils.stringifyException((Throwable)sqlE)));
                BaseSqoopTestCase.fail((String)("Got SQLException: " + StringUtils.stringifyException((Throwable)sqlE)));
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)("Could not find class for db driver: " + StringUtils.stringifyException((Throwable)cnfe)));
                BaseSqoopTestCase.fail((String)("Could not find class for db driver: " + StringUtils.stringifyException((Throwable)cnfe)));
            }
            this.manager = this.testServer.getManager();
        } else {
            Configuration conf = this.getConf();
            conf.set("oraoop.disabled", "true");
            SqoopOptions opts = this.getSqoopOptions(conf);
            opts.setConnectString(this.getConnectString());
            opts.setTableName(this.getTableName());
            ConnFactory f = new ConnFactory(conf);
            try {
                this.manager = f.getManager(new JobData(opts, (SqoopTool)new ImportTool()));
            }
            catch (IOException ioe) {
                BaseSqoopTestCase.fail((String)("IOException instantiating manager: " + StringUtils.stringifyException((Throwable)ioe)));
            }
        }
    }

    private void guaranteeCleanWarehouse() {
        File s;
        if (BaseSqoopTestCase.isOnPhysicalCluster()) {
            Path warehousePath = new Path(this.getWarehouseDir());
            try {
                FileSystem fs = FileSystem.get((Configuration)this.getConf());
                fs.delete(warehousePath, true);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
            }
        }
        if (!(s = new File(this.getWarehouseDir())).delete()) {
            LOG.warn((Object)("Can't delete " + s.getPath()));
        }
    }

    @After
    public void tearDown() {
        this.setCurTableName(null);
        try {
            if (null != this.manager) {
                this.manager.close();
                this.manager = null;
            }
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + StringUtils.stringifyException((Throwable)sqlE)));
            BaseSqoopTestCase.fail((String)("Got SQLException: " + StringUtils.stringifyException((Throwable)sqlE)));
        }
        this.guaranteeCleanWarehouse();
    }

    protected String getColName(int i) {
        return BASE_COL_NAME + i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("DROP TABLE " + table + " IF EXISTS", 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTableWithColTypesAndNames(String[] colNames, String[] colTypes, String[] vals) {
        assert (colNames != null);
        assert (colTypes != null);
        assert (colNames.length == colTypes.length);
        Connection conn = null;
        Statement statement = null;
        String createTableStr = null;
        String columnDefStr = "";
        try {
            try {
                this.dropTableIfExists(this.getTableName());
                conn = this.getManager().getConnection();
                for (int i = 0; i < colTypes.length; ++i) {
                    columnDefStr = columnDefStr + colNames[i] + " " + colTypes[i];
                    if (i >= colTypes.length - 1) continue;
                    columnDefStr = columnDefStr + ", ";
                }
                createTableStr = "CREATE TABLE " + this.getTableName() + "(" + columnDefStr + ")";
                LOG.info((Object)("Creating table: " + createTableStr));
                statement = conn.prepareStatement(createTableStr, 1003, 1007);
                statement.executeUpdate();
            }
            catch (SQLException sqlException) {
                BaseSqoopTestCase.fail((String)("Could not create table: " + StringUtils.stringifyException((Throwable)sqlException)));
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException se) {}
                    statement = null;
                }
            }
            for (int count = 0; vals != null && count < vals.length / colTypes.length; ++count) {
                String columnListStr = "";
                String valueListStr = "";
                for (int i = 0; i < colTypes.length; ++i) {
                    columnListStr = columnListStr + colNames[i];
                    valueListStr = valueListStr + vals[count * colTypes.length + i];
                    if (i >= colTypes.length - 1) continue;
                    columnListStr = columnListStr + ", ";
                    valueListStr = valueListStr + ", ";
                }
                try {
                    String insertValsStr = "INSERT INTO " + this.getTableName() + "(" + columnListStr + ")" + " VALUES(" + valueListStr + ")";
                    LOG.info((Object)("Inserting values: " + insertValsStr));
                    statement = conn.prepareStatement(insertValsStr, 1003, 1007);
                    statement.executeUpdate();
                    continue;
                }
                catch (SQLException sqlException) {
                    BaseSqoopTestCase.fail((String)("Could not create table: " + StringUtils.stringifyException((Throwable)sqlException)));
                    continue;
                }
                finally {
                    if (null != statement) {
                        try {
                            statement.close();
                        }
                        catch (SQLException se) {}
                        statement = null;
                    }
                }
            }
            conn.commit();
            this.colNames = colNames;
        }
        catch (SQLException se) {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException connSE) {
                    // empty catch block
                }
            }
            BaseSqoopTestCase.fail((String)("Could not create table: " + StringUtils.stringifyException((Throwable)se)));
        }
    }

    protected void createTableWithColTypes(String[] colTypes, String[] vals) {
        String[] colNames = new String[colTypes.length];
        for (int i = 0; i < colTypes.length; ++i) {
            colNames[i] = BASE_COL_NAME + Integer.toString(i);
        }
        this.createTableWithColTypesAndNames(colNames, colTypes, vals);
    }

    protected void createTableForColType(String colType, String val) {
        String[] types = new String[]{colType};
        String[] vals = new String[]{val};
        this.createTableWithColTypes(types, vals);
    }

    protected Path getTablePath() {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, this.getTableName());
        return tablePath;
    }

    protected Path getDataFilePath() {
        return new Path(this.getTablePath(), "part-m-00000");
    }

    protected void removeTableDir() {
        File tableDirFile = new File(this.getTablePath().toString());
        if (tableDirFile.exists() && !DirUtil.deleteDir(tableDirFile)) {
            LOG.warn((Object)("Could not delete table directory: " + tableDirFile.getAbsolutePath()));
        }
    }

    protected String[] newStrArray(String[] entries, String ... moreEntries) {
        if (null == moreEntries) {
            return entries;
        }
        if (null == entries) {
            entries = new String[]{};
        }
        return (String[])ObjectArrays.concat((Object[])entries, (Object[])moreEntries, String.class);
    }

    static {
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separator;
        }
        TEMP_BASE_DIR = tmpDir;
        LOCAL_WAREHOUSE_DIR = TEMP_BASE_DIR + "sqoop/warehouse";
        tableNum = 0;
        isLog4jConfigured = false;
    }
}

