/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ExplicitSetMapper;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.ReparseMapper;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class TestParseMethods
extends ImportJobTestCase {
    private String[] getArgv(boolean includeHadoopFlags, String fieldTerminator, String lineTerminator, String encloser, String escape, boolean encloserRequired) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--as-textfile");
        args.add("--split-by");
        args.add("DATA_COL0");
        args.add("--fields-terminated-by");
        args.add(fieldTerminator);
        args.add("--lines-terminated-by");
        args.add(lineTerminator);
        args.add("--escaped-by");
        args.add(escape);
        if (encloserRequired) {
            args.add("--enclosed-by");
        } else {
            args.add("--optionally-enclosed-by");
        }
        args.add(encloser);
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runParseTest(String fieldTerminator, String lineTerminator, String encloser, String escape, boolean encloseRequired) throws IOException {
        ClassLoader prevClassLoader = null;
        String[] argv = this.getArgv(true, fieldTerminator, lineTerminator, encloser, escape, encloseRequired);
        this.runImport(argv);
        try {
            String tableClassName = this.getTableName();
            argv = this.getArgv(false, fieldTerminator, lineTerminator, encloser, escape, encloseRequired);
            SqoopOptions opts = new ImportTool().parseArguments(argv, null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)tableClassName);
            JobConf job = new JobConf();
            job.setJar(jarFileName);
            job.set("sqoop.user.class", tableClassName);
            ConfigurationHelper.setJobtrackerAddr((Configuration)job, (String)"local");
            if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
                job.set("fs.defaultfs.name", "file:///");
            }
            String warehouseDir = this.getWarehouseDir();
            Path warehousePath = new Path(warehouseDir);
            Path inputPath = new Path(warehousePath, this.getTableName());
            Path outputPath = new Path(warehousePath, this.getTableName() + "-out");
            job.setMapperClass(ReparseMapper.class);
            job.setNumReduceTasks(0);
            FileInputFormat.addInputPath((JobConf)job, (Path)inputPath);
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);
            JobClient.runJob((JobConf)job);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestParseMethods.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            TestParseMethods.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testDefaults() throws IOException {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "INTEGER"};
        String[] vals = new String[]{"64", "'foo'", "128"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\\"", "\\", false);
    }

    public void testRequiredEnclose() throws IOException {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "INTEGER"};
        String[] vals = new String[]{"64", "'foo'", "128"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\\"", "\\", true);
    }

    public void testStringEscapes() throws IOException {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] vals = new String[]{"'foo'", "'foo,bar'", "'foo''bar'", "'foo\\bar'", "'foo,bar''baz'"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\'", "\\", false);
    }

    public void testNumericTypes() throws IOException {
        String[] types = new String[]{"INTEGER", "REAL", "FLOAT", "DATE", "TIME", "TIMESTAMP", "NUMERIC", "BOOLEAN"};
        String[] vals = new String[]{"42", "36.0", "127.1", "'2009-07-02'", "'11:24:00'", "'2009-08-13 20:32:00.1234567'", "92104916282869291837672829102857271948687.287475322", "true"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\'", "\\", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testFieldSetter() throws IOException {
        ClassLoader prevClassLoader = null;
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)"};
        String[] vals = new String[]{"'meep'", "'foo'"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, ",", "\\n", "\\'", "\\", false);
        this.runImport(argv);
        try {
            String tableClassName = this.getTableName();
            argv = this.getArgv(false, ",", "\\n", "\\'", "\\", false);
            SqoopOptions opts = new ImportTool().parseArguments(argv, null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)tableClassName);
            JobConf job = new JobConf();
            job.setJar(jarFileName);
            job.set("sqoop.user.class", tableClassName);
            job.set("sqoop.explicit.set.col", "DATA_COL0");
            job.set("sqoop.explicit.set.val", "this-is-a-test");
            ConfigurationHelper.setJobtrackerAddr((Configuration)job, (String)"local");
            if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
                job.set("fs.defaultfs.name", "file:///");
            }
            String warehouseDir = this.getWarehouseDir();
            Path warehousePath = new Path(warehouseDir);
            Path inputPath = new Path(warehousePath, this.getTableName());
            Path outputPath = new Path(warehousePath, this.getTableName() + "-out");
            job.setMapperClass(ExplicitSetMapper.class);
            job.setNumReduceTasks(0);
            FileInputFormat.addInputPath((JobConf)job, (Path)inputPath);
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);
            JobClient.runJob((JobConf)job);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestParseMethods.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            TestParseMethods.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }
}

