/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.SQLServerManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.sqoop.ConnFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SQLServerManagerImportManualTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)SQLServerManagerImportManualTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    static final String DATABASE_NAME = "SQOOPTEST";
    static final String DATABASE_USER = "SQOOPUSER";
    static final String DATABASE_PASSWORD = "PASSWORD";
    static final String SCHEMA_DBO = "dbo";
    static final String DBO_TABLE_NAME = "EMPLOYEES_MSSQL";
    static final String SCHEMA_SCH = "sch";
    static final String SCH_TABLE_NAME = "PRIVATE_TABLE";
    static final String CONNECT_STRING = HOST_URL + ";databaseName=" + "SQOOPTEST";
    static final String CONNECTOR_FACTORY = System.getProperty("sqoop.test.msserver.connector.factory", ConnFactory.DEFAULT_FACTORY_CLASS_NAMES);
    private SQLServerManager manager;
    private Configuration conf = new Configuration();

    @Override
    protected Configuration getConf() {
        return this.conf;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(CONNECT_STRING, DBO_TABLE_NAME);
        options.setUsername(DATABASE_USER);
        options.setPassword(DATABASE_PASSWORD);
        this.manager = new SQLServerManager(options);
        this.createTableAndPopulateData(SCHEMA_DBO, DBO_TABLE_NAME);
        this.createTableAndPopulateData(SCHEMA_SCH, SCH_TABLE_NAME);
        this.conf.setStrings("sqoop.connection.factories", new String[]{CONNECTOR_FACTORY});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableAndPopulateData(String schema, String table) {
        String fulltableName = this.manager.escapeObjectName(schema) + "." + this.manager.escapeObjectName(table);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.manager.getConnection();
            stmt = conn.createStatement();
            stmt.execute("CREATE SCHEMA " + schema);
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Can't create schema: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            conn = this.manager.getConnection();
            stmt = conn.createStatement();
            stmt.execute("DROP TABLE " + fulltableName);
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Table was not dropped: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            conn = this.manager.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + fulltableName + " (" + "id INT NOT NULL, " + "name VARCHAR(24) NOT NULL, " + "salary FLOAT, " + "dept VARCHAR(32), " + "PRIMARY KEY (id))");
            stmt.executeUpdate("INSERT INTO " + fulltableName + " VALUES(" + "1,'Aaron', " + "1000000.00,'engineering')");
            stmt.executeUpdate("INSERT INTO " + fulltableName + " VALUES(" + "2,'Bob', " + "400.00,'sales')");
            stmt.executeUpdate("INSERT INTO " + fulltableName + " VALUES(" + "3,'Fred', 15.00," + "'marketing')");
            conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Encountered SQL Exception: ", (Throwable)sqlE);
            sqlE.printStackTrace();
            SQLServerManagerImportManualTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing connection/stmt", (Throwable)ex);
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            SQLServerManagerImportManualTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testImportSimple() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
        this.doImportAndVerify(DBO_TABLE_NAME, expectedResults, new String[0]);
    }

    @Test
    public void testImportExplicitDefaultSchema() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
        String[] extraArgs = new String[]{"--schema", SCHEMA_DBO};
        this.doImportAndVerify(DBO_TABLE_NAME, expectedResults, extraArgs);
    }

    @Test
    public void testImportDifferentSchema() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
        String[] extraArgs = new String[]{"--schema", SCHEMA_SCH};
        this.doImportAndVerify(SCH_TABLE_NAME, expectedResults, extraArgs);
    }

    @Test
    public void testImportTableHints() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
        String[] extraArgs = new String[]{"--table-hints", "NOLOCK"};
        this.doImportAndVerify(DBO_TABLE_NAME, expectedResults, extraArgs);
    }

    @Test
    public void testImportTableHintsMultiple() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
        String[] extraArgs = new String[]{"--table-hints", "NOLOCK,NOWAIT"};
        this.doImportAndVerify(DBO_TABLE_NAME, expectedResults, extraArgs);
    }

    private String[] getArgv(String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(CONNECT_STRING);
        args.add("--username");
        args.add(DATABASE_USER);
        args.add("--password");
        args.add(DATABASE_PASSWORD);
        args.add("--num-mappers");
        args.add("1");
        if (extraArgs.length > 0) {
            args.add("--");
            for (String arg : extraArgs) {
                args.add(arg);
            }
        }
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportAndVerify(String tableName, String[] expectedResults, String ... extraArgs) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, tableName);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(tableName, extraArgs);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            SQLServerManagerImportManualTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        SQLServerManagerImportManualTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                SQLServerManagerImportManualTest.assertEquals((String)expectedLine, (String)r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                SQLServerManagerImportManualTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }
}

