/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public class PGBulkloadManagerManualTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)PGBulkloadManagerManualTest.class.getName());
    private DBConfiguration dbConf;
    static final String HOST_URL = System.getProperty("sqoop.test.postgresql.connectstring.host_url", "jdbc:postgresql://localhost/");
    static final String DATABASE = System.getProperty("sqoop.test.postgresql.database", "sqooptest");
    static final String TABLESPACE = System.getProperty("sqoop.test.postgresql.tablespace", "sqooptest");
    static final String USERNAME = System.getProperty("sqoop.test.postgresql.username", "sqooptest");
    static final String PG_BULKLOAD = System.getProperty("sqoop.test.postgresql.pg_bulkload", "pg_bulkload");
    static final String CONNECT_STRING = HOST_URL + DATABASE;

    public PGBulkloadManagerManualTest() {
        JobConf conf = new JobConf(this.getConf());
        DBConfiguration.configureDB((Configuration)conf, (String)"org.postgresql.Driver", (String)this.getConnectString(), (String)this.getUserName(), (String)null, (Integer)null);
        this.dbConf = new DBConfiguration((Configuration)conf);
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return CONNECT_STRING;
    }

    protected String getUserName() {
        return USERNAME;
    }

    @Override
    protected String getTablePrefix() {
        return super.getTablePrefix().toLowerCase();
    }

    @Override
    protected String getTableName() {
        return super.getTableName().toLowerCase();
    }

    @Override
    public String getStagingTableName() {
        return super.getStagingTableName().toLowerCase();
    }

    @Override
    protected Connection getConnection() {
        try {
            Connection conn = this.dbConf.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement("SET extra_float_digits TO 0");
            stmt.executeUpdate();
            conn.commit();
            return conn;
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Could not get connection to test server: " + sqlE));
            return null;
        }
        catch (ClassNotFoundException cnfE) {
            LOG.error((Object)("Could not find driver class: " + cnfE));
            return null;
        }
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(additionalArgv));
        args.add("-D");
        args.add("pgbulkload.bin=" + PG_BULKLOAD);
        args.add("--username");
        args.add(this.getUserName());
        args.add("--connection-manager");
        args.add("org.apache.sqoop.manager.PGBulkloadManager");
        args.add("--staging-table");
        args.add("dummy");
        args.add("--clear-staging-table");
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, args.toArray(new String[0]));
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        args.add("--username");
        args.add(this.getUserName());
        return super.getCodeGenArgv(args.toArray(new String[0]));
    }

    @Override
    public void testColumnsExport() throws IOException, SQLException {
    }

    public void testMultiReduceExport() throws IOException, SQLException {
        String[] genericargs = this.newStrArray(null, "-Dmapred.reduce.tasks=2");
        this.multiFileTestWithGenericArgs(2, 10, 2, genericargs, new String[0]);
    }

    public void testExportWithTablespace() throws IOException, SQLException {
        String[] genericargs = this.newStrArray(null, "-Dpgbulkload.staging.tablespace=" + TABLESPACE);
        this.multiFileTestWithGenericArgs(1, 10, 1, genericargs, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multiFileTestWithGenericArgs(int numFiles, int recordsPerMap, int numMaps, String[] genericargs, String ... argv) throws IOException, SQLException {
        int TOTAL_RECORDS = numFiles * recordsPerMap;
        try {
            LOG.info((Object)("Beginning test: numFiles=" + numFiles + "; recordsPerMap=" + recordsPerMap + "; numMaps=" + numMaps));
            LOG.info((Object)"  with genericargs: ");
            for (String arg : genericargs) {
                LOG.info((Object)("    " + arg));
            }
            for (int i = 0; i < numFiles; ++i) {
                this.createTextFile(i, recordsPerMap, false, new TestExport.ColumnGenerator[0]);
            }
            this.createTable(new TestExport.ColumnGenerator[0]);
            this.runExport(this.getArgv(true, 10, 10, this.newStrArray(this.newStrArray(genericargs, argv), "-m", "" + numMaps)));
            this.verifyExport(TOTAL_RECORDS);
        }
        finally {
            LOG.info((Object)"multi-reduce test complete");
        }
    }
}

