/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.RecordParser;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestRecordParser
extends TestCase {
    private void assertListsEqual(String msg, List<String> expected, List<String> actual) {
        int actualLen;
        if (expected == null && actual != null) {
            if (null == msg) {
                msg = "expected null list";
            }
            TestRecordParser.fail((String)msg);
        } else if (expected != null && actual == null) {
            if (null == msg) {
                msg = "expected non-null list";
            }
            TestRecordParser.fail((String)msg);
        } else if (expected == null && actual == null) {
            return;
        }
        assert (null != expected);
        assert (null != actual);
        int expectedLen = expected.size();
        if (expectedLen != (actualLen = actual.size())) {
            if (null == msg) {
                msg = "Expected list of length " + expectedLen + "; got " + actualLen;
            }
            TestRecordParser.fail((String)msg);
        }
        for (int i = 0; i < expectedLen; ++i) {
            String expectedElem = expected.get(i);
            String actualElem = actual.get(i);
            if (expectedElem == null) {
                if (actualElem == null) continue;
                if (null == msg) {
                    msg = "Expected null element at position " + i + "; got [" + actualElem + "]";
                }
                TestRecordParser.fail((String)msg);
                continue;
            }
            if (expectedElem.equals(actualElem)) continue;
            if (null == msg) {
                msg = "Expected [" + expectedElem + "] at position " + i + "; got [" + actualElem + "]";
            }
            TestRecordParser.fail((String)msg);
        }
    }

    private List<String> list(String[] items) {
        if (null == items) {
            return null;
        }
        ArrayList<String> asList = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            asList.add(items[i]);
        }
        return asList;
    }

    public void testEmptyLine() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)""));
    }

    public void testJustEOR() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\n"));
    }

    public void testOneField() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"the field"));
    }

    public void testOneField2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"the field\n"));
    }

    public void testQuotedField1() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the field\"\n"));
    }

    public void testQuotedField2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the field\""));
    }

    public void testQuotedField3() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the ,field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the ,field\""));
    }

    public void testQuotedField4() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the ,,field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the ,,field\""));
    }

    public void testQuotedField5() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the ,\nfield"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the ,\nfield\""));
    }

    public void testQuotedField6() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the \nfield"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the \nfield\""));
    }

    public void testQuotedField7() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the \n\nfield"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the \n\nfield\""));
    }

    public void testQuotedField8() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the \"field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"the \\\"field\""));
    }

    public void testUnquotedEscape1() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the ,field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"the \\,field"));
    }

    public void testUnquotedEscape2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"the \\field"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"the \\\\field"));
    }

    public void testTwoFields1() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"field1,field2"));
    }

    public void testTwoFields2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"field1,field2\n"));
    }

    public void testTwoFields3() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"field1\",field2\n"));
    }

    public void testTwoFields4() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"field1,\"field2\"\n"));
    }

    public void testTwoFields5() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"field1,\"field2\""));
    }

    public void testRequiredQuotes0() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"field1\",\"field2\"\n"));
    }

    public void testRequiredQuotes1() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        String[] strings = new String[]{"field1", "field2"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\"field1\",\"field2\""));
    }

    public void testRequiredQuotes2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        try {
            parser.parseRecord((CharSequence)"\"field1\",field2");
            TestRecordParser.fail((String)"Expected parse error for required quotes");
        }
        catch (RecordParser.ParseError parseError) {
            // empty catch block
        }
    }

    public void testRequiredQuotes3() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        try {
            parser.parseRecord((CharSequence)"field1,\"field2\"");
            TestRecordParser.fail((String)"Expected parse error for required quotes");
        }
        catch (RecordParser.ParseError parseError) {
            // empty catch block
        }
    }

    public void testRequiredQuotes4() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        try {
            parser.parseRecord((CharSequence)"field1,\"field2\"\n");
            TestRecordParser.fail((String)"Expected parse error for required quotes");
        }
        catch (RecordParser.ParseError parseError) {
            // empty catch block
        }
    }

    public void testNull() {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', true));
        CharSequence input = null;
        try {
            parser.parseRecord(input);
            TestRecordParser.fail((String)"Expected parse error for null string");
        }
        catch (RecordParser.ParseError parseError) {
            // empty catch block
        }
    }

    public void testEmptyFields1() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)","));
    }

    public void testEmptyFields2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)",\n"));
    }

    public void testEmptyFields3() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"", "", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)",,\n"));
    }

    public void testEmptyFields4() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"", "foo", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)",foo,\n"));
    }

    public void testEmptyFields5() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"", "foo", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)",foo,"));
    }

    public void testEmptyFields6() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"foo", ""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"foo,"));
    }

    public void testTrailingText() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"foo", "bar"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"foo,bar\nbaz"));
    }

    public void testTrailingText2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{""};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\nbaz"));
    }

    public void testLeadingEscape() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', '\n', '\"', '\\', false));
        String[] strings = new String[]{"\nbaz"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"\\\nbaz"));
    }

    public void testEofIsEor() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', ',', '\"', '\\', false));
        String[] strings = new String[]{"three", "different", "fields"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"three,different,fields"));
    }

    public void testEofIsEor2() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', ',', '\"', '\\', false));
        String[] strings = new String[]{"three", "different", "fields"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"three,\"different\",fields"));
    }

    public void testRepeatedParse() throws RecordParser.ParseError {
        RecordParser parser = new RecordParser(new DelimiterSet(',', ',', '\"', '\\', false));
        String[] strings = new String[]{"three", "different", "fields"};
        this.assertListsEqual(null, this.list(strings), parser.parseRecord((CharSequence)"three,\"different\",fields"));
        String[] strings2 = new String[]{"foo", "bar"};
        this.assertListsEqual(null, this.list(strings2), parser.parseRecord((CharSequence)"foo,\"bar\""));
    }
}

