/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.hbase.HBaseTestCase;
import com.cloudera.sqoop.hbase.HBaseUtil;
import java.io.IOException;
import org.junit.Test;

public class HBaseQueryImportTest
extends HBaseTestCase {
    @Test
    public void testImportFromQuery() throws IOException {
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "queryT", "queryF", true, "SELECT " + this.getColName(0) + ", " + this.getColName(1) + " FROM " + this.getTableName() + " WHERE $CONDITIONS");
        this.runImport(argv);
        this.verifyHBaseCell("queryT", "0", "queryF", this.getColName(1), "42");
        this.verifyHBaseCell("queryT", "0", "queryF", this.getColName(2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitFailure() throws IOException {
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "queryT", "queryF", true, "SELECT " + this.getColName(0) + ", " + this.getColName(1) + " FROM " + this.getTableName() + " WHERE $CONDITIONS");
        try {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)true);
            this.runImport(argv);
        }
        catch (Exception e) {
            return;
        }
        finally {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)false);
        }
        HBaseQueryImportTest.fail((String)"should have gotten exception");
    }
}

