/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hcat;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.sqoop.hcat.HCatalogTestUtils;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.junit.Before;

public class HCatalogImportTest
extends ImportJobTestCase {
    private static final Log LOG = LogFactory.getLog(HCatalogImportTest.class);
    private final HCatalogTestUtils utils = HCatalogTestUtils.instance();
    private List<String> extraTestArgs = null;
    private List<String> configParams = null;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        try {
            this.utils.initUtils();
            this.extraTestArgs = new ArrayList<String>();
            this.configParams = new ArrayList<String>();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing HCatTestUtilis", e);
        }
    }

    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> codeGenArgv = new ArrayList<String>();
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                codeGenArgv.add(arg);
            }
        }
        codeGenArgv.add("--table");
        codeGenArgv.add(this.getTableName());
        codeGenArgv.add("--connect");
        codeGenArgv.add(this.getConnectString());
        codeGenArgv.add("--hcatalog-table");
        codeGenArgv.add(this.getTableName());
        return codeGenArgv.toArray(new String[0]);
    }

    private void setExtraArgs(List<String> args) {
        this.extraTestArgs.clear();
        if (args != null && args.size() > 0) {
            this.extraTestArgs.addAll(args);
        }
    }

    private List<String> getConfigParams() {
        return this.configParams;
    }

    private void setConfigParams(List<String> params) {
        this.configParams.clear();
        if (params != null && params.size() > 0) {
            this.configParams.addAll(params);
        }
    }

    @Override
    protected List<String> getExtraArgs(Configuration conf) {
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        if (this.extraTestArgs != null && this.extraTestArgs.size() > 0) {
            addlArgsArray.addAll(this.extraTestArgs);
        }
        Map<String, String> addlArgsMap = this.utils.getAddlTestArgs();
        String[] argv = new String[]{};
        if (addlArgsMap.containsKey("-libjars")) {
            argv = new String[]{"-libjars", addlArgsMap.get("-libjars")};
        }
        addlArgsArray.add("-m");
        addlArgsArray.add("1");
        addlArgsArray.add("--hcatalog-table");
        addlArgsArray.add(this.getTableName());
        for (String k : addlArgsMap.keySet()) {
            if (k.equals("-libjars")) continue;
            addlArgsArray.add(k);
            addlArgsArray.add(addlArgsMap.get(k));
        }
        return addlArgsArray;
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, Configuration conf) {
        if (null == colNames) {
            colNames = this.getColNames();
        }
        String columnsString = "";
        String splitByCol = null;
        if (colNames != null) {
            splitByCol = colNames[0];
            for (String col : colNames) {
                columnsString = columnsString + col + ",";
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.addAll(this.getConfigParams());
        args.add("--table");
        args.add(this.getTableName());
        if (colNames != null) {
            args.add("--columns");
            args.add(columnsString);
            args.add("--split-by");
            args.add(splitByCol);
        }
        args.add("--hcatalog-table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(this.getConnectString());
        args.addAll(this.getExtraArgs(conf));
        return args.toArray(new String[0]);
    }

    private void validateHCatRecords(List<HCatRecord> recs, final HCatSchema schema, int expectedCount, HCatalogTestUtils.ColumnGenerator ... cols) throws IOException {
        if (recs.size() != expectedCount) {
            HCatalogImportTest.fail((String)("Expected records = " + expectedCount + ", actual = " + recs.size()));
            return;
        }
        schema.getFieldNames();
        Collections.sort(recs, new Comparator<HCatRecord>(){

            @Override
            public int compare(HCatRecord hr1, HCatRecord hr2) {
                try {
                    return hr1.getInteger("id", schema) - hr2.getInteger("id", schema);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception caught while sorting hcat records " + e));
                    return 0;
                }
            }
        });
        Object expectedVal = null;
        Object actualVal = null;
        for (int i = 0; i < recs.size(); ++i) {
            HCatRecord rec = recs.get(i);
            expectedVal = i;
            actualVal = rec.get("id", schema);
            LOG.info((Object)("Validating field: id (expected = " + expectedVal + ", actual = " + actualVal + ")"));
            HCatalogTestUtils.assertEquals(expectedVal, actualVal);
            expectedVal = "textfield" + i;
            actualVal = rec.get("msg", schema);
            LOG.info((Object)("Validating field: msg (expected = " + expectedVal + ", actual = " + actualVal + ")"));
            HCatalogTestUtils.assertEquals(rec.get("msg", schema), "textfield" + i);
            for (HCatalogTestUtils.ColumnGenerator col : cols) {
                String name = col.getName().toLowerCase();
                expectedVal = col.getHCatValue(i);
                actualVal = rec.get(name, schema);
                LOG.info((Object)("Validating field: " + name + " (expected = " + expectedVal + ", actual = " + actualVal + ")"));
                HCatalogTestUtils.assertEquals(expectedVal, actualVal);
            }
        }
    }

    @Override
    protected void runImport(SqoopTool tool, String[] argv) throws IOException {
        int ret;
        try {
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            Sqoop sqoop = new Sqoop(tool, conf, opts);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running import: " + e.toString()));
            e.printStackTrace();
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Import failure; return status " + ret);
        }
    }

    private void runHCatImport(List<String> addlArgsArray, int totalRecords, String table, HCatalogTestUtils.ColumnGenerator[] cols, String[] cNames) throws Exception {
        this.runHCatImport(addlArgsArray, totalRecords, table, cols, cNames, false);
    }

    private void runHCatImport(List<String> addlArgsArray, int totalRecords, String table, HCatalogTestUtils.ColumnGenerator[] cols, String[] cNames, boolean dontCreate) throws Exception {
        HCatalogTestUtils.CreateMode mode = HCatalogTestUtils.CreateMode.CREATE;
        if (dontCreate) {
            mode = HCatalogTestUtils.CreateMode.NO_CREATION;
        }
        HCatSchema tblSchema = this.utils.createHCatTable(mode, totalRecords, table, cols);
        this.utils.createSqlTable(this.getConnection(), false, totalRecords, table, cols);
        Map<String, String> addlArgsMap = this.utils.getAddlTestArgs();
        String[] argv = new String[]{};
        addlArgsArray.add("-m");
        addlArgsArray.add("1");
        addlArgsArray.add("--hcatalog-table");
        addlArgsArray.add(table);
        if (addlArgsMap.containsKey("-libjars")) {
            argv = new String[]{"-libjars", addlArgsMap.get("-libjars")};
        }
        for (String k : addlArgsMap.keySet()) {
            if (k.equals("-libjars")) continue;
            addlArgsArray.add(k);
            addlArgsArray.add(addlArgsMap.get(k));
        }
        String[] colNames = null;
        if (cNames != null) {
            colNames = cNames;
        } else {
            colNames = new String[2 + cols.length];
            colNames[0] = "ID";
            colNames[1] = "MSG";
            for (int i = 0; i < cols.length; ++i) {
                colNames[2 + i] = cols[i].getName().toUpperCase();
            }
        }
        Object[] importArgs = this.getArgv(true, colNames, new Configuration());
        LOG.debug((Object)("Import args = " + Arrays.toString(importArgs)));
        SqoopHCatUtilities.instance().setConfigured(false);
        this.runImport((SqoopTool)new ImportTool(), (String[])importArgs);
        List<HCatRecord> recs = this.utils.readHCatRecords(null, table, null);
        LOG.debug((Object)"HCat records ");
        LOG.debug((Object)this.utils.hCatRecordDump(recs, tblSchema));
        this.validateHCatRecords(recs, tblSchema, 10, cols);
    }

    public void testIntTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "boolean", 16, HCatFieldSchema.Type.BOOLEAN, Boolean.TRUE, Boolean.TRUE, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "tinyint", 4, HCatFieldSchema.Type.INT, 10, 10, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "smallint", 4, HCatFieldSchema.Type.INT, 100, 100, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "int", 4, HCatFieldSchema.Type.INT, 1000, 1000, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(4), "bigint", -5, HCatFieldSchema.Type.BIGINT, 10000L, 10000L, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testFloatTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "float", 6, HCatFieldSchema.Type.FLOAT, Float.valueOf(10.0f), Float.valueOf(10.0f), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "real", 6, HCatFieldSchema.Type.FLOAT, Float.valueOf(20.0f), Float.valueOf(20.0f), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "double", 8, HCatFieldSchema.Type.DOUBLE, 30.0, 30.0, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testNumberTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "numeric(18,2)", 2, HCatFieldSchema.Type.STRING, "1000", new BigDecimal("1000"), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "decimal(18,2)", 3, HCatFieldSchema.Type.STRING, "2000", new BigDecimal("2000"), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testDateTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "date", 91, HCatFieldSchema.Type.STRING, "2013-12-31", new Date(113, 11, 31), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "time", 92, HCatFieldSchema.Type.STRING, "10:11:12", new Time(10, 11, 12), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "timestamp", 93, HCatFieldSchema.Type.STRING, "2013-12-31 10:11:12.0", new Timestamp(113, 11, 31, 10, 11, 12, 0), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testDateTypesToBigInt() throws Exception {
        int TOTAL_RECORDS = 10;
        long offset = TimeZone.getDefault().getRawOffset();
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "date", 91, HCatFieldSchema.Type.BIGINT, 0L - offset, new Date(70, 0, 1), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "time", 92, HCatFieldSchema.Type.BIGINT, 36672000L - offset, new Time(10, 11, 12), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "timestamp", 93, HCatFieldSchema.Type.BIGINT, 36672000L - offset, new Timestamp(70, 0, 1, 10, 11, 12, 0), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--map-column-hive");
        addlArgsArray.add("COL0=bigint,COL1=bigint,COL2=bigint");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testStringTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "char(10)", 1, HCatFieldSchema.Type.STRING, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "longvarchar", -1, HCatFieldSchema.Type.STRING, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testBinaryTypes() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap(new byte[]{0, 1, 2});
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "binary(10)", -2, HCatFieldSchema.Type.BINARY, bb.array(), bb.array(), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "longvarbinary", -2, HCatFieldSchema.Type.BINARY, bb.array(), bb.array(), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testColumnProjection() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, null, null, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        ArrayList<String> cfgParams = new ArrayList<String>();
        cfgParams.add("-D");
        cfgParams.add("sqoop.hcat.debug.import.mapper=true");
        this.setConfigParams(cfgParams);
        String[] colNames = new String[]{"ID", "MSG"};
        this.runHCatImport(addlArgsArray, 10, table, cols, colNames);
    }

    public void testColumnProjectionMissingPartKeys() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, null, null, HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        ArrayList<String> cfgParams = new ArrayList<String>();
        cfgParams.add("-D");
        cfgParams.add("sqoop.hcat.debug.import.mapper=true");
        this.setConfigParams(cfgParams);
        String[] colNames = new String[]{"ID", "MSG"};
        try {
            this.runHCatImport(addlArgsArray, 10, table, cols, colNames);
            HCatalogImportTest.fail((String)"Column projection with missing dynamic partition keys must fail");
        }
        catch (Throwable t) {
            LOG.info((Object)("Job fails as expected : " + t));
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            LOG.info((Object)("Exception stack trace = " + sw));
        }
    }

    public void testStaticPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testDynamicPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testStaicAndDynamicPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testSequenceFile() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.setExtraArgs(addlArgsArray);
        this.utils.setStorageInfo("stored as\n\tsequencefile\n");
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testTextFile() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.setExtraArgs(addlArgsArray);
        this.utils.setStorageInfo("stored as\n\ttextfile\n");
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testTableCreation() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--create-hcatalog-table");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null, true);
    }

    public void testTableCreationWithPartition() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.STATIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col1");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("2");
        addlArgsArray.add("--create-hcatalog-table");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null, true);
    }

    public void testTableCreationWithStorageStanza() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.STATIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col1");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("2");
        addlArgsArray.add("--create-hcatalog-table");
        addlArgsArray.add("--hcatalog-storage-stanza");
        addlArgsArray.add("stored as\n\ttextfile\n");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null, true);
    }

    public void testHiveDropDelims() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "Test", "\u0001\n\rTest", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "Test2", "\u0001\r\nTest2", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-drop-import-delims");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testHiveDelimsReplacement() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "^^^Test", "\u0001\n\rTest", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "^^^Test2", "\u0001\r\nTest2", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-delims-replacement");
        addlArgsArray.add("^");
        this.setExtraArgs(addlArgsArray);
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testDynamicKeyInMiddle() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.setExtraArgs(addlArgsArray);
        this.utils.setStorageInfo("stored as\n\tsequencefile\n");
        this.runHCatImport(addlArgsArray, 10, table, cols, null);
    }

    public void testCreateTableWithPreExistingTable() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "1", "1", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--create-hcatalog-table");
        this.setExtraArgs(addlArgsArray);
        try {
            this.utils.createHCatTable(HCatalogTestUtils.CreateMode.CREATE, 10, table, cols);
            this.runHCatImport(addlArgsArray, 10, table, cols, null, true);
            HCatalogImportTest.fail((String)"HCatalog job with --create-hcatalog-table and pre-existing table should fail");
        }
        catch (Exception e) {
            LOG.debug((Object)"Caught expected exception while running  create-hcatalog-table with pre-existing table test", (Throwable)e);
        }
    }
}

