/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.util;

import com.cloudera.sqoop.util.OptionsFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Assert;

public class TestOptionsFileExpansion
extends TestCase {
    private static final String[] OPTIONS_FILE_TEXT1 = new String[]{"--foo", "-bar", "--", "--XYZ"};
    private static final String[] OPTIONS_FILE_TEXT1_OUTPUT = new String[]{"--foo", "-bar", "--", "--XYZ"};
    private static final String[] OPTIONS_FILE_TEXT2 = new String[]{"--archives", "tools.jar,archive.jar,test.jar,\\", "ldap.jar,sasl.jar", "--connect", "jdbc:jdbcspy:localhost:1521:test", "--username", "superman", "--password", "", "# Ironic password.", "# No one will ever guess.", "kryptonite"};
    private static final String[] OPTIONS_FILE_TEXT2_OUTPUT = new String[]{"--archives", "tools.jar,archive.jar,test.jar,ldap.jar,sasl.jar", "--connect", "jdbc:jdbcspy:localhost:1521:test", "--username", "superman", "--password", "kryptonite"};
    private static final String[] OPTIONS_FILE_TEXT3 = new String[]{"-", "\"     leading spaces\"", "'        leading and trailing spaces    '", "\"\"", "''"};
    private static final String[] OPTIONS_FILE_TEXT3_OUTPUT = new String[]{"-", "     leading spaces", "        leading and trailing spaces    ", "", ""};
    private static final String[] OPTIONS_FILE_TEXT4 = new String[]{"--abcd", "--efgh", "# foo", "# bar", "XYZ\\"};
    private static final String[] OPTIONS_FILE_TEXT5 = new String[]{"-abcd", "'", "--foo"};
    private static final String[] OPTIONS_FILE_TEXT6 = new String[]{"--abcd", "' the quick brown fox \\", "jumped over the lazy dog'", "--efgh"};

    public void testOptionsFiles() throws Exception {
        this.checkOptionsFile(OPTIONS_FILE_TEXT1, OPTIONS_FILE_TEXT1_OUTPUT);
        this.checkOptionsFile(OPTIONS_FILE_TEXT2, OPTIONS_FILE_TEXT2_OUTPUT);
        this.checkOptionsFile(OPTIONS_FILE_TEXT3, OPTIONS_FILE_TEXT3_OUTPUT);
    }

    public void testInvalidOptionsFile() {
        this.checkInvalidOptionsFile(OPTIONS_FILE_TEXT4);
        this.checkInvalidOptionsFile(OPTIONS_FILE_TEXT5);
    }

    public void testMultilineQuotedText() {
        try {
            this.checkOptionsFile(OPTIONS_FILE_TEXT6, new String[0]);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("Multiline quoted strings not supported"));
        }
    }

    private void checkInvalidOptionsFile(String[] fileContents) {
        try {
            this.checkOptionsFile(fileContents, new String[0]);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("Malformed option"));
        }
    }

    private void checkOptionsFile(String[] fileContent, String[] expectedOptions) throws Exception {
        String[] prefix0 = new String[]{};
        String[] suffix0 = new String[]{};
        this.checkOutput(prefix0, suffix0, fileContent, expectedOptions);
        String[] prefix1 = new String[]{"--nomnom"};
        String[] suffix1 = new String[]{};
        this.checkOutput(prefix1, suffix1, fileContent, expectedOptions);
        String[] prefix2 = new String[]{};
        String[] suffix2 = new String[]{"yIkes"};
        this.checkOutput(prefix2, suffix2, fileContent, expectedOptions);
        String[] prefix3 = new String[]{"foo", "bar"};
        String[] suffix3 = new String[]{"xyz", "abc"};
        this.checkOutput(prefix3, suffix3, fileContent, expectedOptions);
    }

    private void checkOutput(String[] prefix, String[] suffix, String[] fileContent, String[] expectedContent) throws Exception {
        String[] args = new String[prefix.length + 2 + suffix.length];
        for (int i = 0; i < prefix.length; ++i) {
            args[i] = prefix[i];
        }
        args[prefix.length] = "--options-file";
        args[prefix.length + 1] = this.createOptionsFile(fileContent);
        for (int j = 0; j < suffix.length; ++j) {
            args[j + 2 + prefix.length] = suffix[j];
        }
        String[] expandedArgs = OptionsFileUtil.expandArguments((String[])args);
        this.assertSame(prefix, expectedContent, suffix, expandedArgs);
    }

    private void assertSame(String[] prefix, String[] content, String[] suffix, String[] actual) {
        int i;
        Assert.assertTrue((prefix.length + content.length + suffix.length == actual.length ? 1 : 0) != 0);
        for (i = 0; i < prefix.length; ++i) {
            Assert.assertTrue((boolean)actual[i].equals(prefix[i]));
        }
        for (i = 0; i < content.length; ++i) {
            Assert.assertTrue((boolean)actual[i + prefix.length].equals(content[i]));
        }
        for (i = 0; i < suffix.length; ++i) {
            Assert.assertTrue((boolean)actual[i + prefix.length + content.length].equals(suffix[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createOptionsFile(String[] data) throws Exception {
        File file = File.createTempFile("options", ".opf");
        file.deleteOnExit();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            for (String datum : data) {
                writer.write(datum);
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
        return file.getAbsolutePath();
    }
}

