/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class ImportJobTestCase
extends BaseSqoopTestCase {
    public static final Log LOG = LogFactory.getLog((String)ImportJobTestCase.class.getName());

    @Override
    protected String getTablePrefix() {
        return "IMPORT_TABLE_";
    }

    protected List<String> getExtraArgs(Configuration conf) {
        return new ArrayList<String>();
    }

    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, Configuration conf) {
        if (null == colNames) {
            colNames = this.getColNames();
        }
        String splitByCol = colNames[0];
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-sequencefile");
        args.add("--num-mappers");
        args.add("2");
        args.addAll(this.getExtraArgs(conf));
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyImport(String expectedVal, String[] importCols) {
        int ret;
        Path tableDirPath = this.getTablePath();
        this.removeTableDir();
        Configuration conf = this.getConf();
        SqoopOptions opts = this.getSqoopOptions(conf);
        try {
            Sqoop importer = new Sqoop((SqoopTool)new ImportTool(), conf, opts);
            ret = Sqoop.runSqoop((Sqoop)importer, (String[])this.getArgv(true, importCols, conf));
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            throw new RuntimeException(e);
        }
        ImportJobTestCase.assertEquals((String)"Failure during job", (int)0, (int)ret);
        opts = this.getSqoopOptions(conf);
        try {
            ImportTool importTool = new ImportTool();
            opts = importTool.parseArguments(this.getArgv(false, importCols, conf), conf, opts, true);
        }
        catch (Exception e) {
            ImportJobTestCase.fail((String)e.toString());
        }
        CompilationManager compileMgr = new CompilationManager(opts);
        String jarFileName = compileMgr.getJarFilename();
        ClassLoader prevClassLoader = null;
        try {
            FileSystem fs;
            FileStatus[] stats;
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
                conf.set("fs.defaultfs.name", "file:///");
            }
            if ((stats = (fs = FileSystem.get((Configuration)conf)).listStatus(tableDirPath)) == null || stats.length == 0) {
                ImportJobTestCase.fail((String)("Error: no files in " + tableDirPath));
            }
            boolean foundRecord = false;
            for (FileStatus stat : stats) {
                if (!stat.getPath().getName().startsWith("part-") && !stat.getPath().getName().startsWith("data-")) continue;
                try {
                    Object readValue = SeqFileReader.getFirstValue(stat.getPath().toString());
                    LOG.info((Object)("Read back from sequencefile: " + readValue));
                    foundRecord = true;
                    if (null == expectedVal) {
                        ImportJobTestCase.assertEquals((String)"Error validating result from SeqFile", (String)"null\n", (String)readValue.toString());
                        continue;
                    }
                    ImportJobTestCase.assertEquals((String)"Error validating result from SeqFile", (String)(expectedVal + "\n"), (String)readValue.toString());
                }
                catch (EOFException eoe) {
                    // empty catch block
                }
            }
            if (!foundRecord) {
                ImportJobTestCase.fail((String)"Couldn't read any records from SequenceFiles");
            }
        }
        catch (IOException ioe) {
            ImportJobTestCase.fail((String)("IOException: " + ioe.toString()));
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
            }
        }
    }

    protected void runImport(SqoopTool tool, String[] argv) throws IOException {
        int ret;
        this.removeTableDir();
        try {
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            Sqoop sqoop = new Sqoop(tool, conf, opts);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            e.printStackTrace();
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Failure during job; return status " + ret);
        }
    }

    protected void runImport(String[] argv) throws IOException {
        this.runImport((SqoopTool)new ImportTool(), argv);
    }
}

