/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.HsqldbManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;

public class HsqldbTestServer {
    public static final Log LOG = LogFactory.getLog((String)HsqldbTestServer.class.getName());
    private static Server server;
    private static final String IN_MEM = "mem:";
    private static boolean inMemoryDB;
    private static final String DATABASE_NAME;
    private static final String DUMMY_TABLE_NAME = "TWOINTTABLE";
    private static final String[] TWO_INT_TABLE_FIELDS;
    private static final String EMPLOYEE_TABLE_NAME = "EMPLOYEES";
    private static final String DB_URL;
    private static final String DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private static final String HSQLDB_SCHEMA_NAME = "PUBLIC";

    public static String getServerHost() {
        String host = System.getProperty("hsql.server.host", IN_MEM);
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        return host;
    }

    public static String getSchemaName() {
        return HSQLDB_SCHEMA_NAME;
    }

    public static String[] getFieldNames() {
        return Arrays.copyOf(TWO_INT_TABLE_FIELDS, TWO_INT_TABLE_FIELDS.length);
    }

    public static String getUrl() {
        return DB_URL;
    }

    public static String getTableName() {
        return DUMMY_TABLE_NAME;
    }

    public static String getDatabaseName() {
        return DATABASE_NAME;
    }

    public void start() {
        if (null == server) {
            LOG.info((Object)("Starting new hsqldb server; database=" + DATABASE_NAME));
            String tmpDir = System.getProperty("test.build.data", "/tmp/");
            String dbLocation = tmpDir + "/sqoop/testdb.file";
            if (inMemoryDB) {
                dbLocation = IN_MEM;
            }
            server = new Server();
            server.setDatabaseName(0, DATABASE_NAME);
            server.putPropertiesFromString("database.0=" + dbLocation + ";no_system_exit=true");
            server.start();
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)"Could not get connection; driver class not found: org.hsqldb.jdbcDriver");
            return null;
        }
        Connection connection = DriverManager.getConnection(DB_URL);
        connection.setAutoCommit(false);
        return connection;
    }

    public static String getDbUrl() {
        return DB_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema() throws SQLException {
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.getConnection();
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE TWOINTTABLE IF EXISTS");
            st.executeUpdate("CREATE TABLE TWOINTTABLE(intField1 INT, intField2 INT)");
            connection.commit();
        }
        finally {
            if (null != st) {
                st.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
    }

    public static int getFirstColSum() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateData() throws SQLException {
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.getConnection();
            st = connection.createStatement();
            st.executeUpdate("INSERT INTO TWOINTTABLE VALUES(1, 8)");
            st.executeUpdate("INSERT INTO TWOINTTABLE VALUES(3, 6)");
            st.executeUpdate("INSERT INTO TWOINTTABLE VALUES(5, 4)");
            st.executeUpdate("INSERT INTO TWOINTTABLE VALUES(7, 2)");
            connection.commit();
        }
        finally {
            if (null != st) {
                st.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmployeeDemo() throws SQLException, ClassNotFoundException {
        Class.forName(DRIVER_CLASS);
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.getConnection();
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE EMPLOYEES IF EXISTS");
            st.executeUpdate("CREATE TABLE EMPLOYEES(emp_id INT NOT NULL PRIMARY KEY, name VARCHAR(64))");
            st.executeUpdate("INSERT INTO EMPLOYEES VALUES(1, 'Aaron')");
            st.executeUpdate("INSERT INTO EMPLOYEES VALUES(2, 'Joe')");
            st.executeUpdate("INSERT INTO EMPLOYEES VALUES(3, 'Jim')");
            st.executeUpdate("INSERT INTO EMPLOYEES VALUES(4, 'Lisa')");
            connection.commit();
        }
        finally {
            if (null != st) {
                st.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropExistingSchema() throws SQLException {
        ConnManager mgr = this.getManager();
        String[] tables = mgr.listTables();
        if (null != tables) {
            Connection conn = mgr.getConnection();
            for (String table : tables) {
                Statement s = conn.createStatement();
                try {
                    s.executeUpdate("DROP TABLE " + table);
                    conn.commit();
                }
                finally {
                    s.close();
                }
            }
        }
    }

    public void resetServer() throws ClassNotFoundException, SQLException {
        this.start();
        this.dropExistingSchema();
        this.createSchema();
        this.populateData();
    }

    public SqoopOptions getSqoopOptions() {
        return new SqoopOptions(HsqldbTestServer.getUrl(), HsqldbTestServer.getTableName());
    }

    public ConnManager getManager() {
        return new HsqldbManager(this.getSqoopOptions());
    }

    static {
        inMemoryDB = IN_MEM.equals(HsqldbTestServer.getServerHost());
        DATABASE_NAME = System.getProperty("hsql.database.name", "db1");
        TWO_INT_TABLE_FIELDS = new String[]{"INTFIELD1", "INTFIELD2"};
        DB_URL = "jdbc:hsqldb:" + HsqldbTestServer.getServerHost() + DATABASE_NAME;
    }
}

