/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestConnFactory;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.orm.ClassWriter;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.DirUtil;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestClassWriter
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestClassWriter.class.getName());
    private HsqldbTestServer testServer;
    private ConnManager manager;
    private SqoopOptions options;
    static final String CODE_GEN_DIR = ImportJobTestCase.TEMP_BASE_DIR + "sqoop/test/codegen";
    static final String JAR_GEN_DIR = ImportJobTestCase.TEMP_BASE_DIR + "sqoop/test/jargen";
    private static final String OVERRIDE_CLASS_NAME = "override";
    private static final String OVERRIDE_CLASS_AND_PACKAGE_NAME = "override.pkg.prefix.classname";
    private static final String OVERRIDE_PACKAGE_NAME = "special.userpackage.name";
    private static final String USERMAPPING_CLASS_AND_PACKAGE_NAME = "usermapping.pkg.prefix.classname";

    @Before
    public void setUp() {
        this.testServer = new HsqldbTestServer();
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
        try {
            this.testServer.resetServer();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestClassWriter.fail((String)("Got SQLException: " + sqlE.toString()));
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("Could not find class for db driver: " + cnfe.toString()));
            TestClassWriter.fail((String)("Could not find class for db driver: " + cnfe.toString()));
        }
        this.manager = this.testServer.getManager();
        this.options = this.testServer.getSqoopOptions();
        TestClassWriter.assertTrue((String)"Test generates code in non-tmp dir!", (boolean)CODE_GEN_DIR.startsWith(ImportJobTestCase.TEMP_BASE_DIR));
        TestClassWriter.assertTrue((String)"Test generates jars in non-tmp dir!", (boolean)JAR_GEN_DIR.startsWith(ImportJobTestCase.TEMP_BASE_DIR));
        File codeGenDirFile = new File(CODE_GEN_DIR);
        File classGenDirFile = new File(JAR_GEN_DIR);
        if (codeGenDirFile.exists()) {
            LOG.debug((Object)("Removing code gen dir: " + codeGenDirFile));
            if (!DirUtil.deleteDir(codeGenDirFile)) {
                LOG.warn((Object)("Could not delete " + codeGenDirFile + " prior to test"));
            }
        }
        if (classGenDirFile.exists()) {
            LOG.debug((Object)("Removing class gen dir: " + classGenDirFile));
            if (!DirUtil.deleteDir(classGenDirFile)) {
                LOG.warn((Object)("Could not delete " + classGenDirFile + " prior to test"));
            }
        }
    }

    @After
    public void tearDown() {
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestClassWriter.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    private File runGenerationTest(String[] argv, String classNameToCheck) {
        File codeGenDirFile = new File(CODE_GEN_DIR);
        File classGenDirFile = new File(JAR_GEN_DIR);
        try {
            this.options = new ImportTool().parseArguments(argv, null, this.options, true);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not parse options: " + e.toString()));
        }
        CompilationManager compileMgr = new CompilationManager(this.options);
        ClassWriter writer = new ClassWriter(this.options, this.manager, HsqldbTestServer.getTableName(), compileMgr);
        try {
            writer.generate();
            compileMgr.compile();
            compileMgr.jar();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException: " + ioe.toString()));
            TestClassWriter.fail((String)("Got IOException: " + ioe.toString()));
        }
        String classFileNameToCheck = classNameToCheck.replace('.', File.separatorChar);
        LOG.debug((Object)("Class file to check for: " + classFileNameToCheck));
        File tableFile = new File(codeGenDirFile, classFileNameToCheck + ".java");
        TestClassWriter.assertTrue((String)"Cannot find generated source file for table!", (boolean)tableFile.exists());
        LOG.debug((Object)("Found generated source: " + tableFile));
        File tableClassFile = new File(classGenDirFile, classFileNameToCheck + ".class");
        TestClassWriter.assertTrue((String)"Cannot find generated class file for table!", (boolean)tableClassFile.exists());
        LOG.debug((Object)("Found generated class: " + tableClassFile));
        File jarFile = new File(compileMgr.getJarFilename());
        TestClassWriter.assertTrue((String)"Cannot find compiled jar", (boolean)jarFile.exists());
        LOG.debug((Object)("Found generated jar: " + jarFile));
        boolean foundCompiledClass = false;
        if (Shell.WINDOWS) {
            classFileNameToCheck = classFileNameToCheck.replace(File.separator, "/");
        }
        try {
            JarEntry entry;
            JarInputStream jis = new JarInputStream(new FileInputStream(jarFile));
            LOG.debug((Object)"Jar file has entries:");
            while (null != (entry = jis.getNextJarEntry())) {
                if (entry.getName().equals(classFileNameToCheck + ".class")) {
                    foundCompiledClass = true;
                    LOG.debug((Object)(" * " + entry.getName()));
                    continue;
                }
                LOG.debug((Object)("   " + entry.getName()));
            }
            jis.close();
        }
        catch (IOException ioe) {
            TestClassWriter.fail((String)("Got IOException iterating over Jar file: " + ioe.toString()));
        }
        TestClassWriter.assertTrue((String)("Cannot find .class file " + classFileNameToCheck + ".class in jar file"), (boolean)foundCompiledClass);
        LOG.debug((Object)"Found class in jar - test success!");
        return jarFile;
    }

    @Test
    public void testCodeGen() {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR};
        this.runGenerationTest(argv, HsqldbTestServer.getTableName());
    }

    @Test
    public void testSetClassName() {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--class-name", OVERRIDE_CLASS_NAME};
        this.runGenerationTest(argv, OVERRIDE_CLASS_NAME);
    }

    @Test
    public void testSetClassAndPackageName() {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--class-name", OVERRIDE_CLASS_AND_PACKAGE_NAME};
        this.runGenerationTest(argv, OVERRIDE_CLASS_AND_PACKAGE_NAME);
    }

    @Test
    public void testSetPackageName() {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--package-name", OVERRIDE_PACKAGE_NAME};
        this.runGenerationTest(argv, "special.userpackage.name." + HsqldbTestServer.getTableName());
    }

    @Test
    public void testJavaIdentifierConversion() {
        TestClassWriter.assertNull((Object)ClassWriter.getIdentifierStrForChar((char)' '));
        TestClassWriter.assertNull((Object)ClassWriter.getIdentifierStrForChar((char)'\t'));
        TestClassWriter.assertNull((Object)ClassWriter.getIdentifierStrForChar((char)'\r'));
        TestClassWriter.assertNull((Object)ClassWriter.getIdentifierStrForChar((char)'\n'));
        TestClassWriter.assertEquals((String)"x", (String)ClassWriter.getIdentifierStrForChar((char)'x'));
        TestClassWriter.assertEquals((String)"_", (String)ClassWriter.getIdentifierStrForChar((char)'-'));
        TestClassWriter.assertEquals((String)"_", (String)ClassWriter.getIdentifierStrForChar((char)'_'));
        TestClassWriter.assertEquals((String)"foo", (String)ClassWriter.toJavaIdentifier((String)"foo"));
        TestClassWriter.assertEquals((String)"_class", (String)ClassWriter.toJavaIdentifier((String)"class"));
        TestClassWriter.assertEquals((String)"_class", (String)ClassWriter.toJavaIdentifier((String)"cla ss"));
        TestClassWriter.assertEquals((String)"_int", (String)ClassWriter.toJavaIdentifier((String)"int"));
        TestClassWriter.assertEquals((String)"thisismanywords", (String)ClassWriter.toJavaIdentifier((String)"this is many words"));
        TestClassWriter.assertEquals((String)"_9isLegalInSql", (String)ClassWriter.toJavaIdentifier((String)"9isLegalInSql"));
        TestClassWriter.assertEquals((String)"____", (String)ClassWriter.toJavaIdentifier((String)"___"));
        TestClassWriter.assertEquals((String)"__class", (String)ClassWriter.toJavaIdentifier((String)"_class"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeirdColumnNames() throws SQLException {
        String tableName = HsqldbTestServer.getTableName();
        Connection connection = this.testServer.getConnection();
        Statement st = connection.createStatement();
        try {
            st.executeUpdate("DROP TABLE " + tableName + " IF EXISTS");
            st.executeUpdate("CREATE TABLE " + tableName + " (class INT, \"9field\" INT)");
            st.executeUpdate("INSERT INTO " + tableName + " VALUES(42, 41)");
            connection.commit();
        }
        finally {
            st.close();
            connection.close();
        }
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--package-name", OVERRIDE_PACKAGE_NAME};
        this.runGenerationTest(argv, "special.userpackage.name." + HsqldbTestServer.getTableName());
    }

    @Test
    public void testEqualsMethod() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--class-name", OVERRIDE_CLASS_AND_PACKAGE_NAME};
        File ormJarFile = this.runGenerationTest(argv, OVERRIDE_CLASS_AND_PACKAGE_NAME);
        ClassLoader prevClassLoader = ClassLoaderStack.addJarFile((String)ormJarFile.getCanonicalPath(), (String)OVERRIDE_CLASS_AND_PACKAGE_NAME);
        Class<?> tableClass = Class.forName(OVERRIDE_CLASS_AND_PACKAGE_NAME, true, Thread.currentThread().getContextClassLoader());
        Method setterIntField1 = tableClass.getMethod("set_INTFIELD1", Integer.class);
        Method setterIntField2 = tableClass.getMethod("set_INTFIELD2", Integer.class);
        Method equalsImplementation = tableClass.getMethod("equals", Object.class);
        Object instance1 = tableClass.newInstance();
        Object instance2 = tableClass.newInstance();
        TestClassWriter.assertTrue((boolean)((Boolean)equalsImplementation.invoke(instance1, instance1)));
        TestClassWriter.assertTrue((boolean)((Boolean)equalsImplementation.invoke(instance1, instance2)));
        TestClassWriter.assertTrue((boolean)((Boolean)equalsImplementation.invoke(instance2, instance1)));
        setterIntField1.invoke(instance1, new Integer(1));
        setterIntField2.invoke(instance1, new Integer(2));
        TestClassWriter.assertTrue((boolean)((Boolean)equalsImplementation.invoke(instance1, instance1)));
        setterIntField1.invoke(instance2, new Integer(3));
        setterIntField2.invoke(instance2, new Integer(4));
        TestClassWriter.assertFalse((boolean)((Boolean)equalsImplementation.invoke(instance1, instance2)));
        setterIntField1.invoke(instance2, new Integer(1));
        setterIntField2.invoke(instance2, new Integer(3));
        TestClassWriter.assertFalse((boolean)((Boolean)equalsImplementation.invoke(instance1, instance2)));
        setterIntField1.invoke(instance2, new Integer(3));
        setterIntField2.invoke(instance2, new Integer(2));
        TestClassWriter.assertFalse((boolean)((Boolean)equalsImplementation.invoke(instance1, instance2)));
        setterIntField1.invoke(instance2, new Integer(1));
        setterIntField2.invoke(instance2, new Integer(2));
        TestClassWriter.assertTrue((boolean)((Boolean)equalsImplementation.invoke(instance1, instance2)));
        if (null != prevClassLoader) {
            ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        }
    }

    @Test
    public void testUserMapping() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--class-name", USERMAPPING_CLASS_AND_PACKAGE_NAME, "--map-column-java", "INTFIELD1=String"};
        File ormJarFile = this.runGenerationTest(argv, USERMAPPING_CLASS_AND_PACKAGE_NAME);
        ClassLoader prevClassLoader = ClassLoaderStack.addJarFile((String)ormJarFile.getCanonicalPath(), (String)USERMAPPING_CLASS_AND_PACKAGE_NAME);
        Class<?> tableClass = Class.forName(USERMAPPING_CLASS_AND_PACKAGE_NAME, true, Thread.currentThread().getContextClassLoader());
        try {
            Field intfield = tableClass.getDeclaredField("INTFIELD1");
            TestClassWriter.assertEquals(String.class, intfield.getType());
        }
        catch (NoSuchFieldException ex) {
            TestClassWriter.fail((String)"Can't find field for INTFIELD1");
        }
        catch (SecurityException ex) {
            TestClassWriter.fail((String)"Can't find field for INTFIELD1");
        }
        if (null != prevClassLoader) {
            ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        }
    }

    @Test
    public void testBrokenUserMapping() throws Exception {
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR, "--class-name", USERMAPPING_CLASS_AND_PACKAGE_NAME, "--map-column-java", "INTFIELD1=NotARealClass"};
        try {
            this.runGenerationTest(argv, USERMAPPING_CLASS_AND_PACKAGE_NAME);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        TestClassWriter.fail((String)"we shouldn't successfully generate code");
    }

    private void runFailedGenerationTest(String[] argv, String classNameToCheck) {
        File codeGenDirFile = new File(CODE_GEN_DIR);
        File classGenDirFile = new File(JAR_GEN_DIR);
        try {
            this.options = new ImportTool().parseArguments(argv, null, this.options, true);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not parse options: " + e.toString()));
        }
        CompilationManager compileMgr = new CompilationManager(this.options);
        ClassWriter writer = new ClassWriter(this.options, this.manager, HsqldbTestServer.getTableName(), compileMgr);
        try {
            writer.generate();
            compileMgr.compile();
            TestClassWriter.fail((String)"ORM class file generation succeeded when it was expected to fail");
        }
        catch (Exception ioe) {
            LOG.error((Object)("Got Exception from ORM generation as expected : " + ioe.toString()));
        }
    }

    @Test
    public void testNoClassGeneration() throws Exception {
        this.manager = new DummyDirectManager();
        String[] argv = new String[]{"--bindir", JAR_GEN_DIR, "--outdir", CODE_GEN_DIR};
        this.runFailedGenerationTest(argv, HsqldbTestServer.getTableName());
    }

    public static class DummyDirectManager
    extends TestConnFactory.DummyManager {
        public boolean isORMFacilitySelfManaged() {
            return true;
        }
    }
}

