/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.DirectMySQLManager;
import com.cloudera.sqoop.manager.MySQLManager;
import com.cloudera.sqoop.manager.MySQLTestUtils;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DirectMySQLTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)DirectMySQLTest.class.getName());
    static final String TABLE_PREFIX = "EMPLOYEES_MYSQL_";
    private DirectMySQLManager manager;

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(MySQLTestUtils.CONNECT_STRING, this.getTableName());
        options.setUsername(MySQLTestUtils.getCurrentUser());
        LOG.debug((Object)("Setting up another DirectMySQLTest: " + MySQLTestUtils.CONNECT_STRING));
        this.manager = new DirectMySQLManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS " + this.getTableName());
            st.executeUpdate("CREATE TABLE " + this.getTableName() + " (" + "id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, " + "name VARCHAR(24) NOT NULL, " + "overly_large_number INT UNSIGNED," + "start_date DATE, " + "salary FLOAT, " + "dept VARCHAR(32))");
            st.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "NULL,'Aaron',0,'2009-05-14',1000000.00,'engineering')");
            st.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "NULL,'Bob',100,'2009-04-20',400.00,'sales')");
            st.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "NULL,'Fred',4000000000,'2009-01-23',15.00,'marketing')");
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            DirectMySQLTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (null != this.manager) {
            try {
                this.manager.close();
                this.manager = null;
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException: " + sqlE.toString()));
                DirectMySQLTest.fail((String)("Got SQLException: " + sqlE.toString()));
            }
        }
    }

    private String[] getArgv(boolean mysqlOutputDelims, boolean isDirect, String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(MySQLTestUtils.CONNECT_STRING);
        if (isDirect) {
            args.add("--direct");
        }
        args.add("--username");
        args.add(MySQLTestUtils.getCurrentUser());
        args.add("--where");
        args.add("id > 1");
        args.add("--num-mappers");
        args.add("1");
        if (mysqlOutputDelims) {
            args.add("--mysql-delimiters");
        }
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                args.add(arg);
            }
        }
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport(boolean mysqlOutputDelims, boolean isDirect, String tableName, String[] expectedResults, String[] extraArgs) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, tableName);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(mysqlOutputDelims, isDirect, tableName, extraArgs);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            DirectMySQLTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        DirectMySQLTest.assertTrue((String)("Could not find imported data file: " + f), (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                DirectMySQLTest.assertEquals((String)expectedLine, (String)r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                DirectMySQLTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    @Test
    public void testDirectBulkImportWithDefaultDelims() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,100,2009-04-20,400,sales", "3,Fred,4000000000,2009-01-23,15,marketing"};
        this.doImport(false, true, this.getTableName(), expectedResults, null);
    }

    @Test
    public void testWithExtraParams() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,100,2009-04-20,400,sales", "3,Fred,4000000000,2009-01-23,15,marketing"};
        String[] extraArgs = new String[]{"--", "--lock-tables"};
        this.doImport(false, true, this.getTableName(), expectedResults, extraArgs);
    }

    @Test
    public void testMultiMappers() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,100,2009-04-20,400,sales", "3,Fred,4000000000,2009-01-23,15,marketing"};
        String[] extraArgs = new String[]{"-m", "2"};
        this.doImport(false, true, this.getTableName(), expectedResults, extraArgs);
    }

    @Test
    public void testJdbcColumnSubset() throws IOException {
        LOG.info((Object)"Starting JDBC Column Subset test.");
        String[] expectedResults = new String[]{"2,Bob,400.0", "3,Fred,15.0"};
        String[] extraArgs = new String[]{"--columns", "id,name,salary"};
        this.doImport(false, false, this.getTableName(), expectedResults, extraArgs);
    }

    @Test
    public void testDirectColumnSubset() throws IOException {
        LOG.info((Object)"Starting Direct Column Subset test.");
        String[] expectedResults = new String[]{"2,Bob,400.0", "3,Fred,15.0"};
        String[] extraArgs = new String[]{"--columns", "id,name,salary"};
        this.doImport(false, true, this.getTableName(), expectedResults, extraArgs);
    }

    @Test
    public void testDirectBulkImportWithMySQLQuotes() throws IOException {
        String[] expectedResults = new String[]{"2,'Bob',100,'2009-04-20',400,'sales'", "3,'Fred',4000000000,'2009-01-23',15,'marketing'"};
        this.doImport(true, true, this.getTableName(), expectedResults, null);
    }

    @Test
    public void testMySQLJdbcImport() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,100,2009-04-20,400.0,sales", "3,Fred,4000000000,2009-01-23,15.0,marketing"};
        this.doImport(false, false, this.getTableName(), expectedResults, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJdbcEscapedTableName() throws Exception {
        String RESERVED_TABLE_NAME = "TABLE";
        SqoopOptions options = new SqoopOptions(MySQLTestUtils.CONNECT_STRING, "TABLE");
        options.setUsername(MySQLTestUtils.getCurrentUser());
        MySQLManager mgr = new MySQLManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = mgr.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS `TABLE`");
            st.executeUpdate("CREATE TABLE `TABLE` (id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, name VARCHAR(24) NOT NULL, start_date DATE, salary FLOAT, dept VARCHAR(32))");
            st.executeUpdate("INSERT INTO `TABLE` VALUES(2,'Aaron','2009-05-14',1000000.00,'engineering')");
            connection.commit();
        }
        finally {
            if (null != st) {
                st.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
        String[] expectedResults = new String[]{"2,Aaron,2009-05-14,1000000.0,engineering"};
        this.doImport(false, false, "TABLE", expectedResults, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJdbcEscapedColumnName() throws Exception {
        String TABLE_NAME = "mysql_escaped_col_table";
        this.setCurTableName("mysql_escaped_col_table");
        SqoopOptions options = new SqoopOptions(MySQLTestUtils.CONNECT_STRING, "mysql_escaped_col_table");
        options.setUsername(MySQLTestUtils.getCurrentUser());
        MySQLManager mgr = new MySQLManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = mgr.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS mysql_escaped_col_table");
            st.executeUpdate("CREATE TABLE mysql_escaped_col_table (id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, `table` VARCHAR(24) NOT NULL, `CREATE` DATE, salary FLOAT, dept VARCHAR(32))");
            st.executeUpdate("INSERT INTO mysql_escaped_col_table VALUES(2,'Aaron','2009-05-14',1000000.00,'engineering')");
            connection.commit();
        }
        finally {
            if (null != st) {
                st.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
        String[] expectedResults = new String[]{"2,Aaron,2009-05-14,1000000.0,engineering"};
        this.doImport(false, false, "mysql_escaped_col_table", expectedResults, null);
    }
}

