/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Before;

public abstract class HBaseTestCase
extends ImportJobTestCase {
    private static String testBuildDataProperty = "";
    public static final Log LOG = LogFactory.getLog((String)HBaseTestCase.class.getName());
    private HBaseTestingUtility hbaseTestUtil;
    private String workDir = HBaseTestCase.createTempDir().getAbsolutePath();
    private MiniZooKeeperCluster zookeeperCluster;
    private MiniHBaseCluster hbaseCluster;

    private static void recordTestBuildDataProperty() {
        testBuildDataProperty = System.getProperty("test.build.data", "");
    }

    private static void restoreTestBuidlDataProperty() {
        System.setProperty("test.build.data", testBuildDataProperty);
    }

    protected String[] getArgv(boolean includeHadoopFlags, String hbaseTable, String hbaseColFam, boolean hbaseCreate, String queryStr) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
            args.add("-D");
            args.add("hbase.zookeeper.property.clientPort=21818");
        }
        if (null != queryStr) {
            args.add("--query");
            args.add(queryStr);
        } else {
            args.add("--table");
            args.add(this.getTableName());
        }
        args.add("--split-by");
        args.add(this.getColName(0));
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--num-mappers");
        args.add("1");
        args.add("--column-family");
        args.add(hbaseColFam);
        args.add("--hbase-table");
        args.add(hbaseTable);
        if (hbaseCreate) {
            args.add("--hbase-create-table");
        }
        return args.toArray(new String[0]);
    }

    @Override
    @Before
    public void setUp() {
        try {
            String hostAndPort;
            Method m;
            HBaseTestCase.recordTestBuildDataProperty();
            String hbaseDir = new File(this.workDir, "hbase").getAbsolutePath();
            String hbaseRoot = "file://" + hbaseDir;
            Configuration hbaseConf = HBaseConfiguration.create();
            hbaseConf.set("hbase.rootdir", hbaseRoot);
            hbaseConf.setInt("hbase.zookeeper.property.clientPort", 21818);
            hbaseConf.set("hbase.zookeeper.quorum", "0.0.0.0");
            hbaseConf.setInt("hbase.master.info.port", -1);
            hbaseConf.setInt("hbase.zookeeper.property.maxClientCnxns", 500);
            String zookeeperDir = new File(this.workDir, "zk").getAbsolutePath();
            int zookeeperPort = 21818;
            this.zookeeperCluster = new MiniZooKeeperCluster();
            Class[] zkParam = new Class[]{Integer.TYPE};
            try {
                m = MiniZooKeeperCluster.class.getDeclaredMethod("setDefaultClientPort", zkParam);
            }
            catch (NoSuchMethodException e) {
                m = MiniZooKeeperCluster.class.getDeclaredMethod("setClientPort", zkParam);
            }
            m.invoke((Object)this.zookeeperCluster, new Integer(zookeeperPort));
            this.zookeeperCluster.startup(new File(zookeeperDir));
            this.hbaseCluster = new MiniHBaseCluster(hbaseConf, 1);
            HMaster master = this.hbaseCluster.getMaster();
            ServerName serverName = master.getServerName();
            if (serverName instanceof String) {
                System.out.println("Server name is string, using HServerAddress.");
                m = HMaster.class.getDeclaredMethod("getMasterAddress", new Class[0]);
                Class<?> clazz = Class.forName("org.apache.hadoop.hbase.HServerAddress");
                Object serverAddr = clazz.cast(m.invoke((Object)master, new Object[0]));
                hostAndPort = serverAddr.toString();
            } else {
                System.out.println("ServerName is org.apache.hadoop.hbase.ServerName,using getHostAndPort()");
                Class<?> clazz = Class.forName("org.apache.hadoop.hbase.ServerName");
                m = clazz.getDeclaredMethod("getHostAndPort", new Class[0]);
                hostAndPort = m.invoke((Object)serverName, new Object[0]).toString();
            }
            hbaseConf.set("hbase.master", hostAndPort);
            this.hbaseTestUtil = new HBaseTestingUtility(hbaseConf);
            this.hbaseTestUtil.setZkCluster(this.zookeeperCluster);
            this.hbaseCluster.startMaster();
            super.setUp();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() throws Exception {
        LOG.info((Object)"In shutdown() method");
        if (null != this.hbaseTestUtil) {
            LOG.info((Object)"Shutting down HBase cluster");
            this.hbaseCluster.shutdown();
            this.zookeeperCluster.shutdown();
            this.hbaseTestUtil = null;
        }
        FileUtils.deleteDirectory((File)new File(this.workDir));
        LOG.info((Object)"shutdown() method returning.");
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.shutdown();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error shutting down HBase minicluster: " + StringUtils.stringifyException((Throwable)e)));
        }
        HBaseTestCase.restoreTestBuidlDataProperty();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyHBaseCell(String tableName, String rowKey, String colFamily, String colName, String val) throws IOException {
        Get get = new Get(Bytes.toBytes((String)rowKey));
        get.addColumn(Bytes.toBytes((String)colFamily), Bytes.toBytes((String)colName));
        HTable table = new HTable(new Configuration(this.hbaseTestUtil.getConfiguration()), Bytes.toBytes((String)tableName));
        try {
            Result r = table.get(get);
            byte[] actualVal = r.getValue(Bytes.toBytes((String)colFamily), Bytes.toBytes((String)colName));
            if (null == val) {
                HBaseTestCase.assertNull((String)"Got a result when expected null", (Object)actualVal);
            } else {
                HBaseTestCase.assertNotNull((String)"No result, but we expected one", (Object)actualVal);
                HBaseTestCase.assertEquals((String)val, (String)Bytes.toString((byte[])actualVal));
            }
        }
        finally {
            table.close();
        }
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        File tempDir = new File(baseDir, UUID.randomUUID().toString());
        if (tempDir.mkdir()) {
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countHBaseTable(String tableName, String colFamily) throws IOException {
        int count = 0;
        HTable table = new HTable(new Configuration(this.hbaseTestUtil.getConfiguration()), Bytes.toBytes((String)tableName));
        try {
            ResultScanner scanner = table.getScanner(Bytes.toBytes((String)colFamily));
            Result result = scanner.next();
            while (result != null) {
                ++count;
                result = scanner.next();
            }
        }
        finally {
            table.close();
        }
        return count;
    }
}

