/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class TestExportUpdate
extends ExportJobTestCase {
    @Override
    protected String getTablePrefix() {
        return "UPDATE_TABLE_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabase(int numRows) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("CREATE TABLE " + this.getTableName() + " (A INT NOT NULL, B VARCHAR(32), C INT)");
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
            statement = null;
        }
        try {
            for (int i = 0; i < numRows; ++i) {
                statement = conn.prepareStatement("INSERT INTO " + this.getTableName() + " VALUES (" + i + ", 'foo" + i + "', " + i + ")");
                statement.executeUpdate();
                statement.close();
                statement = null;
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMultiKeyTable(int aMax) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("CREATE TABLE " + this.getTableName() + " (A INT NOT NULL, B INT NOT NULL, C VARCHAR(32))");
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
            statement = null;
        }
        try {
            for (int i = 0; i < aMax; ++i) {
                for (int j = 0; j < 3; ++j) {
                    statement = conn.prepareStatement("INSERT INTO " + this.getTableName() + " VALUES (" + i + ", " + j + ", '" + i + "foo" + j + "')");
                    statement.executeUpdate();
                    statement.close();
                    statement = null;
                }
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        conn.commit();
    }

    private void createMultiKeyUpdateFiles(int numFiles, int aKeysPerFile, int startAtValue, int[] bKeyValues) throws IOException {
        Configuration conf = this.getConf();
        if (!TestExportUpdate.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        int aValue = startAtValue;
        for (int i = 0; i < numFiles; ++i) {
            FSDataOutputStream os = fs.create(new Path(this.getTablePath(), "" + i + ".txt"));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
            for (int j = 0; j < aKeysPerFile; ++j) {
                for (int k = 0; k < bKeyValues.length; ++k) {
                    w.write(this.getUpdateStringForMultiKeyRow(aValue, bKeyValues[k]));
                }
                ++aValue;
            }
            w.close();
            os.close();
        }
    }

    private String getUpdateStringForMultiKeyRow(int a, int b) {
        StringBuilder sb = new StringBuilder();
        sb.append(a).append("\t").append(b).append("\t").append(a);
        sb.append("bar").append(b).append("\n");
        return sb.toString();
    }

    private void createUpdateFiles(int numFiles, int updatesPerFile, int keyCol, int ... startOffsets) throws IOException {
        Configuration conf = this.getConf();
        if (!TestExportUpdate.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        int rowId = 0;
        for (int i = 0; i < numFiles; ++i) {
            FSDataOutputStream os = fs.create(new Path(this.getTablePath(), "" + i + ".txt"));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
            if (null != startOffsets && startOffsets.length > i) {
                rowId = startOffsets[i];
            }
            for (int j = 0; j < updatesPerFile; ++j) {
                w.write(this.getUpdateStringForRow(keyCol, rowId++));
            }
            w.close();
            os.close();
        }
    }

    private String getUpdateStringForRow(int keyCol, int rowId) {
        StringBuilder sb = new StringBuilder();
        int[] rowInts = new int[3];
        for (int i = 0; i < 3; ++i) {
            rowInts[i] = keyCol == i ? rowId : rowId * 2;
        }
        sb.append(rowInts[0]);
        sb.append("\tfoo");
        sb.append(rowInts[1]);
        sb.append("\t");
        sb.append(rowInts[2]);
        sb.append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRowCount(int expectedCount) throws SQLException {
        String query = "SELECT COUNT(*) FROM " + this.getTableName();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            Connection conn = this.getConnection();
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            boolean success = rs.next();
            TestExportUpdate.assertTrue((String)"Expected at least one result", (boolean)success);
            int trueCount = rs.getInt(1);
            TestExportUpdate.assertEquals((int)expectedCount, (int)trueCount);
            success = rs.next();
            TestExportUpdate.assertFalse((String)"Expected no more than one output record", (boolean)success);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    LOG.error((Object)("Error closing result set: " + StringUtils.stringifyException((Throwable)sqle)));
                }
            }
            if (null != statement) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMultiKeyRow(String[] keyColumnNames, int[] keyValues, Object ... expectedVals) throws SQLException {
        StringBuilder querySb = new StringBuilder("SELECT A, B, C FROM ");
        querySb.append(this.getTableName()).append(" WHERE ");
        boolean first = true;
        for (int i = 0; i < keyColumnNames.length; ++i) {
            if (first) {
                first = false;
            } else {
                querySb.append(" AND ");
            }
            querySb.append(keyColumnNames[i]).append(" = ");
            querySb.append(keyValues[i]);
        }
        String query = querySb.toString();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            Connection conn = this.getConnection();
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            boolean success = rs.next();
            TestExportUpdate.assertTrue((String)"Expected at least one output record", (boolean)success);
            for (int i = 0; i < expectedVals.length; ++i) {
                String expected = expectedVals[i].toString();
                String result = rs.getString(i + 1);
                TestExportUpdate.assertEquals((String)("Invalid response for column " + i + "; got " + result + " when expected " + expected), (String)expected, (String)result);
            }
            success = rs.next();
            TestExportUpdate.assertFalse((String)"Expected no more than one output record", (boolean)success);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    LOG.error((Object)("Error closing result set: " + StringUtils.stringifyException((Throwable)sqle)));
                }
            }
            if (null != statement) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRow(String keyColName, String keyVal, String ... expectedVals) throws SQLException {
        String query = "SELECT A, B, C FROM " + this.getTableName() + " WHERE " + keyColName + " = " + keyVal;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            Connection conn = this.getConnection();
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            boolean success = rs.next();
            TestExportUpdate.assertTrue((String)"Expected at least one output record", (boolean)success);
            for (int i = 0; i < expectedVals.length; ++i) {
                String expected = expectedVals[i];
                String result = rs.getString(i + 1);
                TestExportUpdate.assertEquals((String)("Invalid response for column " + i + "; got " + result + " when expected " + expected), (String)expected, (String)result);
            }
            success = rs.next();
            TestExportUpdate.assertFalse((String)"Expected no more than one output record", (boolean)success);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    LOG.error((Object)("Error closing result set: " + StringUtils.stringifyException((Throwable)sqle)));
                }
            }
            if (null != statement) {
                statement.close();
            }
        }
    }

    private void runUpdate(int numMappers, String updateCol) throws IOException {
        this.runExport(this.getArgv(true, 2, 2, "-m", "" + numMappers, "--update-key", updateCol));
    }

    public void testBasicUpdate() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(1, 10, 0, 0);
        this.runUpdate(1, "A");
        this.verifyRowCount(10);
        this.verifyRow("A", "0", "0", "foo0", "0");
        this.verifyRow("A", "1", "1", "foo2", "2");
        this.verifyRow("A", "9", "9", "foo18", "18");
    }

    public void testMultiKeyUpdate() throws Exception {
        this.createMultiKeyTable(3);
        this.createMultiKeyUpdateFiles(1, 1, 1, new int[]{0, 1, 3});
        this.runExport(this.getArgv(true, 2, 2, "-m", "1", "--update-key", "A,B"));
        this.verifyRowCount(9);
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 0}, 0, 0, "0foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 1}, 0, 1, "0foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 2}, 0, 2, "0foo2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 0}, 1, 0, "1bar0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 1}, 1, 1, "1bar1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 2}, 1, 2, "1foo2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 0}, 2, 0, "2foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 1}, 2, 1, "2foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 2}, 2, 2, "2foo2");
    }

    public void testMultiKeyUpdateMultipleFilesNoUpdate() throws Exception {
        this.createMultiKeyTable(4);
        this.createMultiKeyUpdateFiles(2, 1, 1, new int[]{3, 4, 5});
        this.runExport(this.getArgv(true, 2, 2, "-m", "1", "--update-key", "A,B"));
        this.verifyRowCount(12);
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 0}, 0, 0, "0foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 1}, 0, 1, "0foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 2}, 0, 2, "0foo2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 0}, 1, 0, "1foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 1}, 1, 1, "1foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 2}, 1, 2, "1foo2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 0}, 2, 0, "2foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 1}, 2, 1, "2foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 2}, 2, 2, "2foo2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 0}, 3, 0, "3foo0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 1}, 3, 1, "3foo1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 2}, 3, 2, "3foo2");
    }

    public void testMultiKeyUpdateMultipleFilesFullUpdate() throws Exception {
        this.createMultiKeyTable(4);
        this.createMultiKeyUpdateFiles(2, 2, 0, new int[]{0, 1, 2});
        this.runExport(this.getArgv(true, 2, 2, "-m", "1", "--update-key", "A,B"));
        this.verifyRowCount(12);
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 0}, 0, 0, "0bar0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 1}, 0, 1, "0bar1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{0, 2}, 0, 2, "0bar2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 0}, 1, 0, "1bar0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 1}, 1, 1, "1bar1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{1, 2}, 1, 2, "1bar2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 0}, 2, 0, "2bar0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 1}, 2, 1, "2bar1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{2, 2}, 2, 2, "2bar2");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 0}, 3, 0, "3bar0");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 1}, 3, 1, "3bar1");
        this.verifyMultiKeyRow(new String[]{"A", "B"}, new int[]{3, 2}, 3, 2, "3bar2");
    }

    public void testEmptyTable() throws Exception {
        this.populateDatabase(0);
        this.createUpdateFiles(1, 10, 0, 0);
        this.runUpdate(1, "A");
        this.verifyRowCount(0);
    }

    public void testEmptyFiles() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(1, 0, 0, new int[0]);
        this.runUpdate(1, "A");
        this.verifyRowCount(10);
        this.verifyRow("A", "0", "0", "foo0", "0");
        this.verifyRow("A", "1", "1", "foo1", "1");
        this.verifyRow("A", "9", "9", "foo9", "9");
    }

    public void testStringCol() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(1, 10, 1, new int[0]);
        this.runUpdate(1, "B");
        this.verifyRowCount(10);
        this.verifyRow("B", "'foo0'", "0", "foo0", "0");
        this.verifyRow("B", "'foo1'", "2", "foo1", "2");
        this.verifyRow("B", "'foo9'", "18", "foo9", "18");
    }

    public void testLastCol() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(1, 10, 2, new int[0]);
        this.runUpdate(1, "C");
        this.verifyRowCount(10);
        this.verifyRow("C", "0", "0", "foo0", "0");
        this.verifyRow("C", "1", "2", "foo2", "1");
        this.verifyRow("C", "9", "18", "foo18", "9");
    }

    public void testMultiMaps() throws Exception {
        this.populateDatabase(20);
        this.createUpdateFiles(2, 10, 0, new int[0]);
        this.runUpdate(1, "A");
        this.verifyRowCount(20);
        this.verifyRow("A", "0", "0", "foo0", "0");
        this.verifyRow("A", "1", "1", "foo2", "2");
        this.verifyRow("A", "9", "9", "foo18", "18");
        this.verifyRow("A", "10", "10", "foo20", "20");
        this.verifyRow("A", "15", "15", "foo30", "30");
        this.verifyRow("A", "19", "19", "foo38", "38");
    }

    public void testSubsetUpdate() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(1, 5, 0, 3);
        this.runUpdate(1, "A");
        this.verifyRowCount(10);
        this.verifyRow("A", "0", "0", "foo0", "0");
        this.verifyRow("A", "2", "2", "foo2", "2");
        this.verifyRow("A", "8", "8", "foo8", "8");
        this.verifyRow("A", "9", "9", "foo9", "9");
        this.verifyRow("A", "3", "3", "foo6", "6");
        this.verifyRow("A", "5", "5", "foo10", "10");
        this.verifyRow("A", "7", "7", "foo14", "14");
    }

    public void testSubsetUpdate2() throws Exception {
        this.populateDatabase(10);
        this.createUpdateFiles(2, 4, 0, -2, 8);
        this.runUpdate(2, "A");
        this.verifyRowCount(10);
        this.verifyRow("A", "4", "4", "foo4", "4");
        this.verifyRow("A", "7", "7", "foo7", "7");
        this.verifyRow("A", "1", "1", "foo2", "2");
        this.verifyRow("A", "8", "8", "foo16", "16");
        this.verifyRow("A", "9", "9", "foo18", "18");
    }

    public void testUpdateColumnSubset() throws Exception {
        this.populateDatabase(4);
        this.createUpdateFiles(1, 3, 0, new int[0]);
        this.runExport(this.getArgv(true, 2, 2, "-m", "1", "--update-key", "A", "--columns", "A,B"));
        this.verifyRowCount(4);
        this.verifyRow("A", "0", "0", "foo0", "0");
        this.verifyRow("A", "1", "1", "foo2", "1");
        this.verifyRow("A", "2", "2", "foo4", "2");
        this.verifyRow("A", "3", "3", "foo3", "3");
    }

    public void testUpdateColumnNotInColumns() throws Exception {
        this.populateDatabase(1);
        try {
            this.runExport(this.getArgv(true, 2, 2, "-m", "1", "--update-key", "A", "--columns", "B"));
            TestExportUpdate.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            TestExportUpdate.assertTrue((boolean)true);
        }
    }
}

