/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.AppendUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class TestAppendUtils
extends ImportJobTestCase {
    private static final int PARTITION_DIGITS = 5;
    private static final String FILEPART_SEPARATOR = "-";
    public static final Log LOG = LogFactory.getLog((String)TestAppendUtils.class.getName());

    protected ArrayList getOutputlessArgv(boolean includeHadoopFlags, String[] colNames, Configuration conf) {
        if (null == colNames) {
            colNames = this.getColNames();
        }
        String splitByCol = colNames[0];
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-sequencefile");
        args.add("--num-mappers");
        args.add("1");
        args.addAll(this.getExtraArgs(conf));
        return args;
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    protected void runUncleanImport(String[] argv) throws IOException {
        int ret;
        try {
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            Sqoop sqoop = new Sqoop((SqoopTool)new ImportTool(), conf, opts);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            e.printStackTrace();
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Failure during job; return status " + ret);
        }
    }

    private FileStatus[] listFiles(FileSystem fs, Path path) throws IOException {
        FileStatus[] fileStatuses = fs.listStatus(path);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        Pattern patt = Pattern.compile("part.*-([0-9][0-9][0-9][0-9][0-9]).*");
        for (FileStatus fstat : fileStatuses) {
            Matcher mat;
            String fname = fstat.getPath().getName();
            if (fstat.isDir() || !(mat = patt.matcher(fname)).matches()) continue;
            files.add(fstat);
        }
        return files.toArray(new FileStatus[files.size()]);
    }

    private String getFileCreationTimeImage(FileSystem fs, Path outputPath, int fileCount) throws IOException {
        StringBuffer image = new StringBuffer();
        FileStatus[] fileStatuses = this.listFiles(fs, outputPath);
        Arrays.sort(fileStatuses, new StatusPathComparator());
        for (int i = 0; i < fileStatuses.length && i < fileCount; ++i) {
            image.append(fileStatuses[i].getPath() + "=" + fileStatuses[i].getModificationTime());
        }
        return image.toString();
    }

    private int getFilePartition(Path file) {
        String filename = file.getName();
        int pos = filename.lastIndexOf(FILEPART_SEPARATOR);
        if (pos != -1) {
            String part = filename.substring(pos + 1, pos + 1 + 5);
            return Integer.parseInt(part);
        }
        return 0;
    }

    public void runAppendTest(ArrayList args, Path outputPath) throws IOException {
        try {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, true);
            }
            String[] argv = args.toArray(new String[0]);
            this.runUncleanImport(argv);
            FileStatus[] fileStatuses = this.listFiles(fs, outputPath);
            Arrays.sort(fileStatuses, new StatusPathComparator());
            int previousFileCount = fileStatuses.length;
            String previousImage = this.getFileCreationTimeImage(fs, outputPath, previousFileCount);
            Path lastFile = fileStatuses[fileStatuses.length - 1].getPath();
            int lastPartition = this.getFilePartition(lastFile);
            args.add("--append");
            argv = args.toArray(new String[0]);
            this.runUncleanImport(argv);
            fileStatuses = this.listFiles(fs, outputPath);
            Arrays.sort(fileStatuses, new StatusPathComparator());
            int currentFileCount = fileStatuses.length;
            TestAppendUtils.assertTrue((String)"Output directory didn't got increased in file count ", (currentFileCount > previousFileCount ? 1 : 0) != 0);
            String currentImage = this.getFileCreationTimeImage(fs, outputPath, previousFileCount);
            TestAppendUtils.assertEquals((String)"Previous files to appending operation were modified", (String)currentImage, (String)previousImage);
            Path newFile = fileStatuses[previousFileCount].getPath();
            int newPartition = this.getFilePartition(newFile);
            TestAppendUtils.assertTrue((String)"New partition file isn't correlative", (lastPartition + 1 == newPartition ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.error((Object)("Got Exception: " + StringUtils.stringifyException((Throwable)e)));
            TestAppendUtils.fail((String)e.toString());
        }
    }

    public void testAppend() throws IOException {
        ArrayList args = this.getOutputlessArgv(false, HsqldbTestServer.getFieldNames(), this.getConf());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        Path output = new Path(this.getWarehouseDir(), HsqldbTestServer.getTableName());
        this.runAppendTest(args, output);
    }

    public void testAppendToTargetDir() throws IOException {
        ArrayList args = this.getOutputlessArgv(false, HsqldbTestServer.getFieldNames(), this.getConf());
        String targetDir = this.getWarehouseDir() + "/tempTargetDir";
        args.add("--target-dir");
        args.add(targetDir);
        Path output = new Path(targetDir);
        this.runAppendTest(args, output);
    }

    public void testAppendSrcDoesNotExist() throws IOException {
        Configuration conf = new Configuration();
        if (!TestAppendUtils.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        SqoopOptions options = new SqoopOptions(conf);
        options.setTableName("meep");
        Path missingPath = new Path("doesNotExistForAnyReason");
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        TestAppendUtils.assertFalse((boolean)local.exists(missingPath));
        ImportJobContext importContext = new ImportJobContext("meep", null, options, missingPath);
        AppendUtils utils = new AppendUtils(importContext);
        utils.append();
    }

    private class StatusPathComparator
    implements Comparator<FileStatus> {
        private StatusPathComparator() {
        }

        @Override
        public int compare(FileStatus fs1, FileStatus fs2) {
            return fs1.getPath().toString().compareTo(fs2.getPath().toString());
        }
    }
}

