/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SQLServerManagerManualTest
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)SQLServerManagerManualTest.class.getName());
    static final String MISSING_TABLE = "MISSING_TABLE";
    private HsqldbTestServer testServer;
    private ConnManager manager;
    static final int EXPECTED_NUM_ROWS = 4;
    static final int EXPECTED_COL1_SUM = 10;
    static final int EXPECTED_COL2_SUM = 14;
    static final String TABLE_WITH_KEY = "TABLE_WITH_KEY";
    static final String KEY_FIELD_NAME = "KEYFIELD";

    @Before
    public void setUp() {
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.createTableFromSQL("CREATE TABLE TPCH1M_LINEITEM( [L_ORDERKEY] [int] NULL, [L_PARTKEY] [int] NULL, [L_SUPPKEY] [int] NULL, [L_LINENUMBER] [int] NULL, [L_QUANTITY] [int] NULL, [L_EXTENDEDPRICE] [decimal](15, 2) NULL, [L_DISCOUNT] [decimal](15, 2) NULL, [L_TAX] [decimal](15, 2) NULL, [L_RETURNFLAG] [varchar](max) NULL, [L_LINESTATUS] [varchar](max) NULL, [L_SHIPDATE] [varchar](max) NULL, [L_COMMITDATE] [varchar](max) NULL, [L_RECEIPTDATE] [varchar](max) NULL, [L_SHIPINSTRUCT] [varchar](max) NULL, [L_SHIPMODE] [varchar](max) NULL, [L_COMMENT] [varchar](max) NULL) ");
            utils.populateLineItem();
        }
        catch (SQLException e) {
            LOG.error((Object)("Setup fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerManagerManualTest.fail((String)("Setup fail with SQLException: " + e.toString()));
        }
        Configuration conf = this.getConf();
        SqoopOptions opts = this.getSqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        opts.setUsername(username);
        opts.setPassword(password);
        opts.setConnectString(this.getConnectString());
        ConnFactory f = new ConnFactory(conf);
        try {
            this.manager = f.getManager(new JobData(opts, (SqoopTool)new ImportTool()));
            System.out.println("Manger : " + this.manager);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Setup fail with IOException: " + StringUtils.stringifyException((Throwable)ioe)));
            SQLServerManagerManualTest.fail((String)("IOException instantiating manager: " + StringUtils.stringifyException((Throwable)ioe)));
        }
    }

    @After
    public void tearDown() {
        try {
            MSSQLTestUtils utils = new MSSQLTestUtils();
            utils.dropTableIfExists("TPCH1M_LINEITEM");
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            SQLServerManagerManualTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testListColNames() {
        String[] colNames = this.manager.getColumnNames(this.getTableName());
        SQLServerManagerManualTest.assertNotNull((String)"manager returned no colname list", (Object)colNames);
        SQLServerManagerManualTest.assertEquals((String)"Table list should be length 2", (int)16, (int)colNames.length);
        String[] knownFields = MSSQLTestUtils.getColumns();
        for (int i = 0; i < colNames.length; ++i) {
            SQLServerManagerManualTest.assertEquals((String)knownFields[i], (String)colNames[i]);
        }
    }

    @Test
    public void testListColTypes() {
        Map types = this.manager.getColumnTypes(this.getTableName());
        SQLServerManagerManualTest.assertNotNull((String)"manager returned no types map", (Object)types);
        SQLServerManagerManualTest.assertEquals((String)"Map should be size=16", (int)16, (int)types.size());
        SQLServerManagerManualTest.assertEquals((int)((Integer)types.get("L_ORDERKEY")), (int)4);
        SQLServerManagerManualTest.assertEquals((int)((Integer)types.get("L_COMMENT")), (int)12);
    }

    @Test
    public void testMissingTableColNames() {
        String[] colNames = this.manager.getColumnNames(MISSING_TABLE);
        if (colNames == null) {
            SQLServerManagerManualTest.assertNull((String)"No column names should be returned for missing table", (Object)colNames);
        }
        int numItems = colNames.length;
        SQLServerManagerManualTest.assertEquals((int)0, (int)numItems);
    }

    @Test
    public void testMissingTableColTypes() {
        Map colTypes = this.manager.getColumnTypes(MISSING_TABLE);
        SQLServerManagerManualTest.assertNull((String)"No column types should be returned for missing table", (Object)colTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTable() {
        ResultSet results = null;
        try {
            results = this.manager.readTable(this.getTableName(), MSSQLTestUtils.getColumns());
            SQLServerManagerManualTest.assertNotNull((String)"ResultSet from readTable() is null!", (Object)results);
            ResultSetMetaData metaData = results.getMetaData();
            SQLServerManagerManualTest.assertNotNull((String)"ResultSetMetadata is null in readTable()", (Object)metaData);
            SQLServerManagerManualTest.assertEquals((String)"Number of returned columns was unexpected!", (int)metaData.getColumnCount(), (int)16);
            int sumCol1 = 0;
            int sumCol2 = 0;
            int rowCount = 0;
            while (results.next()) {
                ++rowCount;
                sumCol1 += results.getInt(1);
                sumCol2 += results.getInt(2);
            }
            SQLServerManagerManualTest.assertEquals((String)"Expected 4 rows back", (int)4, (int)rowCount);
            SQLServerManagerManualTest.assertEquals((String)"Expected left sum of 10", (int)10, (int)sumCol1);
            SQLServerManagerManualTest.assertEquals((String)"Expected right sum of 14", (int)14, (int)sumCol2);
        }
        catch (SQLException sqlException) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)sqlException));
            SQLServerManagerManualTest.fail((String)("SQL Exception: " + sqlException.toString()));
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                }
                catch (SQLException sqlE) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)sqlE));
                    SQLServerManagerManualTest.fail((String)("SQL Exception in ResultSet.close(): " + sqlE.toString()));
                }
            }
            this.manager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadMissingTable() {
        ResultSet results = null;
        try {
            String[] colNames = new String[]{"*"};
            results = this.manager.readTable(MISSING_TABLE, colNames);
            SQLServerManagerManualTest.assertNull((String)"Expected null resultset from readTable(MISSING_TABLE)", (Object)results);
        }
        catch (SQLException sqlException) {
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                }
                catch (SQLException sqlE) {
                    SQLServerManagerManualTest.fail((String)("SQL Exception in ResultSet.close(): " + sqlE.toString()));
                }
            }
            this.manager.release();
        }
    }

    @Test
    public void testgetPrimaryKeyFromMissingTable() {
        String primaryKey = this.manager.getPrimaryKey(MISSING_TABLE);
        SQLServerManagerManualTest.assertNull((String)"Expected null pkey for missing table", (Object)primaryKey);
    }

    @Test
    public void testgetPrimaryKeyFromTableWithoutKey() {
        String primaryKey = this.manager.getPrimaryKey(this.getTableName());
        SQLServerManagerManualTest.assertNull((String)"Expected null pkey for table without key", (Object)primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testgetPrimaryKeyFromTable() {
        Connection conn = null;
        try {
            conn = this.getManager().getConnection();
            this.dropTableIfExists(TABLE_WITH_KEY);
            PreparedStatement statement = conn.prepareStatement("CREATE TABLE TABLE_WITH_KEY(KEYFIELD INT NOT NULL PRIMARY KEY, foo INT)", 1003, 1007);
            statement.executeUpdate();
            statement.close();
            String primaryKey = this.getManager().getPrimaryKey(TABLE_WITH_KEY);
            SQLServerManagerManualTest.assertEquals((String)"Expected null pkey for table without key", (String)primaryKey, (String)KEY_FIELD_NAME);
        }
        catch (SQLException sqlException) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)sqlException));
            SQLServerManagerManualTest.fail((String)("Could not create table with primary key: " + sqlException.toString()));
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Got SQLException during close: " + sqlE.toString()));
                }
            }
        }
    }

    protected boolean useHsqldbTestServer() {
        return false;
    }

    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opt = new SqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opt;
    }

    SqoopOptions getSqoopOptions(String[] args, SqoopTool tool) {
        SqoopOptions opts = null;
        try {
            opts = tool.parseArguments(args, null, null, true);
            String username = MSSQLTestUtils.getDBUserName();
            String password = MSSQLTestUtils.getDBPassWord();
            opts.setUsername(username);
            opts.setPassword(password);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            SQLServerManagerManualTest.fail((String)("Invalid options: " + e.toString()));
        }
        return opts;
    }

    protected String getTableName() {
        return "tpch1m_lineitem";
    }

    protected ConnManager getManager() {
        return this.manager;
    }

    protected Configuration getConf() {
        return new Configuration();
    }
}

