/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OracleUtils {
    public static final Log LOG = LogFactory.getLog((String)OracleUtils.class.getName());
    public static final String ORACLE_DATABASE_NAME = "xe";
    public static final String CONNECT_STRING = System.getProperty("sqoop.test.oracle.connectstring", "jdbc:oracle:thin:@//localhost/xe");
    public static final String ORACLE_USER_NAME = "SQOOPTEST";
    public static final String ORACLE_USER_PASS = "12345";
    public static final String ORACLE_SECONDARY_USER_NAME = "SQOOPTEST2";
    public static final String ORACLE_SECONDARY_USER_PASS = "ABCDEF";

    private OracleUtils() {
    }

    public static void setOracleAuth(SqoopOptions options) {
        options.setUsername(ORACLE_USER_NAME);
        options.setPassword(ORACLE_USER_PASS);
    }

    public static void setOracleSecondaryUserAuth(SqoopOptions options) {
        options.setUsername(ORACLE_SECONDARY_USER_NAME);
        options.setPassword(ORACLE_SECONDARY_USER_PASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(String tableName, ConnManager manager) throws SQLException {
        Connection connection = null;
        Statement st = null;
        try {
            connection = manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate(OracleUtils.getDropTableStatement(tableName));
            connection.commit();
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    public static String getDropTableStatement(String tableName) {
        return "BEGIN EXECUTE IMMEDIATE 'DROP TABLE " + tableName + "'; " + "exception when others then null; end;";
    }
}

