/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class TestAvroImport
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestAvroImport.class.getName());

    protected String[] getOutputArgv(boolean includeHadoopFlags, String[] extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--as-avrodatafile");
        if (extraArgs != null) {
            args.addAll(Arrays.asList(extraArgs));
        }
        return args.toArray(new String[0]);
    }

    public void testAvroImport() throws IOException {
        this.avroImportTestHelper(null, null);
    }

    public void testDeflateCompressedAvroImport() throws IOException {
        this.avroImportTestHelper(new String[]{"--compression-codec", "org.apache.hadoop.io.compress.DefaultCodec"}, "deflate");
    }

    public void testDefaultCompressedAvroImport() throws IOException {
        this.avroImportTestHelper(new String[]{"--compress"}, "deflate");
    }

    public void testUnsupportedCodec() throws IOException {
        try {
            this.avroImportTestHelper(new String[]{"--compression-codec", "foobar"}, null);
            TestAvroImport.fail((String)"Expected IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void avroImportTestHelper(String[] extraArgs, String codec) throws IOException {
        String[] types = new String[]{"BIT", "INTEGER", "BIGINT", "REAL", "DOUBLE", "VARCHAR(6)", "VARBINARY(2)"};
        String[] vals = new String[]{"true", "100", "200", "1.0", "2.0", "'s'", "'0102'"};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getOutputArgv(true, extraArgs));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        Schema schema = reader.getSchema();
        TestAvroImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestAvroImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "DATA_COL0", Schema.Type.BOOLEAN);
        this.checkField((Schema.Field)fields.get(1), "DATA_COL1", Schema.Type.INT);
        this.checkField((Schema.Field)fields.get(2), "DATA_COL2", Schema.Type.LONG);
        this.checkField((Schema.Field)fields.get(3), "DATA_COL3", Schema.Type.FLOAT);
        this.checkField((Schema.Field)fields.get(4), "DATA_COL4", Schema.Type.DOUBLE);
        this.checkField((Schema.Field)fields.get(5), "DATA_COL5", Schema.Type.STRING);
        this.checkField((Schema.Field)fields.get(6), "DATA_COL6", Schema.Type.BYTES);
        GenericRecord record1 = (GenericRecord)reader.next();
        TestAvroImport.assertEquals((String)"DATA_COL0", (Object)true, (Object)record1.get("DATA_COL0"));
        TestAvroImport.assertEquals((String)"DATA_COL1", (Object)100, (Object)record1.get("DATA_COL1"));
        TestAvroImport.assertEquals((String)"DATA_COL2", (Object)200L, (Object)record1.get("DATA_COL2"));
        TestAvroImport.assertEquals((String)"DATA_COL3", (Object)Float.valueOf(1.0f), (Object)record1.get("DATA_COL3"));
        TestAvroImport.assertEquals((String)"DATA_COL4", (Object)2.0, (Object)record1.get("DATA_COL4"));
        TestAvroImport.assertEquals((String)"DATA_COL5", (Object)new Utf8("s"), (Object)record1.get("DATA_COL5"));
        Object object = record1.get("DATA_COL6");
        TestAvroImport.assertTrue((boolean)(object instanceof ByteBuffer));
        ByteBuffer b = (ByteBuffer)object;
        TestAvroImport.assertEquals((byte)1, (byte)b.get(0));
        TestAvroImport.assertEquals((byte)2, (byte)b.get(1));
        if (codec != null) {
            TestAvroImport.assertEquals((String)codec, (String)reader.getMetaString("avro.codec"));
        }
    }

    public void testOverrideTypeMapping() throws IOException {
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{"10"};
        this.createTableWithColTypes(types, vals);
        String[] extraArgs = new String[]{"--map-column-java", "DATA_COL0=String"};
        this.runImport(this.getOutputArgv(true, extraArgs));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        Schema schema = reader.getSchema();
        TestAvroImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestAvroImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "DATA_COL0", Schema.Type.STRING);
        GenericRecord record1 = (GenericRecord)reader.next();
        TestAvroImport.assertEquals((String)"DATA_COL0", (Object)new Utf8("10"), (Object)record1.get("DATA_COL0"));
    }

    public void testFirstUnderscoreInColumnName() throws IOException {
        String[] names = new String[]{"_NAME"};
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{"1987"};
        this.createTableWithColTypesAndNames(names, types, vals);
        this.runImport(this.getOutputArgv(true, null));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        Schema schema = reader.getSchema();
        TestAvroImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestAvroImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "__NAME", Schema.Type.INT);
        GenericRecord record1 = (GenericRecord)reader.next();
        TestAvroImport.assertEquals((String)"__NAME", (Object)1987, (Object)record1.get("__NAME"));
    }

    private void checkField(Schema.Field field, String name, Schema.Type type) {
        TestAvroImport.assertEquals((String)name, (String)field.name());
        TestAvroImport.assertEquals((Object)Schema.Type.UNION, (Object)field.schema().getType());
        TestAvroImport.assertEquals((Object)type, (Object)((Schema)field.schema().getTypes().get(0)).getType());
        TestAvroImport.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)field.schema().getTypes().get(1)).getType());
    }

    public void testNullableAvroImport() throws IOException, SQLException {
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{null};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getOutputArgv(true, null));
        Path outputFile = new Path(this.getTablePath(), "part-m-00000.avro");
        DataFileReader<GenericRecord> reader = this.read(outputFile);
        GenericRecord record1 = (GenericRecord)reader.next();
        TestAvroImport.assertNull((Object)record1.get("DATA_COL0"));
    }

    private DataFileReader<GenericRecord> read(Path filename) throws IOException {
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FsInput fsInput = new FsInput(filename, conf);
        GenericDatumReader datumReader = new GenericDatumReader();
        return new DataFileReader((SeekableInput)fsInput, (DatumReader)datumReader);
    }
}

